package com.aps.service.plan;

import com.aps.common.util.*;
import com.aps.common.util.redis.RedisUtils;
import com.aps.controller.gantt.FileUploadController;
import com.aps.entity.*;
import com.aps.entity.Algorithm.*;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.IDAndChildID.NodeInfo;
import com.aps.entity.Gantt.ResourceGanttVO;
import com.aps.entity.Gantt.TaskVO;
import com.aps.entity.Schedule.SceneChromsome;
import com.aps.entity.basic.ScheduleChromosome;
import com.aps.entity.Schedule.GenVO;
import com.aps.entity.Schedule.MachineVO;
import com.aps.entity.basic.*;
import com.aps.mapper.*;
import com.aps.service.*;
import com.aps.service.Algorithm.*;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Service
public class PlanResultService {
    // 注入FileUploadController
    @Autowired
    private FileUploadController fileUploadController;

    @Autowired
    private MesHolidayService _MesHolidayService;

    @Autowired
    private ProdEquipSpecialCalService _prodEquipSpecialCalService;

    @Autowired
    private MesShiftWorkSchedService _MesShiftWorkSchedService;


    @Autowired
    private ProdLaunchOrderService _prodLaunchOrderService;

    @Autowired
    private ProdProcessExecService _prodProcessExecService;

    @Autowired
    private ProdEquipmentService _prodEquipmentService;

    @Autowired
    private PlanResourceService _PlanResourceService;

    @Autowired
    private SceneService _sceneService;

    @Autowired
    private ProdOrderProcessService _prodOrderProcessService;

    @Autowired
    private  RoutingDiscreteParamService _routingDiscreteParamService;
    @Autowired
    private  DiscreteParameterMatrixService _discreteParameterMatrixService;

    @Autowired
    private RoutingDataService _routingDataService;

    @Autowired
    private ConfigService _configService;

    @Autowired
    private ConfigMapper configMapper;

    @Autowired
    private ApsTimeConfigMapper apsTimeConfigMapper;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private StrategyRuleService _strategyRuleService;

    @Autowired
    private OrderSortService orderSortService;


    @Autowired
    private MaterialInfoMapper materialInfoMapper;

    @Autowired
    private MaterialPurchaseMapper materialPurchaseMapper;

    @Autowired
    private StockMapper stockMapper;

    @Autowired
    private SjzPfWhStockMapper sjzPfWhStockMapper;

    @Autowired
    private PurchaseReceiptMapper purchaseReceiptMapper;

    @Autowired
    private ErpPurchaseOrderMapper erpPurchaseOrderMapper;

    @Autowired
    private MaterialRequirementService materialRequirementService;
    @Autowired
    private EquipMaintainTaskService _equipMaintainTaskService;
    private  LocalDateTime baseTime = LocalDateTime.of(2025, 11, 1, 0, 0, 0);

    public List<ScheduleChromosome> execute() {
      return  null;
    }



       public Chromosome  execute1() {
        try {

//List<ScheduleResultDetail>  details=new ArrayList<>();
//            ScheduleResultDetail detail1=new ScheduleResultDetail();
//
//            detail1.setOneTime(100);//单件工时
//
//
//            ScheduleResultDetail detail2=new ScheduleResultDetail();
//
//            detail2.setOneTime(200);//单件工时
//            details.add(detail1);
//            details.add(detail2);


          //  mergeSegmentsWithDifferentOneTime(details, 50);
            // 1. 读取数据
            List<Machine> machines = loadData("machines.json", Machine.class);
            List<Product> products = loadData("products.json", Product.class);
            List<Order> orders = loadData("orders.json", Order.class);

            // 设置机器信息到班次中
            for (Machine machine : machines) {
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        shift.setMachineId(machine.getId());
                        shift.setMachineName(machine.getName());
                    }
                }

                // 调试：打印机器和班次信息
                System.out.println("Machine: " + machine.getId() + ", Name: " + machine.getName());
                if (machine.getShifts() != null) {
                    for (Shift shift : machine.getShifts()) {
                        System.out.println("  Shift: " + shift.getStartTime() + " - " + shift.getEndTime() +
                                ", Status: " + shift.getStatus() +
                                ", MachineId: " + shift.getMachineId() +
                                ", MachineName: " + shift.getMachineName());
                    }
                }
            }
            ScheduleParams param = new ScheduleParams();
            param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));


            // List<MesHoliday> holidays=  _MesHolidayService.list();

            // 创建节假日


            // 将节假日添加到所有设备中
           // addHolidaysToAllMachines(machines);

            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                     param.getBaseTime());

            // 4. 初始化机器时间线
            for (Machine machine : machines) {
                MachineTimeline timeline = machineScheduler.getOrCreateTimeline(machine);
                machine.setAvailability(timeline.getSegments());
            }
            // 3. 构建订单-工序数据
            List<Entry> allOperations = new ArrayList<>();
            Random rnd = new Random(); // 注意：此处变量声明但未使用，可根据实际需求保留或移除

            int id = 1;
            for (Order order : orders) {
order.setDueDate(LocalDateTime.of(2025, 12, 1,0,0,0));
                // 假设products是一个List<Product>，根据Product的Id查找对应的产品
                Product product = products.stream()
                        .filter(p -> p.getId() == order.getProductId())
                        .findFirst()
                        .orElseThrow(() -> new IllegalArgumentException("未找到对应产品: " + order.getProductId()));

                int sequence = 1;
                for (Operation o : product.getOperations()) { // 假设Product类有getOperations()方法返回工序列表
                    Entry entry = new Entry();
                    entry.setId(id);
                   // entry.setGroupId(order.getId());
                    entry.setSequence(sequence);
                    entry.setMachineOptions(o.getMachineOptions()); // 假设Operation类有获取机器选项的方法
                    entry.setPriority(order.getPriority());
                    entry.setQuantity(order.getQuantity());
                    // entry.setMaterialRequirements(o.getMaterialRequirements()); // 假设Operation类有获取物料需求的方法

                    if (sequence != 1) {
                        OperationDependency od=new OperationDependency();
                        od.setPrevOperationId(id - 1);

                        entry.getPrevEntryIds().add(od); // 假设Entry类有getPrevEntryIds()返回List<Integer>
                    }

                    allOperations.add(entry);

                    sequence++;
                    id++;
                }
            }
            GlobalParam globalParam=new GlobalParam();
            // 5. 执行调度算法
            param.initAdaptiveParams(allOperations.size());
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,null,machineScheduler,null,materialRequirementService,_sceneService); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            Chromosome Chromosomes =scheduler.Run(param,allOperations);
            WriteScheduleSummary(Chromosomes);
            ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
            LocalDateTime ds=  LocalDateTime.of(2025, 12, 7, 23, 59);
           // ScheduleOperation.moveOperation(Chromosomes,3, (int)ChronoUnit.SECONDS.between(param.getBaseTime(), ds),(Long)2,param.getBaseTime(), globalParam);
           WriteScheduleSummary(Chromosomes);

            return Chromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }

    public Chromosome  execute2(String SceneId) {
        try {


            ScheduleParams param = InitScheduleParams();


            // 1. 读取数据
            //  List<Machine> machines = loadData("machines.json", Machine.class);
            //  List<Product> products = loadData("products.json", Product.class);
            // List<Order> orders = loadData("orders.json", Order.class);

            List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                    .eq(ProdEquipment::getSceneId,SceneId)
                    .list();

            List<ProdLaunchOrder> ProdLaunchOrders=  _prodLaunchOrderService.lambdaQuery()
                    .eq(ProdLaunchOrder::getSceneId,SceneId)
                    .list();
            GlobalParam globalParam=InitGlobalParam();

            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    param.getBaseTime());
            List<Machine> machines= InitCalendarToAllMachines(SceneId, ProdEquipments,machineScheduler,globalParam.isIsUseCalendar());
            // 3. 构建订单-工序数据

           List<Order> orders=InitOrder(ProdLaunchOrders);

            List<Material> Materials= InitMaterial();

            Map<Integer,Object> list= InitEntrys(SceneId,ProdEquipments,orders);
           List<Entry> entrys=(List<Entry>)list.get(1);


            List<GroupResult> entryRel=(List<GroupResult>)list.get(2);

            Map<Long,Double> machineIds=(Map<Long,Double>)list.get(3);

            machines= machines.stream().filter(t->machineIds.containsKey(t.getId())).collect(Collectors.toList());

            for (Machine machine : machines){
                Long machineId=machine.getId();
               if(machineIds.get(machineId)>3600*24*200) {

                   int day = (int) (machineIds.get(machineId) / 3600 / 24)+100;
                   List<TimeSegment> segments = machineScheduler.generateTimeSegment(machine, null, day);
                   machineScheduler.addSegmentsWithDeduplication(machine, segments);

               }
            }

            // 按照优先级排序
            entrys.sort(
                    Comparator.comparing(Entry::getPriority)
            );


            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,Materials,machineScheduler,entryRel,materialRequirementService,_sceneService); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            param.initAdaptiveParams(entrys.size());
            double[] customWeights = new double[] { 0.4, 0.1, 0.1, 0.1, 0.3 }; // 延迟时间权重提升到0.5
            //完工时间、总流程时间、总换型时间、机器负载标准差、延迟时间
            scheduler.Init(customWeights,false);
            Chromosome chromosome =scheduler.Run(param,entrys);

            KpiCalculator kpiCalculator=new KpiCalculator(chromosome);
            kpiCalculator.calculatekpi();
            _sceneService.saveChromosomeToFile(chromosome, SceneId);

         //   WriteScheduleSummary(chromosome);

            return chromosome;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败:"+e.getMessage(), e);
        }
    }


    public Chromosome  editMachineOption(String SceneId, Entry operation,
                            Long newMachineId) {

        Chromosome chromosome = _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome;
        }

        List<Entry> operations = chromosome.getAllOperations();
        int position = IntStream.range(0, operations.size())
                .filter(i -> operations.get(i).getId() == operation.getId())
                .findFirst()
                .orElse(-1);

        if (position != -1) {
            Entry oldEntry = operations.set(position, operation);

            List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();
            if (globalOpList != null) {
                globalOpList.stream()
                        .filter(opInfo -> opInfo.getOp() != null && opInfo.getOp().getId() == oldEntry.getId())
                        .forEach(opInfo -> opInfo.setOp(operation));
            }
        }
        GlobalParam globalParam=new GlobalParam();
//        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);


        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
        WriteScheduleSummary(chromosome);
        ScheduleOperation.editMachineOption(chromosome,operation,newMachineId,globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }


    public Chromosome EditOperation(String SceneId, Entry operation) {
        Chromosome chromosome = _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome;
        }
        
        List<Entry> operations = chromosome.getAllOperations();
        int position = IntStream.range(0, operations.size())
                .filter(i -> operations.get(i).getId() == operation.getId())
                .findFirst()
                .orElse(-1);
        
        if (position != -1) {
            Entry oldEntry = operations.set(position, operation);
            
            List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();
            if (globalOpList != null) {
                globalOpList.stream()
                        .filter(opInfo -> opInfo.getOp() != null && opInfo.getOp().getId() == oldEntry.getId())
                        .forEach(opInfo -> opInfo.setOp(operation));
            }
        }
//        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return redecodeChromosome(chromosome, SceneId);
    }
    
    public Chromosome EditOrder(String SceneId, Order order) {
        Chromosome chromosome = _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getOrders() == null) {
            return chromosome;
        }
        
        List<Order> orders = chromosome.getOrders();
        int position = IntStream.range(0, orders.size())
                .filter(i -> orders.get(i).getId() == order.getId())
                .findFirst()
                .orElse(-1);
        
        if (position != -1) {
            orders.set(position, order);
        }
        
        orderSortService.initializeFieldExtractors();
        OrderSortRule rule = createMultiConditionRule(orders);
        orderSortService.assignPriority(orders, rule);
        
        updateOrderRelatedEntries(chromosome, order);
//        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return redecodeChromosome(chromosome,SceneId);
    }





    public Chromosome editOrder(Chromosome chromosome,String SceneId, Order order) {


        List<Order> orders = chromosome.getOrders();

        orderSortService.initializeFieldExtractors();
        OrderSortRule rule = createMultiConditionRule(orders);
        orderSortService.assignPriority(orders, rule);

        updateOrderRelatedEntries(chromosome, order);
//        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return redecodeChromosome(chromosome,SceneId);
    }


    public Chromosome editOperation(Chromosome chromosome,String SceneId, Entry operation) {



           List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();
            if (globalOpList != null) {
                globalOpList.stream()
                        .filter(opInfo -> opInfo.getOp() != null && opInfo.getOp().getId() == operation.getId())
                        .forEach(opInfo -> opInfo.setOp(operation));
            }
        GlobalParam globalParam=new GlobalParam();
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.editMachineOption(chromosome,operation,operation.getSelectMachineID(),globalParam);

        return redecodeChromosome(chromosome,SceneId);
    }




    public Chromosome  editMachine(Chromosome chromosome,String SceneId, Entry operation) {






            List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();
            if (globalOpList != null) {
                globalOpList.stream()
                        .filter(opInfo -> opInfo.getOp() != null && opInfo.getOp().getId() == operation.getId())
                        .forEach(opInfo -> opInfo.setOp(operation));
            }

//        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return redecodeChromosome(chromosome, SceneId);
    }



    public void UnlockStartTime(String sceneId, int opId) {
        Chromosome chromosome = _sceneService.loadChromosomeFromFile(sceneId);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
        ScheduleOperation.UnlockStartTime(chromosome, opId);
    }


    public void unlockStartTime(Chromosome chromosome, int opId) {

        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
        ScheduleOperation.UnlockStartTime(chromosome, opId);
    }


    /**
     * 更新订单相关的所有Entry的数量和优先级
     */
    private void updateOrderRelatedEntries(Chromosome chromosome, Order order) {
        // 更新所有操作中的Entry
        List<Entry> allOperations = chromosome.getAllOperations();
        if (allOperations != null) {
            allOperations.stream()
                    .filter(entry -> entry.getOrderId() != null && entry.getOrderId().equals(order.getOrderId()))
                    .forEach(entry -> {
                        entry.setQuantity(order.getQuantity());
                        entry.setPriority(order.getActualPriority());
                    });
        }
        
        // 更新GlobalOperationInfo中的Entry
        List<GlobalOperationInfo> globalOpList = chromosome.getGlobalOpList();
        if (globalOpList != null) {
            globalOpList.stream()
                    .map(GlobalOperationInfo::getOp)
                    .filter(entry -> entry != null && entry.getOrderId() != null && entry.getOrderId().equals(order.getOrderId()))
                    .forEach(entry -> {
                        entry.setQuantity(order.getQuantity());
                        entry.setPriority(order.getActualPriority());
                    });
        }
    }
    
    /**
     * 重新解码染色体
     */
    private Chromosome redecodeChromosome(Chromosome chromosome,String SceneId)  {
        GlobalParam globalParam = new GlobalParam();
        ScheduleOperationService scheduleOperation = new ScheduleOperationService();
        scheduleOperation.redecode(chromosome, chromosome.getBaseTime(), globalParam);
//        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return chromosome;
    }

    public Chromosome  ChangeBaseTime(String SceneId,LocalDateTime BaseTime) {
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);
        if (chromosome == null || chromosome.getAllOperations() == null) {
            return chromosome; // 直接返回，空值由上层处理
        }

        chromosome.setBaseTime(BaseTime);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        GlobalParam globalParam=new GlobalParam();
        ScheduleOperation.redecode(chromosome,chromosome.getBaseTime(), globalParam);

        return  chromosome;
    }
    public Chromosome  Drag(String SceneId,List<Integer> opId,  int targetopId,Boolean isfront,
                            Long newMachineId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);


        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperation.dragOperation(chromosome,opId,targetopId,isfront,newMachineId, globalParam);
        // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }
    public Chromosome  Move(String SceneId,List<Integer> opId, LocalDateTime newStartTime,
                            Long newMachineId,int lockStartTime) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);


        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
      //  WriteScheduleSummary(chromosome);
        ScheduleOperation.moveOperation(chromosome,opId, (int)ChronoUnit.SECONDS.between(chromosome.getBaseTime(), newStartTime),newMachineId, globalParam, lockStartTime);
       // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }




    public Chromosome  lock(Chromosome chromosome,List<Integer> opId, LocalDateTime newStartTime,
                            Long newMachineId,int lockStartTime) {


        GlobalParam globalParam=new GlobalParam();



        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperation.moveOperation(chromosome,opId, (int)ChronoUnit.SECONDS.between(chromosome.getBaseTime(), newStartTime),newMachineId, globalParam, lockStartTime);
        // WriteScheduleSummary(chromosome);

        return  chromosome;
    }


    public void   Redecode(String SceneId)
    {
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();
      //  WriteScheduleSummary(chromosome);

        GlobalParam globalParam=new GlobalParam();
        ScheduleOperation.redecode(chromosome, chromosome.getBaseTime(), globalParam);
     //   WriteScheduleSummary(chromosome);
    }



    public Chromosome  SpiltOperation(String SceneId,int opId,Double[] splitCounts) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.SpiltOperation(chromosome,opId,splitCounts, globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  DelOperation(String SceneId,int opId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.DelOperation(chromosome,opId, globalParam);
       // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  DelOrder(String SceneId,String orderId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.DelOrder(chromosome,orderId, globalParam);
        // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }




    public Chromosome  LockOperation(String SceneId,int opId,boolean isLocked) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.LockOperation(chromosome,opId,isLocked, globalParam);
        //WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  SpiltOrder(String SceneId,String orderId,Double[] splitCounts) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.SpiltOrder(chromosome,orderId,splitCounts, globalParam);
        WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }
    public Chromosome  MergeOrder(String SceneId,String sourceorderId,String targetorderId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);

        //this.baseTime=param.getBaseTime();
        //  WriteScheduleSummary(chromosome);
        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.MergeOrder(chromosome,sourceorderId,targetorderId, globalParam);
        WriteScheduleSummary(chromosome);
        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  AddMaintenanceWindow(String SceneId, Long machineId, MaintenanceWindow maintenanceWindow) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);



        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.AddMaintenanceWindow(chromosome,machineId,maintenanceWindow, globalParam);
      // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome  DelMaintenanceWindow(String SceneId, Long machineId,String maintenanceId) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);



        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        ScheduleOperation.DelMaintenanceWindow(chromosome,machineId,maintenanceId, globalParam);
        // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return  chromosome;
    }

    public Chromosome DelMaintenanceWindowBatch(String SceneId, Long machineId, List<String> maintenanceIds) {
        GlobalParam globalParam = new GlobalParam();
        Chromosome chromosome = _sceneService.loadChromosomeFromFile(SceneId);

        ScheduleOperationService ScheduleOperation = new ScheduleOperationService();

        ScheduleOperation.DelMaintenanceWindowBatch(chromosome, machineId, maintenanceIds, globalParam);
        // WriteScheduleSummary(chromosome);

        _sceneService.saveChromosomeToFile(chromosome, SceneId);
        return chromosome;
    }

    public List<MaintenanceWindow>  GetMaintenanceWindow(String SceneId, Long machineId, MaintenanceWindow maintenanceWindow) {


        GlobalParam globalParam=new GlobalParam();
        Chromosome chromosome= _sceneService.loadChromosomeFromFile(SceneId);



        ScheduleOperationService ScheduleOperation=new ScheduleOperationService();

        List<MaintenanceWindow> maintenanceWindowList= ScheduleOperation.GetMaintenanceWindow(chromosome,machineId);
        // WriteScheduleSummary(chromosome);

        return  maintenanceWindowList;
    }



    //场景回退前进
    public Chromosome moveChromosome(String sceneId,Integer version)
    {
       return  _sceneService.moveChromosome( sceneId, version);
    }






    //场景下所有操作版本
    public SceneChromsome getSceneChromsome(String sceneId)
    {
        return  _sceneService.getSceneChromsome( sceneId);
    }



    public Chromosome revertVersion(String sceneId,Integer version)
    {
        return  _sceneService.revertVersion( sceneId, version);
    }
    public void testSceneChromsome(String sceneId)
    {
        Chromosome chromosome=new  Chromosome();

          _sceneService.saveChromosomeToFile(chromosome,sceneId);
    }





    public Chromosome  schedule(String SceneId) {
        try {
            FileHelper.writeLogFile("schedule-----------开始-----------"+SceneId);

            ScheduleParams param = InitScheduleParams();




            // 1. 读取数据
            //  List<Machine> machines = loadData("machines.json", Machine.class);
            //  List<Product> products = loadData("products.json", Product.class);
            // List<Order> orders = loadData("orders.json", Order.class);




            List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                    .eq(ProdEquipment::getSceneId,SceneId)
                    .list();
            GlobalParam globalParam=InitGlobalParam();
            List<ProdLaunchOrder> ProdLaunchOrders=  _prodLaunchOrderService.lambdaQuery()
                    .eq(ProdLaunchOrder::getSceneId,SceneId)
                    .list();
            // 3. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                    param.getBaseTime());
            List<Machine> machines= InitCalendarToAllMachines(SceneId, ProdEquipments,machineScheduler,globalParam.isIsUseCalendar());
            // 3. 构建订单-工序数据

            List<Order> orders=InitOrder(ProdLaunchOrders);

            List<Material> Materials=InitMaterial();
            Map<Integer,Object> list= InitEntrys(SceneId,ProdEquipments,orders);
            List<Entry> entrys=(List<Entry>)list.get(1);
            List<GroupResult> entryRel=(List<GroupResult>)list.get(2);
            entrys.sort(
                    Comparator.comparing(Entry::getPriority)
            );
            Set<Long> machineIds=(Set<Long>)list.get(3);

            machines= machines.stream().filter(t->machineIds.contains(t.getId())).collect(Collectors.toList());

            // 5. 执行调度算法
            GeneticAlgorithm scheduler =new GeneticAlgorithm(globalParam,machines,orders,Materials,machineScheduler,entryRel,materialRequirementService,_sceneService); //new GeneticAlgorithm(products, machines, orders, machineScheduler);
            param.initAdaptiveParams(entrys.size());
            double[] customWeights = new double[] { 0.4, 0.1, 0.1, 0.1, 0.3 }; // 延迟时间权重提升到0.5
            //完工时间、总流程时间、总换型时间、机器负载标准差、延迟时间
            scheduler.Init(customWeights,false);
            Chromosome  chromosomes =scheduler.Run(param,entrys);
            KpiCalculator kpiCalculator=new KpiCalculator(chromosomes);
            kpiCalculator.calculatekpi();
            chromosomes.setScenarioID(SceneId);
            chromosomes.setBaseTime(param.getBaseTime());
            chromosomes.setOperatRel(entryRel);
            // 保存chromosomes到文件
            _sceneService.saveChromosomeToFile(chromosomes, SceneId);

            // Chromosomes.forEach(this::WriteScheduleSummary);
            FileHelper.writeLogFile("schedule-----------结束-----------"+SceneId);
            return chromosomes;

        } catch (Exception e) {
            throw new RuntimeException("调度执行失败", e);
        }
    }


    public void WriteScheduleSummary(Chromosome schedule) {
        // 写入日志
        FileHelper.writeLogFile("\n=== Schedule Summary === ");
        FileHelper.writeLogFile(String.format("ID: %s", schedule.getID()));
        FileHelper.writeLogFile(String.format("ID: %s", schedule.getGeneStr()));

        FileHelper.writeLogFile(String.format("Operation: %s", schedule.getOperationStr()));
        FileHelper.writeLogFile(String.format("Makespan: %f minutes", schedule.getMakespan()));
        FileHelper.writeLogFile(String.format("Total Tardiness: %f hours", schedule.getDelayTime()));
        FileHelper.writeLogFile(String.format("Setup Time: %f minutes", schedule.getTotalChangeoverTime()));
        FileHelper.writeLogFile(String.format("Flow Time: %f minutes", schedule.getTotalFlowTime()));
        FileHelper.writeLogFile(String.format("Machine Load Balance: %.2f%%", schedule.getMachineLoadStd() * 100));
        FileHelper.writeLogFile("-------------------------");

        // 按订单分组写入
        Map<Integer, List<GAScheduleResult>> orderGroups = schedule.getResult().stream()
                .collect(Collectors.groupingBy(GAScheduleResult::getGroupId));

        for (Map.Entry<Integer, List<GAScheduleResult>> group : orderGroups.entrySet()) {
            List<GAScheduleResult> sortedJobs = group.getValue().stream()
                    .sorted(Comparator.comparingInt(GAScheduleResult::getOperationId))
                    .collect(Collectors.toList());

            for (GAScheduleResult job : sortedJobs) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.format(
                            "[%d-%d]:[%s-%s] Order %d,OrderID %s, Machine %d, Operation %d, Batch %.1f, processingTime %.1f, 前处理 %d, 后处理 %d, 离散参数 %d",
                            job.getStartTime(),
                            job.getEndTime(),
                            ConvertTime(job.getStartTime()),
                            ConvertTime(job.getEndTime()),
                            job.getGroupId(),
job.getOrderId(),
                            job.getMachineId(),
                            job.getOperationId(),
                            job.getQuantity(),
                            job.getProcessingTime(),
                            job.getPreTime(),
                            job.getTeardownTime(),
                            job.getChangeOverTime()
                    ));

                    // 追加基因详情
                    for (ScheduleResultDetail d : job.getGeneDetails()) {
                        sb.append(String.format(
                                "\n\t\t\t\t\t\t\t\t\t\t [%d-%d]:[%s-%s] %d",
                                d.getStartTime(),
                                d.getEndTime(),
                                ConvertTime(d.getStartTime()),
                                ConvertTime(d.getEndTime()),
                                d.getEndTime() - d.getStartTime()
                        ));
                    }

                    FileHelper.writeLogFile(sb.toString());

            }
            FileHelper.writeLogFile("");
        }
    }
    private String ConvertTime(int minute) {
        return baseTime.plusSeconds(minute).format(java.time.format.DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm:ss"));
    }

    /**
     * 加载数据，优先从上传文件夹加载，如果不存在则从resources加载
     *
     * @param fileName 文件名
     * @param clazz    类型
     * @param <T>      泛型
     * @return 数据列表
     * @throws IOException IO异常
     */
    private <T> List<T> loadData(String fileName, Class<T> clazz) throws IOException {
        // 检查是否有上传的文件
        if (fileUploadController.isFileUploaded(fileName)) {
            String filePath = fileUploadController.getUploadedFilePath(fileName);
            return JsonFileReader.readListFromFile(filePath, clazz);
        } else {
            // 使用默认的resources文件
            return JsonFileReader.readListFromResources(fileName, clazz);
        }
    }

    /**
     * 将假期添加到所有设备的维护窗口中
     * @param machines 设备列表
     * @param holidays 假期列表
     */
    private void addHolidaysToAllMachines(List<Machine> machines, List<Holiday> holidays) {
        if (machines == null || holidays == null) {
            return;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }

            for (Holiday holiday : holidays) {
                // 将假期转换为维护窗口并添加到设备中
                MaintenanceWindow maintenanceWindow = new MaintenanceWindow(holiday, "Holiday Period");
                machine.addMaintenanceWindow(maintenanceWindow);
            }
        }
    }

    private List<Machine> InitCalendarToAllMachines(String SceneId,List<ProdEquipment> ProdEquipments,MachineSchedulerService machineScheduler,boolean IsUseCalendar) {
        // 按设备分组
        FileHelper.writeLogFile("初始化设备日历-----------开始-------");
        ScheduleParams param = InitScheduleParams();
        List<Machine> machines=new ArrayList<>();
        if(!IsUseCalendar) {


             machines =  _routingDataService.InitNoCalendarToAllMachines(machineScheduler,param.getBaseTime());
        }else {

             machines =  _routingDataService.InitCalendarToAllMachines( machineScheduler,param.getBaseTime());

            //  List<Machine> machines = _routingDataService.InitCalendarToAllMachines(SceneId, ProdEquipments, machineScheduler, IsUseCalendar);
//            List<Machine> machines = (List<Machine>) GlobalCacheUtil.get("machines");
//            if (machines == null || machines.size() == 0) {
//
//
//                machines = (List<Machine>) redisUtils.get("machines");
//                if (machines == null || machines.size() == 0) {
//
//                    machines = InitCalendarToAllMachines();
//
//                }
//            }
//

        }
        FileHelper.writeLogFile("初始化设备日历-----------结束-------");
        redisUtils.set("machines",machines);
        GlobalCacheUtil.put("machines", machines, 10, TimeUnit.MINUTES);
        return machines;
    }

    public  List<Machine> InitCalendarToAllMachines ()
    {
        FileHelper.writeLogFile("初始化Redis设备日历-----------开始-------");

        ScheduleParams param = InitScheduleParams();
        MachineSchedulerService machineScheduler = new MachineSchedulerService(
                param.getBaseTime());

        List<Machine> machines = _routingDataService.InitCalendarToAllMachines( machineScheduler,param.getBaseTime());

        redisUtils.set("machines",machines);

        FileHelper.writeLogFile("初始化Redis设备日历-----------结束-------");

        return machines;
    }

    private ScheduleParams InitScheduleParams()
    {
        FileHelper.writeLogFile("初始化排产参数-----------开始-------");
        LambdaQueryWrapper<ApsTimeConfig> queryWrapper = new LambdaQueryWrapper<ApsTimeConfig>();
        Page<ApsTimeConfig> page = new Page<>(1, 1);
        ApsTimeConfig apsTimeConfig=   apsTimeConfigMapper.selectOne( queryWrapper);

        ScheduleParams param = new ScheduleParams();
        param.setBaseTime(LocalDateTime.of(2025, 11, 1, 0, 0, 0));
        if(apsTimeConfig!=null) {
            if(apsTimeConfig.getBaseTime()!=null)
            {
                param.setBaseTime(apsTimeConfig.getBaseTime());
            }
        }
        FileHelper.writeLogFile("初始化排产参数-----------结束-------");
        return param;
    }
private  GlobalParam InitGlobalParam()
{
    FileHelper.writeLogFile("初始化约束-----------开始-------");

    GlobalParam globalParam=new GlobalParam();



    LambdaQueryWrapper<Config> queryWrapper = new LambdaQueryWrapper<Config>()
            .eq(Config::getComponent, "setting")
            .orderByDesc(Config::getId); // 按更新时间降序

    Page<Config> page = new Page<>(1, 1);
    configMapper.selectPage(page, queryWrapper);

// 3. 提取最后一条记录
    Config config = page.getRecords().isEmpty()
            ? null
            : page.getRecords().get(0);



    List<ConfigSetting> configs=  _configService.getComponentSettingsByPageAndNote(config.getId(),"setting");
    for (ConfigSetting c : configs) {
        if(c.getTitle().contains("日历"))
        {
            globalParam.setIsUseCalendar(c.isValue());
        }
        else if(c.getTitle().contains("设置时间"))
        {
            //是否考虑换型时间
            globalParam.set_smoothChangeOver(c.isValue());
        }

        else if(c.getTitle().contains("原材料"))
        {
            globalParam.setIsCheckMp(c.isValue());
        }
        else if(c.getTitle().contains("后台任务设置"))
        {
            //休息时间是否换型
            globalParam.set_smoothChangeOverInWeek(c.isValue());
        }
        else if(c.getTitle().contains("设置时间平滑"))
        {
            globalParam.set_smoothSetup(c.isValue());//工序的前处理是否提前
        }
        else if(c.getTitle().contains("自制件"))
        {
            globalParam.setIsCheckSf(c.isValue());
        }


    }
    FileHelper.writeLogFile("初始化约束-----------结束-------");
    return  globalParam;
}
    private List<Order> InitOrder(List<ProdLaunchOrder> ProdLaunchOrders)
    {
        orderSortService.initializeFieldExtractors();
        List<Order> orders=new ArrayList<>();
        for (ProdLaunchOrder lo : ProdLaunchOrders) {
            Order order=new Order();
            order.setMaterialCode(lo.getMaterialCode());
            order.setMaterialName(lo.getMaterialName());
            order.setSerie(lo.getSerie()==null?"":lo.getSerie());
            order.setOrderCode(lo.getOrderCode());
            order.setOrderId(lo.getOrderId());
            order.setRoutingId(lo.getRoutingId());
            order.setRoutingCode(lo.getRoutingCode());
            order.setMaterialId(lo.getMaterialId());
            order.setStartDate(lo.getStartDate());
            order.setDueDate(lo.getEndDate());
            order.setPriority(lo.getOrderPriority());
            order.setActualPriority(lo.getOrderPriority());
            order.setQuantity(lo.getQuantity());
            order.setSYQuantity(lo.getQuantity());
            orders.add(order);
        }
        OrderSortRule rule = createMultiConditionRule(orders);

        // 执行
        orderSortService.assignPriority(orders, rule);

//        // 按照优先级排序
//        orders.sort(
//                Comparator.comparing(Order::getActualPriority)
//        );

       return orders;
    }
    private OrderSortRule createMultiConditionRule(List<Order> orders) {
        try {
            OrderSortRule rule = new OrderSortRule();
            rule.setEnabled(true);
            List<OrderSortRule.SortCondition> conditions = new ArrayList<>();
            StrategyRule strategyRules = _strategyRuleService.lambdaQuery()
                    .eq(StrategyRule::getIsDeleted, 0)
                    .eq(StrategyRule::getIsGlobal, 1)
                    .one();

            List<StrategyScheduling> StrategySchedulings = _strategyRuleService.getForwardSchedulingByRuleId(strategyRules.getId());
            Set<String> files = new HashSet<>();
            if (StrategySchedulings != null) {
                List<StrategyScheduling> selecteds = StrategySchedulings.stream().filter(t -> t.isValue() == true).sorted(Comparator.comparingInt(StrategyScheduling::getSort) ).collect(Collectors.toList());
                if (selecteds != null && selecteds.size() > 0) {
                    int i = 1;
                    for (StrategyScheduling strategy : selecteds) {

                       int Amplitude= strategy.getAmplitude();
                        if (strategy.getName().equals("customer_due_date")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            if(Amplitude>0) {
                                condition.setFieldName("groupDueDate");
                                DateGroupUtil.calculateGroupDueDate(orders, "dueDate", "groupDueDate", strategy.getAmplitude());

                            }else {
                                condition.setFieldName("dueDate");
                            }
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("groupDueDate");
                            i++;


                        } else if (strategy.getName().equals("startd_date") ) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            if(Amplitude>0) {
                                condition.setFieldName("groupStartDate");
                                DateGroupUtil.calculateGroupDueDate(orders, "startDate", "groupStartDate", strategy.getAmplitude());

                            }else {
                                condition.setFieldName("startDate");
                            }
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("groupStartDate");
                            i++;

                        } else if (strategy.getName().equals("gathering_series")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("serie");
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("serie");
                            i++;
                        } else if (strategy.getName() .equals( "Minimum_wo_priority") && !files.contains("priority")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("priority");
                            condition.setReverse(false); // 递增
                            conditions.add(condition);
                            files.add("priority");
                            i++;
                        } else if (strategy.getName() .equals( "maximum_wo_priority") && !files.contains("priority")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("priority");
                            condition.setReverse(true); // 高优先级在前
                            conditions.add(condition);
                            files.add("priority");
                            i++;
                        } else if (strategy.getName() .equals( "material_rise")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("materialCode");
                            condition.setReverse(true); // 递增
                            conditions.add(condition);
                            files.add("materialCode");
                            i++;
                        } else if (strategy.getName() .equals( "plan_rise") && !files.contains("orderCode")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("orderCode");
                            condition.setReverse(true); // 递增
                            conditions.add(condition);
                            files.add("orderCode");
                            i++;
                        } else if (strategy.getName() .equals( "plan_drop") && !files.contains("orderCode")) {
                            OrderSortRule.SortCondition condition = new OrderSortRule.SortCondition();
                            condition.setSequence(i);
                            condition.setFieldName("orderCode");
                            condition.setReverse(false); // 递减
                            conditions.add(condition);
                            files.add("orderCode");
                            i++;
                        }

                    }

                } else {
                    OrderSortRule.SortCondition condition3 = new OrderSortRule.SortCondition();
                    condition3.setSequence(1);
                    condition3.setFieldName("priority");
                    condition3.setReverse(false); // 优先级越小越越先
                    conditions.add(condition3);
                }

            } else {
                OrderSortRule.SortCondition condition3 = new OrderSortRule.SortCondition();
                condition3.setSequence(1);
                condition3.setFieldName("priority");
                condition3.setReverse(false); // 优先级越小越越先
                conditions.add(condition3);

            }

            rule.setConditions(conditions);
            return rule;
        } catch (Exception e) {
            // 捕获异常（字段不存在/类型错误/空值等）
            e.printStackTrace();
            return null;
        }

    }

    private List<Material> InitMaterial() {
        List<Material> materials=new ArrayList<>();
        FileHelper.writeLogFile("初始化物料-----------开始-------");

//       List<MaterialInfo> materiallist=  materialInfoService.lambdaQuery()
//                .eq(MaterialInfo::getIsdeleted,0)
//               .list();

         materials= (List<Material>)GlobalCacheUtil.get("material");
        if(materials==null||materials.size()==0) {



            materials = (List<Material>) redisUtils.get("material");
            if (materials == null||materials.size()==0) {

                materials = getMaterials();

            }
        }

        GlobalCacheUtil.put("material",materials, 10, TimeUnit.MINUTES);
        FileHelper.writeLogFile("初始化物料-----------结束-------");

        return materials;
    }



    public List<Material> getMaterials(){
        List<Material> materials=new ArrayList<>();
        System.out.println("开始初始化物料数据");
        LambdaQueryWrapper<MaterialInfo> MaterialInfoWrapper = new LambdaQueryWrapper<>();
        MaterialInfoWrapper.eq(MaterialInfo::getIsdeleted,0);


        List<MaterialInfo> materiallist=materialInfoMapper.selectList(MaterialInfoWrapper);

        LambdaQueryWrapper<MaterialPurchase> materialPurchaseWrapper= new LambdaQueryWrapper<>();
        materialPurchaseWrapper.eq(MaterialPurchase::getIsdeleted,0);

        List<MaterialPurchase> MaterialPurchaselist=materialPurchaseMapper.selectList(materialPurchaseWrapper);



        LambdaQueryWrapper<Stock> StockWrapper = new LambdaQueryWrapper<>();
        StockWrapper.eq(Stock::getIsdeleted,0);

        List<Stock> Stocklist=  stockMapper.selectList(StockWrapper);

        LambdaQueryWrapper<ErpPurchaseOrder> ErpPurchaseOrderWrapper = new LambdaQueryWrapper<>();
        ErpPurchaseOrderWrapper.eq(ErpPurchaseOrder::getIsdeleted,0);

        //原材料采购订单
        List<ErpPurchaseOrder> ErpPurchaseOrderlist=  erpPurchaseOrderMapper.selectList(ErpPurchaseOrderWrapper);

        LambdaQueryWrapper<PurchaseReceipt> PurchaseReceiptWrapper = new LambdaQueryWrapper<>();
        PurchaseReceiptWrapper.eq(PurchaseReceipt::getIsdeleted,0);

        //原材料待验
        List<PurchaseReceipt> PurchaseReceiptlist=  purchaseReceiptMapper.selectList(PurchaseReceiptWrapper);

        LambdaQueryWrapper<SjzPfWhStock> SjzPfWhStockWrapper = new LambdaQueryWrapper<>();
        SjzPfWhStockWrapper.eq(SjzPfWhStock::getIsdeleted,0);

        List<SjzPfWhStock> SjzPfWhStocklists=  sjzPfWhStockMapper.selectList(SjzPfWhStockWrapper);

        for (MaterialInfo m : materiallist)
        {


          //  materiallist.forEach(m -> {
                Material material = new Material();
                material.setId(m.getId());
                material.setMaterialType(m.getMaterialType());
                material.setMaterialTypeName(m.getMaterialTypeName());
                material.setCkeckLeadTime(m.getInspectDuration());
                material.setPurchaseLeadTime(m.getPurchaseDuration());

            List<Stock> materialStocks= Stocklist.stream()
                    .filter(t -> t.getMaterialId().equals(m.getId()))
                    .collect(Collectors.toList());
                if(materialStocks!=null&&materialStocks.size()>0)
                {
                    double stock = materialStocks.stream()
                            .filter(t -> t.getMaterialId().equals(m.getId()))
                            .mapToDouble(Stock::getTotal)
                            .sum();
                    material.setCurrentStock(stock);

                    material.setMaterialStocks(materialStocks);
                }

                List<MaterialSupply> materialSupplys = new ArrayList<>();
                if(m.getMaterialTypeName()==null)
                {
                    continue;
                }
                if (m.getMaterialTypeName().equals("MP")) {
                    List<PurchaseReceipt> PurchaseReceipts = PurchaseReceiptlist.stream()
                            .filter(t -> t.getMaterialid() == m.getId())
                            .collect(Collectors.toList());
                    if (PurchaseReceipts != null&&PurchaseReceipts.size()>0) {

                        for (PurchaseReceipt mm : PurchaseReceipts) {//原材料待验
                            MaterialSupply ms = new MaterialSupply();
                            LocalDateTime dt = mm.getExp5() == null ? ParamValidator.parseDateTime(mm.getExp1(), "") : mm.getExp5();
                            ms.setQuantity(mm.getFjl1Sl());
                            ms.setArrivalTime(dt);
                            materialSupplys.add(ms);
                        }

                    }
                    List<ErpPurchaseOrder> ErpPurchaseOrders = ErpPurchaseOrderlist.stream()
                            .filter(t -> t.getMaterialId() == m.getId())
                            .collect(Collectors.toList());
                    if (ErpPurchaseOrders != null&&ErpPurchaseOrders.size()>0) {
                        for (ErpPurchaseOrder mm : ErpPurchaseOrders) {//原材料采购，可用时间要加上检验时间
                            MaterialSupply ms = new MaterialSupply();
                            LocalDateTime dt = mm.getArrivalDate().plusDays(m.getInspectDuration());
                            ms.setQuantity(mm.getPurchaseQty());
                            ms.setArrivalTime(dt);
                            materialSupplys.add(ms);
                        }
                    }
                } else {
                    List<SjzPfWhStock> SjzPfWhStocks = SjzPfWhStocklists.stream()
                            .filter(t -> t.getMaterialid() == m.getId())
                            .collect(Collectors.toList());
                    if (SjzPfWhStocks != null&&SjzPfWhStocks.size()>0) {
                        for (SjzPfWhStock mm : SjzPfWhStocks) {//原材料采购，可用时间要加上检验时间
                            MaterialSupply ms = new MaterialSupply();
                            LocalDateTime dt = ParamValidator.parseDateTime(mm.getExp1(), "");
                            ms.setQuantity(mm.getFjl1Sl());
                            ms.setArrivalTime(dt);
                            materialSupplys.add(ms);
                        }
                    }
                }
                material.setInTransit(materialSupplys);
                materials.add(material);
           // });
        }
        redisUtils.set("material",materials);
        return  materials;
    }

    private Map<Integer, Object> InitEntrys(String SceneId,List<ProdEquipment> ProdEquipments,List<Order> ProdLaunchOrders)
    {
        FileHelper.writeLogFile("初始化工单-----------开始-------");
        Map<Integer, Object> entrys=  _routingDataService.InitEntrys(SceneId,ProdEquipments,ProdLaunchOrders);
        FileHelper.writeLogFile("初始化工单-----------结束-------");
        return entrys;
    }



    public GenVO convertGeneToGenVO(Gene gene, LocalDateTime baseTime) {
        GenVO genVO = new GenVO();
        genVO.setOrderId(String.valueOf(gene.getOrderId()));
        genVO.setOperationId(gene.getOperationId());
        genVO.setEquipId(gene.getMachineId());
        genVO.setQuantity(BigDecimal.valueOf(gene.getBatchSize()));
        genVO.setStartTime(baseTime.plusMinutes(gene.getStartTime()));
        genVO.setEndTime(baseTime.plusMinutes(gene.getEndTime()));
        genVO.setOperationName(""); // 从其他数据源获取
        genVO.setEquipName(""); // 从其他数据源获取
        return genVO;
    }

    // 批量转换
    public List<GenVO> convertGeneListToGenVO(List<Gene> geneList, LocalDateTime baseTime) {
        return geneList.stream()
                .map(gene -> convertGeneToGenVO(gene, baseTime))
                .collect(Collectors.toList());
    }

    public List<MachineVO> convertMachineListToVO(List<Machine> machines) {
        return machines.stream()
                .map(this::convertToVO)
                .collect(Collectors.toList());
    }

    private MachineVO convertToVO(Machine machine) {
        MachineVO machineVO = new MachineVO();
        machineVO.setId(machine.getId());
        machineVO.setEquipId(String.valueOf(machine.getId()));
        machineVO.setEquipName(machine.getName());
        // 注意：tasks 字段需要在其他地方设置，因为 Machine 类中没有任务信息
        return machineVO;
    }





    public List<Machine> InitCalendarToAllMachines1(String SceneId) {
        // 按设备分组
        List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                .eq(ProdEquipment::getSceneId,SceneId)
                .list();
        List<Long> MachineIds = ProdEquipments.stream()
                .map(ProdEquipment::getEquipId)
                .distinct()
                .sorted()
                .collect(Collectors.toList());

        List<Machine> machines=new ArrayList<>();

        for (Long id : MachineIds) {
            Machine machine=new Machine();
            machine.setId(id);
            machines.add(machine);
        }
        //节假日
        List<MesHoliday> holidays=  _MesHolidayService.list();

        LambdaQueryWrapper<ProdEquipSpecialCal> ProdEquipSpecialCalWrapper = new LambdaQueryWrapper<>();
        ProdEquipSpecialCalWrapper.eq(ProdEquipSpecialCal::getSceneId, SceneId);

        List<PlanResource> PlanResources=  _PlanResourceService.lambdaQuery()
                .eq(PlanResource::getIsdeleted,0)
                .list();



        List<ProdEquipSpecialCal> ProdEquipSpecialCals=  _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);

        List<MesShiftWorkSched> MesShiftWorkScheds=  _MesShiftWorkSchedService.lambdaQuery()
                .eq(MesShiftWorkSched::getIsdeleted,0).list();


        if (machines == null) {
            return null;
        }

        for (Machine machine : machines) {
            // 确保维护窗口列表不为null
            if (machine.getMaintenanceWindows() == null) {
                machine.setMaintenanceWindows(new ArrayList<>());
            }
            List<ProdEquipSpecialCal> machineProdEquipSpecialCals = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getPlanResourceId()== machine.getId()&&t.getReferenceType()==1)
                    .collect(Collectors.toList());
            List<Shift> shifts1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : machineProdEquipSpecialCals) {

                List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                        .filter(t -> (long) t.getWeekWorkSchedId() == machineProdEquipSpecialCal.getReferenceId())
                        .collect(Collectors.toList());
                List<Shift> Shifts = mergeShiftDataToEng(ShiftWorkScheds);
                for (Shift shift : Shifts) {

                    shift.setMachineId(machine.getId());
                    shift.setSpecial(true);
                    shift.setStartDate(machineProdEquipSpecialCal.getStartDate());
                    shift.setEndDate(machineProdEquipSpecialCal.getEndDate());
                    shifts1.add(shift);
                }
            }


            List<PlanResource> PlanResources1 = PlanResources.stream()
                    .filter(t -> t.getReferenceId() == machine.getId())
                    .collect(Collectors.toList());
            if(PlanResources1!=null&&PlanResources1.size()>0)
            {
                for (PlanResource PlanResource : PlanResources1) {

                    List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                            .filter(t -> (long) t.getWeekWorkSchedId() == PlanResource.getWorkSchedId())
                            .collect(Collectors.toList());
                    List<Shift> Shifts = mergeShiftDataToEng(ShiftWorkScheds);
                    for (Shift shift : Shifts) {
                        shift.setSpecial(false);
                        shift.setMachineId(machine.getId());
//                        shift.setStartDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
//                        shift.setEndDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shifts1.add(shift);
                    }
                }

            }



            // 转换为列表返回
            List<Shift> result = new ArrayList<>();
            for (Shift shift : shifts1) {
                // 处理跨天班次（开始时间晚于结束时间的情况，如 7:30 到 3:30）
                if (shift.getEndTime().isBefore(shift.getStartTime())) {
                    // 创建第一天的班次 (开始时间到24:00)
                    Shift firstShift = new Shift();
                    firstShift.setStartTime(shift.getStartTime());
                    firstShift.setEndTime(LocalTime.of(23, 59, 59)); // 23:59:59代替24:00
                    firstShift.setDays(new HashSet<>(shift.getDays()));
                    firstShift.setStatus(shift.getStatus());
                    firstShift.setStartDate(shift.getStartDate());
                    firstShift.setEndDate(shift.getEndDate());
                    firstShift.setSpecial(shift.isSpecial());
                    // 创建第二天的班次 (00:00到结束时间)
                    Shift secondShift = new Shift();
                    secondShift.setStartTime(LocalTime.MIDNIGHT);
                    secondShift.setEndTime(shift.getEndTime());
                    secondShift.setDays(new HashSet<>(shift.getDays()));
                    secondShift.setStatus(shift.getStatus());
                    secondShift.setStartDate(shift.getStartDate().plusDays(1));
                    secondShift.setEndDate(shift.getEndDate().plusDays(1));
                    secondShift.setSpecial(shift.isSpecial());
                    result.add(firstShift);
                    result.add(secondShift);
                } else {
                    // 正常班次直接添加
                    result.add(shift);
                }
            }
            machine.setShifts(result);


            List<ProdEquipSpecialCal> Holidays = ProdEquipSpecialCals.stream()
                    .filter(t -> t.getEquipId() == machine.getId()&&t.getReferenceType()==2)
                    .collect(Collectors.toList());
            List<Holiday> Holidays1=new ArrayList<>();
            for (ProdEquipSpecialCal machineProdEquipSpecialCal : Holidays) {

                Holiday holiday=new Holiday();
                holiday.setStart(machineProdEquipSpecialCal.getStartDate());
                holiday.setEnd(machineProdEquipSpecialCal.getEndDate());
                Holidays1.add(holiday);
            }
            machine.setHolidays(Holidays1);



        }


        return  machines;


    }
    /**
     * 合并重复的ShiftData，将serialNumber收集为列表
     * @param originalList 原始数据列表
     * @return 合并后的MergedShiftData列表
     */
    public static List<Shift> mergeShiftData(List<MesShiftWorkSched> originalList) {
        // 按shiftStart和shiftEnd分组
        Map<String, Shift> groupMap = new HashMap<>();

        for (MesShiftWorkSched data : originalList) {
            // 用shiftStart+shiftEnd作为分组key
            String groupKey = data.getShiftStart().toString() + "_" + data.getShiftEnd().toString();

            if (groupMap.containsKey(groupKey)) {
                // 已存在分组：添加serialNumber到列表
                Shift merged = groupMap.get(groupKey);
                merged.getDays().add(data.getStartWeekDay());
            } else {
                // 新分组：创建MergedShiftData并初始化
                Shift merged = new Shift();

                merged.setStartTime(data.getShiftStart().toLocalTime());
                merged.setEndTime(data.getShiftEnd().toLocalTime());
                merged.setStatus(0);

                // 初始化序号列表
                Set<Integer> serials =new HashSet<>();
                serials.add(data.getStartWeekDay());
                merged.setDays(serials);
                groupMap.put(groupKey, merged);
            }
        }

        // 转换为列表返回
        return new ArrayList<>(groupMap.values());
    }




    /**
     * 合并重复的ShiftData，将serialNumber收集为列表英文格式0,1,2,3,4,5,6
     * @param originalList 原始数据列表
     * @return 合并后的MergedShiftData列表
     */
    public static List<Shift> mergeShiftDataToEng(List<MesShiftWorkSched> originalList) {
        // 按shiftStart和shiftEnd分组
        Map<String, Shift> groupMap = new HashMap<>();

        for (MesShiftWorkSched data : originalList) {
            // 用shiftStart+shiftEnd作为分组key
            String groupKey = data.getShiftStart().toString() + "_" + data.getShiftEnd().toString();

            // 将中文的星期几转换为英文格式（周日是0，周一到周日依次为0-6）
            // 假设数据库中startWeekDay是1-7（周一到周日），需要转换为0-6（周日到周六）
            int engDay = (data.getStartWeekDay() % 7); // 将1-7转换为0-6，其中周日为0

            if (groupMap.containsKey(groupKey)) {
                // 已存在分组：添加serialNumber到列表
                Shift merged = groupMap.get(groupKey);
                merged.getDays().add(engDay);
            } else {
                // 新分组：创建MergedShiftData并初始化
                Shift merged = new Shift();

                merged.setStartTime(data.getShiftStart().toLocalTime());
                merged.setEndTime(data.getShiftEnd().toLocalTime());
                merged.setStatus(0);

                // 初始化序号列表
                Set<Integer> serials =new HashSet<>();
                serials.add(engDay);
                merged.setDays(serials);
                groupMap.put(groupKey, merged);
            }
        }

        // 转换为列表返回
        return new ArrayList<>(groupMap.values());
    }




    /**
     * 将 ScheduleChromosome 转换为 ResourceGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @param machineList 机器列表
     * @return 转换后的数据
     */
    public List<ResourceGanttVO> convertToResourceGanttVO1(Chromosome scheduleChromosome, List<Machine> machineList) {
        List<ResourceGanttVO> resourceGanttVOList = new ArrayList<>();


        List<Entry> allOperations = scheduleChromosome.getAllOperations();
        // 遍历所有机器资源
        if (machineList != null) {
            for (int i = 0; i < machineList.size(); i++) {
                Machine machine = machineList.get(i);

                com.aps.entity.Gantt.ResourceGanttVO resourceGanttVO = new com.aps.entity.Gantt.ResourceGanttVO();
                resourceGanttVO.setId(machine.getId());
                resourceGanttVO.setName(machine.getName());
                resourceGanttVO.setShift(convertToShiftVO(machine));
                resourceGanttVO.setCode(machine.getCode());
                // 转换任务列表
                List<com.aps.entity.Gantt.TaskVO> taskVOList = new ArrayList<>();
                if (scheduleChromosome.getResult() != null) {
                    // 筛选出属于当前设备的任务
                    List<GAScheduleResult> machineGenes = scheduleChromosome.getResult().stream()
                            .filter(gene -> gene.getMachineId()==(machine.getId()))
                            .collect(Collectors.toList());
                    // 按开始时间排序
                    machineGenes.sort((g1, g2) -> Integer.compare(g1.getStartTime(), g2.getStartTime()));

                    for (GAScheduleResult gene : machineGenes) {

                        Entry entry = allOperations.stream()
                                .filter(t -> t.getId() == gene.getOperationId()).findFirst().orElse(null);


                        TaskVO taskVO = new TaskVO();
                        taskVO.setId(String.valueOf(gene.getOperationId()));
                        taskVO.setPlanId(gene.getOrderId()); // 默认值
                        taskVO.setPlanCode(gene.getOrderCode()); // 默认值
//                        taskVO.setProductType(0); // 默认值
                        taskVO.setProductName(gene.getProductName());
                        taskVO.setProductId(gene.getProductId()); // 默认值
                        taskVO.setProductCode(gene.getProductCode()); // 默认值
                        taskVO.setQuantity(gene.getQuantity());
                        taskVO.setStart(scheduleChromosome.getBaseTime().plusSeconds(gene.getStartTime()));
                        taskVO.setEnd(scheduleChromosome.getBaseTime().plusSeconds(gene.getEndTime()));
                        taskVO.setSetup(gene.getPreTime());
                        taskVO.setTeardown(gene.getTeardownTime()); // 默认值
                        taskVO.setEquipChange(gene.getChangeOverTime()); // 默认值
                        taskVO.setEquipCooling(0); // 默认值
                        taskVO.setEquipType(resourceGanttVO.getType());
                        taskVO.setEquipName(resourceGanttVO.getName());
                        taskVO.setLocked(gene.isIsLocked()); // 默认值
                        if (entry != null) {
                            taskVO.setSeq(Math.toIntExact(entry.getTaskSeq())); // 使用工序ID
                            taskVO.setSeqName(entry.getRoutingDetailName());
                        }

                        if (gene.getDesignatedStartTime()!=-1) {
                            taskVO.setDesignatedStartTime(scheduleChromosome.getBaseTime().plusSeconds(gene.getDesignatedStartTime()));
                        }else {

                            taskVO.setDesignatedStartTime(null);

                        }
//                        taskVO.setDuration(calculateDuration(
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
//                                scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()))); // 计算持续时间

                        taskVO.setDuration(0); //
                        taskVO.setEquipId(machine.getId());
                        taskVO.setShopId(machine.getId());
                        taskVO.setShopName(resourceGanttVO.getShopName());
                        taskVO.setStatus(0); // 默认值
                        taskVO.setDetailId(entry.getRoutingDetailId()); // 将productId和operationID组合为detailId
                        taskVO.setHeaderId(entry.getRoutingId()); // 默认值
                        taskVO.setHeaderName(entry.getRoutingName()); // 默认值
                        taskVO.setSeq(Math.toIntExact(entry.getTaskSeq())); // 使用工序ID
                        taskVO.setSeqName(entry.getRoutingDetailName());
                        taskVO.setProcessingTime(gene.getProcessingTime());

                        taskVOList.add(taskVO);

                        taskVO.setAbsolutePreparationTime(gene.getTeardownTime());



                    }
                }

                resourceGanttVO.setList(taskVOList);
                resourceGanttVOList.add(resourceGanttVO);
            }
        }

        return resourceGanttVOList;
    }

    /**
     * 将 ScheduleChromosome 转换为 ProductGanttVO 列表
     * @param scheduleChromosome 调度结果
     * @return 转换后的数据
     */
    public List<com.aps.entity.Gantt.ProductGanttVO> convertToProductGanttVO1(Chromosome scheduleChromosome) {
        List<com.aps.entity.Gantt.ProductGanttVO> productGanttVOList = new ArrayList<>();

        // 按产品ID和工单ID分组基因
        if (scheduleChromosome.getResult() != null) {
            // 按工单ID分组
            scheduleChromosome.getResult().stream()
                    .collect(Collectors.groupingBy(GAScheduleResult::getOrderId))
                    .forEach((orderId, genes) -> {
                        if (!genes.isEmpty()) {
                            com.aps.entity.Gantt.ProductGanttVO productGanttVO = new com.aps.entity.Gantt.ProductGanttVO();
                            GAScheduleResult firstGene = genes.get(0);
                            productGanttVO.setId(firstGene.getOrderId());
                            productGanttVO.setProductName("产品"+firstGene.getProductId()); // 默认值，实际应从订单数据获取
                            productGanttVO.setProductType(0);
                            productGanttVO.setProductId(firstGene.getProductId());
                            // 计算总数量（假设同一批次）
                            productGanttVO.setQuantity(firstGene.getQuantity());
                            productGanttVO.setCode("编号"+firstGene.getProductId()); // 默认值
                            productGanttVO.setShopId(firstGene.getMachineId()); // 默认值
                            productGanttVO.setShopName(firstGene.getMachineId()+"号线"); // 默认值
                            productGanttVO.setStatus("已发布");
//                            productGanttVO.setHeaderId(firstGene.getProductId());
                            productGanttVO.setHeaderName("工艺"+firstGene.getProductId()); // 默认值

                            // 计算开始和结束时间
                            int minStartTime = genes.stream()
                                    .mapToInt(GAScheduleResult::getStartTime)
                                    .min()
                                    .orElse(0);
                            int maxEndTime = genes.stream()
                                    .mapToInt(GAScheduleResult::getEndTime)
                                    .max()
                                    .orElse(0);

                            productGanttVO.setStartDate(scheduleChromosome.getBaseTime().plusMinutes(minStartTime));
                            productGanttVO.setEndDate(scheduleChromosome.getBaseTime().plusMinutes(maxEndTime));

                            // 转换任务列表
                            List<com.aps.entity.Gantt.TaskVO> taskVOList = new ArrayList<>();
//                            // 按工序顺序排序
//                            genes.sort((g1, g2) -> Integer.compare(g1.getSequenceId(), g2.getSequenceId()));

                            for (int i = 0; i < genes.size(); i++) {
                                GAScheduleResult gene = genes.get(i);
                                com.aps.entity.Gantt.TaskVO taskVO = new com.aps.entity.Gantt.TaskVO();
                                taskVO.setId(String.valueOf(gene.getOperationId())); // 生成唯一ID
                                taskVO.setPlanId(String.valueOf(orderId));
                                taskVO.setProductType(0);
                                taskVO.setProductName("产品"+gene.getProductId());
                                taskVO.setProductId(String.valueOf(gene.getProductId()));
                                taskVO.setQuantity(gene.getQuantity());
                                taskVO.setStart(scheduleChromosome.getBaseTime().plusSeconds(gene.getStartTime()));
                                taskVO.setEnd(scheduleChromosome.getBaseTime().plusSeconds(gene.getEndTime()));
                                taskVO.setSetup(gene.getPreTime()); // 默认值
                                taskVO.setTeardown(gene.getTeardownTime()); // 默认值
                                taskVO.setEquipChange(gene.getChangeOverTime()); // 默认值
                                taskVO.setEquipCooling(0); // 默认值
//                            taskVO.setEquipType("PTT-" + (i+1) + "-" + gene.getOperationName().toUpperCase().substring(0, Math.min(3, gene.getOperationName().length())));
//                            taskVO.setEquipName(gene.getOperationName());
                                taskVO.setDuration(calculateDuration(
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()),
                                        scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime())));
                                taskVO.setEquipId(gene.getMachineId()); // 生成设备ID
                                taskVO.setShopId(gene.getMachineId());
                                taskVO.setShopName(gene.getMachineId()+"车间");
                                taskVO.setStatus(0);
//                                taskVO.setDetailId((long) gene.getProductId() * 1000 + gene.getOperationId());
//                                taskVO.setHeaderId(gene.getProductId());
                                taskVO.setHeaderName("工艺"+gene.getProductId());
//                                taskVO.setSeq(gene.getSequenceId());
//                                taskVO.setSeqName("工序名称"+gene.getSequenceId());
//                                taskVO.setAbsoluteStart(scheduleChromosome.getBaseTime().plusMinutes(gene.getStartTime()));
//                                taskVO.setAbsoluteEnd(scheduleChromosome.getBaseTime().plusMinutes(gene.getEndTime()));

                                taskVOList.add(taskVO);
                            }

                            productGanttVO.setList(taskVOList);
                            productGanttVOList.add(productGanttVO);
                        }
                    });
        }

        return productGanttVOList;
    }




    private ShiftVO convertToShiftVO(Machine machine) {
        ShiftVO shiftVO= new ShiftVO();
        shiftVO.setId(machine.getId());
        shiftVO.setName(machine.getName());
        shiftVO.setShifts(machine.getShifts());
        shiftVO.setMaintenanceWindows(machine.getMaintenanceWindows());
        // 注意：tasks 字段需要在其他地方设置，因为 Machine 类中没有任务信息
        return shiftVO;
    }


    /**
     * 计算任务持续时间（分钟）
     * @param start 开始时间
     * @param end 结束时间
     * @return 持续时间（分钟）
     */
    private Integer calculateDuration(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            return 0;
        }
        return Math.toIntExact(java.time.Duration.between(start, end).toMinutes());
    }


    public List<Machine> InitCalendarToAllMachines2(String SceneId) {


        GlobalParam globalParam=InitGlobalParam();
        boolean IsUseCalendar = globalParam.isIsUseCalendar();

        // 按设备分组
        List<ProdEquipment> ProdEquipments=  _prodEquipmentService.lambdaQuery()
                .eq(ProdEquipment::getSceneId,SceneId)
                .list();
        List<Long> MachineIds = ProdEquipments.stream()
                .map(ProdEquipment::getEquipId)
                .distinct()
                .sorted()
                .collect(Collectors.toList());



        List<Machine> machines = new ArrayList<>();
        List<PlanResource> PlanResources = _PlanResourceService.lambdaQuery()
                .eq(PlanResource::getIsdeleted, 0)
                .list();

        //维修记录
        LambdaQueryWrapper<EquipMaintainTask> EquipMaintainTaskWrapper = new LambdaQueryWrapper<>();
        EquipMaintainTaskWrapper.eq(EquipMaintainTask::getIsdeleted, 0);
        EquipMaintainTaskWrapper.eq(EquipMaintainTask::getStatus, 0);
        EquipMaintainTaskWrapper.ge(EquipMaintainTask::getPlanFinishTime, baseTime);
        List<EquipMaintainTask> EquipMaintainTasks = _equipMaintainTaskService.list(EquipMaintainTaskWrapper);

        for (Long id : MachineIds) {
            Machine machine = new Machine();
            PlanResource planResource = PlanResources.stream()
                    .filter(t -> t.getId() == id.intValue())
                    .findFirst().orElse(null);


            List<MaintenanceWindow> maintenanceWindows=new ArrayList<>();
            if (planResource != null){
                machine.setCode(planResource.getReferenceCode());
                machine.setName(planResource.getTitle());
                machine.setDepartment(planResource.getDepartTitle());
                List<EquipMaintainTask> EquipMaintainTasks1 = EquipMaintainTasks.stream()
                        .filter(t -> t.getEquipId().equals(planResource.getReferenceId()) )
                        .collect(Collectors.toList());
                for (EquipMaintainTask equipMaintainTask : EquipMaintainTasks1) {
                    MaintenanceWindow maintenanceWindow=new MaintenanceWindow();
                    maintenanceWindow.setId(UUID.randomUUID().toString());
                    maintenanceWindow.setStartTime(equipMaintainTask.getPlanStartTime());
                    maintenanceWindow.setEndTime(equipMaintainTask.getPlanFinishTime());
                    maintenanceWindow.setReason("");
                    maintenanceWindow.setEquipCode(equipMaintainTask.getEquipCode());
                    maintenanceWindow.setEquipName(equipMaintainTask.getEquipName());
                    maintenanceWindows.add(maintenanceWindow);
                }

                machine.setMaintenanceWindows(maintenanceWindows);



            }
            machine.setId(id);
            machines.add(machine);
        }
        //节假日
        //  List<MesHoliday> holidays=  _MesHolidayService.list();
        if (IsUseCalendar) {
            LambdaQueryWrapper<ProdEquipSpecialCal> ProdEquipSpecialCalWrapper = new LambdaQueryWrapper<>();
            ProdEquipSpecialCalWrapper.eq(ProdEquipSpecialCal::getSceneId, SceneId);


            List<ProdEquipSpecialCal> ProdEquipSpecialCals = _prodEquipSpecialCalService.list(ProdEquipSpecialCalWrapper);

            List<MesShiftWorkSched> MesShiftWorkScheds = _MesShiftWorkSchedService.lambdaQuery()
                    .eq(MesShiftWorkSched::getIsdeleted, 0).list();


            if (machines == null) {
                return null;
            }

            for (Machine machine : machines) {
                // 确保维护窗口列表不为null
                if (machine.getMaintenanceWindows() == null) {
                    machine.setMaintenanceWindows(new ArrayList<>());
                }
                List<ProdEquipSpecialCal> machineProdEquipSpecialCals = ProdEquipSpecialCals.stream()
                        .filter(t -> t.getPlanResourceId() != null && t.getPlanResourceId() == machine.getId() && t.getReferenceType() == 1)
                        .collect(Collectors.toList());
                List<Shift> shifts1 = new ArrayList<>();
                for (ProdEquipSpecialCal machineProdEquipSpecialCal : machineProdEquipSpecialCals) {

                    List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                            .filter(t -> (long) t.getWeekWorkSchedId() == machineProdEquipSpecialCal.getReferenceId())
                            .collect(Collectors.toList());
                    List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                    for (Shift shift : Shifts) {

                        shift.setMachineId(machine.getId());
                        shift.setStartDate(machineProdEquipSpecialCal.getStartDate());
                        shift.setEndDate(machineProdEquipSpecialCal.getEndDate());
                        shifts1.add(shift);
                        shift.setSpecial(true);
                    }
                }
                PlanResource PlanResource = PlanResources.stream()
                        .filter(t -> t.getId() == machine.getId())
                        .findFirst().orElse(null);
                if (PlanResource != null) {
                    machine.setCode(PlanResource.getReferenceCode());
                    machine.setName(PlanResource.getTitle());
                    machine.setDepartment(PlanResource.getDepartTitle());
                    List<MesShiftWorkSched> ShiftWorkScheds = MesShiftWorkScheds.stream()
                            .filter(t -> (long) t.getWeekWorkSchedId() == PlanResource.getWorkSchedId())
                            .collect(Collectors.toList());
                    List<Shift> Shifts = mergeShiftData(ShiftWorkScheds);
                    for (Shift shift : Shifts) {

                        shift.setMachineId(machine.getId());
                        shift.setSpecial(false);
                        shift.setStartDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shift.setEndDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                        shifts1.add(shift);
                    }


                }
                if (shifts1 == null || shifts1.size() == 0) {
                    throw new RuntimeException(String.format("设备%s没有工作日历", machine.getCode().concat("_").concat(machine.getName())));
                }

                // 转换为列表返回
                List<Shift> result = new ArrayList<>();
                for (Shift shift : shifts1) {
                    // 处理跨天班次（开始时间晚于结束时间的情况，如 7:30 到 3:30）
                    if (shift.getEndTime().isBefore(shift.getStartTime())) {
                        // 创建第一天的班次 (开始时间到24:00)
                        Shift firstShift = new Shift();
                        firstShift.setStartTime(shift.getStartTime());
                        firstShift.setEndTime(LocalTime.of(23, 59, 59)); // 23:59:59代替24:00
                        firstShift.setDays(new HashSet<>(shift.getDays()));
                        firstShift.setStatus(shift.getStatus());
                        firstShift.setStartDate(shift.getStartDate());
                        firstShift.setEndDate(shift.getEndDate());
                        firstShift.setSpecial(shift.isSpecial());
                        // 创建第二天的班次 (00:00到结束时间)
                        Shift secondShift = new Shift();
                        secondShift.setStartTime(LocalTime.MIDNIGHT);
                        secondShift.setEndTime(shift.getEndTime());
                        secondShift.setDays(new HashSet<>(shift.getDays()));
                        secondShift.setStatus(shift.getStatus());
                        secondShift.setStartDate(shift.getStartDate().plusDays(1));
                        secondShift.setEndDate(shift.getEndDate().plusDays(1));
                        secondShift.setSpecial(shift.isSpecial());
                        result.add(firstShift);
                        result.add(secondShift);
                    } else {
                        // 正常班次直接添加
                        result.add(shift);
                    }
                }

                machine.setShifts(result);

                List<ProdEquipSpecialCal> Holidays = ProdEquipSpecialCals.stream()
                        .filter(t -> t.getEquipId() == machine.getId() && t.getReferenceType() == 2)
                        .collect(Collectors.toList());
                List<Holiday> Holidays1 = new ArrayList<>();
                for (ProdEquipSpecialCal machineProdEquipSpecialCal : Holidays) {

                    Holiday holiday = new Holiday();
                    holiday.setStart(machineProdEquipSpecialCal.getStartDate());
                    holiday.setEnd(machineProdEquipSpecialCal.getEndDate());
                    Holidays1.add(holiday);
                }
                machine.setHolidays(Holidays1);


            }
        } else {
            for (Machine machine : machines) {
                List<Shift> shifts1 = new ArrayList<>();
                Shift shift=new Shift();
                shift.setMachineId(machine.getId());
                shift.setStartTime(LocalTime.of(0,0,0));
                shift.setEndTime(LocalTime.of(23,59,59));
                HashSet days= new HashSet<>();
                days.add(1);
                days.add(2);
                days.add(3);
                days.add(4);
                days.add(5);
                days.add(6);
                days.add(0);
                shift.setDays(days);
                shift.setSpecial(false);
                shift.setStartDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                shift.setEndDate(LocalDateTime.of(2000, 1, 1, 0, 0, 0));
                shifts1.add(shift);
                machine.setShifts(shifts1);
            }
        }


        return machines;


    }





    public List<Machine> InitCalendarToAllMachines3(Chromosome chromosome)  {

        List<Machine> machines = chromosome.getInitMachines();
        Set<Long> machineIds = chromosome.getResult().stream()
            .map(GAScheduleResult::getMachineId)
            .collect(Collectors.toSet());

        machines = machines.stream()
            .filter(machine -> machineIds.contains(machine.getId()))
            .collect(Collectors.toList());
        for (Machine machine:machines) {
                 {
                     List<Shift> result = new ArrayList<>();
                     List<Shift> shifts = machine.getShifts();
                     for (Shift shift : shifts) {
                         // 处理跨天班次（开始时间晚于结束时间的情况，如 7:30 到 3:30）
                         if (shift.getEndTime().isBefore(shift.getStartTime())) {
                             // 创建第一天的班次 (开始时间到24:00)
                             Shift firstShift = new Shift();
                             firstShift.setStartTime(shift.getStartTime());
                             firstShift.setEndTime(LocalTime.of(23, 59, 59)); // 23:59:59代替24:00
                             firstShift.setDays(new HashSet<>(shift.getDays()));
                             firstShift.setStatus(shift.getStatus());
                             firstShift.setStartDate(shift.getStartDate());
                             firstShift.setEndDate(shift.getEndDate());
                             firstShift.setSpecial(shift.isSpecial());
                             // 创建第二天的班次 (00:00到结束时间)
                             Shift secondShift = new Shift();
                             secondShift.setStartTime(LocalTime.MIDNIGHT);
                             secondShift.setEndTime(shift.getEndTime());
                             secondShift.setDays(new HashSet<>(shift.getDays()));
                             secondShift.setStatus(shift.getStatus());
                             secondShift.setStartDate(shift.getStartDate().plusDays(1));
                             secondShift.setEndDate(shift.getEndDate().plusDays(1));
                             secondShift.setSpecial(shift.isSpecial());
                             result.add(firstShift);
                             result.add(secondShift);
                         } else {
                             // 正常班次直接添加
                             result.add(shift);
                         }

                 }


                     machine.setShifts(result);
                 }
             }

        return machines;


    }
    
    /**
     * 获取指定场景ID的文件数字
     * @param sceneId 场景ID
     * @return 包含文件名后数字的列表
     */
    public List<Integer> getSceneFileNumbers(String sceneId) {
        List<Integer> numbers = new ArrayList<>();
        SceneChromsome sceneChromsome=(SceneChromsome)redisUtils.get("SceneId."+sceneId);
        if (sceneChromsome==null){
            return numbers;
        }

        Integer   currultVersion =sceneChromsome.getVersion();


        // 获取结果目录
        File resultDir = new File("result");
        if (!resultDir.exists() || !resultDir.isDirectory()) {
            return numbers;
        }
        
        // 获取目录中的所有文件
        File[] files = resultDir.listFiles();
        if (files == null) {
            return numbers;
        }
        
        // 定义要查找的前缀
        String prefix = "chromosome_result_" + sceneId + "_";
        String suffix = "_.json";
        
        for (File file : files) {
            if (file.isFile()) {
                String fileName = file.getName();
                
                // 检查文件名是否以指定前缀开始，并以指定后缀结束
                if (fileName.startsWith(prefix) && fileName.endsWith(suffix)) {
                    // 提取前缀和后缀之间的部分
                    String middlePart = fileName.substring(
                        prefix.length(), 
                        fileName.length() - suffix.length()
                    );
                    
                    // 尝试将中间部分解析为数字
                    try {
                        int number = Integer.parseInt(middlePart);
                        // 只添加小于当前版本的数字
                        if (number < currultVersion) {
                            numbers.add(number);
                        }
                    } catch (NumberFormatException e) {
                        // 如果中间部分不是数字，则跳过该文件
                        continue;
                    }
                }
            }
        }
        
        // 对数字列表进行排序（从小到大）
        Collections.sort(numbers);
        return numbers;
    }


    public Map<String, Object> getSceneVersion(String sceneId) {
        List<Integer> numbers = new ArrayList<>();
        SceneChromsome sceneChromsome=(SceneChromsome)redisUtils.get("SceneId."+sceneId);
        if (sceneChromsome==null){
            Map<String, Object> result = new HashMap<>();
            result.put("list", numbers);
            result.put("index", -1);
            return result;
        }

        Integer   currultVersion =sceneChromsome.getVersion();


        // 获取结果目录
        File resultDir = new File("result");
        if (!resultDir.exists() || !resultDir.isDirectory()) {
            Map<String, Object> result = new HashMap<>();
            result.put("list", numbers);
            result.put("index", -1);
            return result;
        }

        // 获取目录中的所有文件
        File[] files = resultDir.listFiles();
        if (files == null) {
            Map<String, Object> result = new HashMap<>();
            result.put("list", numbers);
            result.put("index", -1);

            return result;
        }

        // 定义要查找的前缀
        String prefix = "chromosome_result_" + sceneId + "_";
        String suffix = "_.json";

        for (File file : files) {
            if (file.isFile()) {
                String fileName = file.getName();

                // 检查文件名是否以指定前缀开始，并以指定后缀结束
                if (fileName.startsWith(prefix) && fileName.endsWith(suffix)) {
                    // 提取前缀和后缀之间的部分
                    String middlePart = fileName.substring(
                            prefix.length(),
                            fileName.length() - suffix.length()
                    );

                    // 尝试将中间部分解析为数字
                    try {
                        int number = Integer.parseInt(middlePart);

                            numbers.add(number);

                    } catch (NumberFormatException e) {
                        // 如果中间部分不是数字，则跳过该文件
                        continue;
                    }
                }
            }
        }

        // 对数字列表进行排序（从小到大）
        Collections.sort(numbers);

        // 查找当前版本在numbers中的索引
        int index = numbers.indexOf(currultVersion);
        if (index == -1 && !numbers.isEmpty()) {
            // 如果当前版本不在历史版本列表中，返回列表长度作为位置
            index = numbers.size();
        } else if (numbers.isEmpty()) {
            index = -1; // 如果列表为空，索引为-1
        }

        Map<String, Object> result = new HashMap<>();
        result.put("list", numbers);
        result.put("index", index);

        return result;
    }



}

