// ScheduleRequest.java
package com.aps.entity.Schedule;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@Schema(name = "调度请求参数", description = "调度请求参数")
public class ScheduleRequest {
    
    @Schema(description = "开始时间", example = "2025-10-01T00:00:00")
    private LocalDateTime startTime;
    
    @Schema(description = "节假日列表")
    private List<HolidayDTO> holidays;
    
    @Schema(description = "是否运行所有算法", example = "true")
    private boolean runAll = false;
}

