package com.aps.entity.Gantt;

import com.aps.entity.basic.ShiftVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Schema(name = "资源甘特图数据模型", description = "资源甘特图数据模型")
public class ResourceGanttVO {

    @Schema(description = "设备ID")
    private long id;

    @Schema(description = "设备名称")
    private String name;

    @Schema(description = "设备类型")
    private String type;

    @Schema(description = "是否可更换")
    private Integer change;

    @Schema(description = "是否可拆分")
    private Integer split;

    @Schema(description = "部门ID")
    private long departmentId;

    @Schema(description = "部门名称")
    private String departmentName;

    @Schema(description = "车间名称")
    private String shopName;

    @Schema(description = "车间ID")
    private long shopId;

    @Schema(description = "设备编码")
    private String code;

    @Schema(description = "任务列表")
    private List<TaskVO> list;

    private ShiftVO shift;



}