package com.aps.entity.Gantt;

import com.aps.entity.basic.Shift;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Schema(name = "任务数据模型", description = "任务数据模型")
public class TaskVO {

    @Schema(description = "任务ID")
    private String id;

    @Schema(description = "计划ID")
    private String planId;

    @Schema(description = "计划编号")
    private String planCode;

    @Schema(description = "产品类型")
    private Integer productType;

    @Schema(description = "产品名称")
    private String productName;

    @Schema(description = "产品ID")
    private String productId;

    @Schema(description = "产品编码")
    private String productCode;

    @Schema(description = "数量")
    private double quantity;

    @Schema(description = "开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime start;

    @Schema(description = "结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime end;


    @Schema(description = "开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime absoluteStart;

    @Schema(description = "结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime absoluteEnd;


    @Schema(description = "准备时间")
    private Integer setup;

    @Schema(description = "收尾时间")
    private Integer teardown;

    @Schema(description = "设备更换时间")
    private Integer equipChange;

    @Schema(description = "设备冷却时间")
    private Integer equipCooling;

    @Schema(description = "设备类型")
    private String equipType;

    @Schema(description = "设备名称")
    private String equipName;

    @Schema(description = "持续时间")
    private Integer duration;

    @Schema(description = "设备ID")
    private long equipId;
    @Schema(description = "设备编码")
    private String equipCode;
    @Schema(description = "车间ID")
    private long shopId;

    @Schema(description = "车间名称")
    private String shopName;

    //‘0’:已发布 ‘1’:未发布
    @Schema(description = "状态")
    private  Integer status;

    @Schema(description = "明细ID")
    private Long detailId;

    @Schema(description = "头ID")
    private Integer headerId;

    @Schema(description = "头名称")
    private String headerName;

    @Schema(description = "工序序号")
    private Integer seq;

    @Schema(description = "工序名称")
    private String seqName;

    private double processingTime; // 绝对处理时间（分钟）

    private int absolutePreparationTime;   // 新增：绝对准备时间

    @Schema(description = "锁定状态")
    private boolean locked;
    
    @Schema(description = "指定开始时间")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private LocalDateTime designatedStartTime;
    


}