package com.aps.controller;

import com.aps.common.util.R;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.entity.ProdSceneConfig;
import com.aps.service.LanuchService;
import com.aps.service.ProdSceneConfigService;
import com.aps.service.plan.PlanResultService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

@RestController
@RequestMapping("/lanuch")
@Tag(name = "启动工单", description = "启动工单接口")
public class LanuchController {

    @Autowired
    private LanuchService lanuchService;

    @Autowired
    private PlanResultService planResultService;

    @Autowired
    private ProdSceneConfigService prodSceneConfigService;
    /**
     * 启动工单
     *
     * @param sceneName        场景名称
     * @param username         用户名
     * @return 处理结果
     */
    @PostMapping("/execute")
    public R<String> lanuch(
            @RequestParam String sceneName,
            @RequestHeader(required = false) String username) {
        if (username == null || username.isEmpty()) {
            username = "system";
        }

        return lanuchService.lanuch(sceneName, username);
    }

    @GetMapping("/schedule")
    public Chromosome schedule(@RequestParam String sceneID,@RequestParam LocalDateTime baseTime) {
        // 调用 PlanResultService 获取 ScheduleChromosome 列表
        Chromosome scheduleChromosomes = planResultService.schedule(sceneID,baseTime);

        // 提取所有场景ID
        return scheduleChromosomes;
    }


    @PostMapping("/copyScene")
    public R<String> copyScene(
            @RequestParam String newSceneName,@RequestParam String oldSceneName,
            @RequestHeader(required = false) String username) {
        if (username == null || username.isEmpty()) {
            username = "system";
        }

        return lanuchService.copyScene(oldSceneName,username,newSceneName);
    }

    @GetMapping("/exportPlan")
    public R<String>  exportPlan(@RequestParam String sceneID) {
        // 调用 PlanResultService 获取 ScheduleChromosome 列表
        return  lanuchService.exportPlan(sceneID);

    }


    @GetMapping("/deleteScene")
    public R<Boolean>  deleteScene(@RequestParam String sceneID) {
        // 调用 PlanResultService 获取 ScheduleChromosome 列表
        return R.ok(prodSceneConfigService.deleteSceneById(sceneID));

    }




}