package com.aps.entity.Algorithm;

/**
 * 作者：佟礼
 * 时间：2025-12-04
 */
public enum DependencyType {
    FinishToStart(0), // 完成-开始（FS）：串行 下料→加工→组装
    StartToStart(1),   // 开始-开始（SS）： 加工 A 和加工 B 可同时进行 重叠 重叠生产：涂装开始后 30 分钟，烘烤可开始
    FinishToFinish(2), // 完成-完成（FF）：前置工序完成后，后继工序才能完成 所有并行加工工序需同时完成
    StartToFinish(3);  // 开始-完成（SF）：前置工序开始后，后继工序才能完成

    private final int value;

    DependencyType(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }


    public static DependencyType fromValueSafe(Integer value) {
        if (value == null) {
            return FinishToStart; // 默认值
        }

        for (DependencyType type : values()) {
            if (type.value == value) {
                return type;
            }
        }
        return FinishToStart; // 无效值也返回默认值
    }

    /**
     * 转换方法
     */
    public static DependencyType fromValue(int value) {
        for (DependencyType type : values()) {
            if (type.value == value) {
                return type;
            }
        }
        throw new IllegalArgumentException("无效的DependencyType值: " + value);
    }

    /**
     * 验证方法
     */
    public static boolean isValid(Integer value) {
        if (value == null) return false;
        for (DependencyType type : values()) {
            if (type.value == value) return true;
        }
        return false;
    }






}
