package com.aps.entity.common;



import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 *
 * @Title: PagedGridResult.java
 * @Package com.lei.utils
 * @Description: 用来返回分页Grid的数据格式
 */
public class Paged {

	private Integer pageIndex=1;  //当前页
	private Integer pageSize=1000;   //每页多少条
	private Integer total=0;// 特殊设置，总记录数，如果前台带有此值，则分页查询时不查询总数。
	private List<String> sortByList=new ArrayList<>(); // 多字段排序列表，格式如["type asc", "id desc"]
	private String sortBy="";  //排序字段
	private Boolean desc=true; //是否倒序
	/** 返回的字段，多个用逗号分隔如 "id,name"；有值时只返回这些列，有几列返回几列 */
	private String fields="";
	private String table=""; // 返回的表
	/** 分组字段，多个用逗号分隔如 "id,name"。有值时按这些字段 GROUP BY，返回结果仅含分组列 + count（每组条数） */
	private String groupName;
	private Boolean and=true; // 条件逻辑关系，true为与关系，false为或关系
	private List<ConditionEntity> conditions=new ArrayList<>();  //条件集合


	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public Integer getPageIndex() {
		return pageIndex;
	}

	public void setPageIndex(Integer pageIndex) {
		this.pageIndex = pageIndex;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public Boolean getDesc() {
		return desc;
	}

	public void setDesc(Boolean desc) {
		this.desc = desc;
	}

	public List<ConditionEntity> getConditions() {
		return conditions;
	}
	public ConditionEntity getCondition(String field){
		Optional<ConditionEntity> first = conditions.stream().filter(s -> s.getFieldName().equalsIgnoreCase(field)).findFirst();
		if(first.isPresent()){
			return first.get();
		}
		return null;
	}
	public List<ConditionEntity> addCondition(String field, ConditionEnum conditionType,String sql) {
		if(conditions==null){
			conditions=new ArrayList<>();
		}
		ConditionEntity condition=new ConditionEntity();
		condition.setFieldName(field);
		condition.setConditionalType(conditionType.toString());
		condition.setFieldValue(sql);
		conditions.add(condition);
		return conditions;
	}
	public void setConditions(List<ConditionEntity> conditions) {
		this.conditions = conditions;
	}

	@Override
	public String toString() {
		return "Paged{" +
				"pageIndex=" + pageIndex +
				", pageSize=" + pageSize +
				", sortBy='" + sortBy + '\'' +
				", desc=" + desc +
				", conditions=" + conditions +
				'}';
	}

	public String getFields() {
		return fields;
	}

	public void setFields(String fields) {
		this.fields = fields;
	}

	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public List<String> getSortByList() {
		return sortByList;
	}

	public void setSortByList(List<String> sortByList) {
		this.sortByList = sortByList;
	}

	public Boolean getAnd() {
		return and;
	}

	public void setAnd(Boolean and) {
		this.and = and;
	}
}
