package com.aps.entity;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.Queue;

@Data
public class EquipmentScheduleState {
    private Integer equipId;      // 设备ID
    private String equipName;     // 设备名称
    private Queue<ScheduledTask> taskQueue = new LinkedList<>(); // 任务队列
    private LocalDateTime nextAvailableTime; // 下次可用时间

    // 从Equipinfo初始化
    public EquipmentScheduleState(Equipinfo equipinfo, LocalDateTime now) {
        this.equipId = equipinfo.getId();
        this.equipName = equipinfo.getEquipName(); // 添加设备名称
        // 确保设备创建时间不为空
        if (equipinfo.getCreationtime() != null) {
            this.nextAvailableTime = equipinfo.getCreationtime().atStartOfDay();
        } else {
            this.nextAvailableTime = now != null ? now : LocalDateTime.now();
        }
    }
}