package com.aps.controller;

import com.aps.common.util.ParamValidator;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.aps.common.util.R;
import com.aps.entity.ApsTimeConfig;
import com.aps.service.ApsTimeConfigService;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;


/**
 * <p>
 * APS时间配置表 前端控制器
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-23
 */

@RestController
@RequestMapping("/apsTimeConfig")
@Tag(name = "APS时间配置管理", description = "APS时间配置管理")
public class ApsTimeConfigController {
    
    @Autowired
    private ApsTimeConfigService apsTimeConfigService;
    
    /**
     * 获取APS时间配置
     */
    @GetMapping("/getConfig")
    @Operation(summary = "获取APS时间配置", description = "获取APS时间配置信息")
    public R<ApsTimeConfig> getConfig() {
        ApsTimeConfig config = apsTimeConfigService.getConfig();

            return R.ok(config);

    }
    
    /**
     * 更新APS时间配置
     */
    @PostMapping("/updateConfig")
    @Operation(summary = "更新APS时间配置", description = "更新APS时间配置")
    public R<String> updateConfig(@RequestBody Map<String, Object> configMap) {
        // 使用ParamValidator处理和验证数据
        Map<String, Object> processedConfigMap = new HashMap<>();
        

                LocalDateTime baseTime = ParamValidator.parseDateTime(configMap.get("baseTime").toString(), "基准时间");
                processedConfigMap.put("baseTime", baseTime);

                Double freezeDate = ParamValidator.getDouble(configMap, "freezeDate", "冻结日期");
                processedConfigMap.put("freezeDate", BigDecimal.valueOf(freezeDate));


                Double startCount = ParamValidator.getDouble(configMap, "startCount", "前置时间");
                processedConfigMap.put("startCount", BigDecimal.valueOf(startCount));

                Double endCount = ParamValidator.getDouble(configMap, "endCount", "后置时间");
                processedConfigMap.put("endCount", BigDecimal.valueOf(endCount));

        
        boolean result = apsTimeConfigService.updateConfigFromMap(processedConfigMap);

            return R.ok("配置更新成功");

    }
}
