package com.aps.entity.Gantt;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 供给关系响应数据类
 */
@Data
public class SupplyRelationResponse {
    private int code;
    private String msg;
    private List<Object> data;
    private String timestamp;

    /**
     * 构建成功响应
     * @param data 响应数据
     * @return 响应对象
     */
    public static SupplyRelationResponse success(List<Object> data) {
        SupplyRelationResponse response = new SupplyRelationResponse();
        response.setCode(200);
        response.setMsg("success");
        response.setData(data);
        response.setTimestamp(java.time.LocalDateTime.now().toString());
        return response;
    }
}