package com.aps.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 物料主数据表
 * </p>
 *
 * @author yourName
 * @since 2025-09-25
 */
@Getter
@Setter
@TableName("material_info")
public class MaterialInfo implements Serializable {

    private static final long serialVersionUID = 1L;


    private String id;


    private LocalDateTime creationtime;


    private Long creatoruserid;


    private LocalDateTime lastmodificationtime;


    private Long lastmodifieruserid;


    private Long isdeleted;


    private LocalDateTime deletiontime;


    private Long deleteruserid;

    /**
     * 名称
     */

    private String name;


    private String brand;

    /**
     * 规格
     */

    private String specifications;


    private String batch;


    private BigDecimal unitPrice;


    private BigDecimal minNum;


    private String tempcode;

    /**
     * 编码
     */

    private String code;


    private String materialTypeName;

    private Long inspectDuration;

    private int purchaseDuration;

    private String firstLot;

    private BigDecimal tailLot;

    private BigDecimal standardLog;

    private Long safeStockDay;

    private BigDecimal safeStockQuantity;

    /**
     * 类别名称
     */
    private String categoryName;

    /**
     * 类别编码
     */
    private String categoryCode;

    /**
     * 类别ID
     */
    private Long categoryId;

    private Long materialProperty;

    private Long rootCategoryId;

    private Long codeRuleId;

    private Long codeRuleType;

    /**
     * 编码
     */
    private String drawing;

    private Long materialType;

    /**
     * 单位
     */
    private Long measureUnit;

    /**
     * 单位名称
     */
    private String measureUnitName;

    /**
     * 版本
     */
    private String version;

    /**
     * 产品类型
     */
    private String productType;

    private Long status;

    private Long latest;

    /**
     * 是否创建原材料供应供应?
     */
    private Long iscreatesupplyrouting;

    /**
     * 是否创建原材料检验供应?
     */
    private Long iscreatecheckrouting;

    private String description;

    /**
     * 物料类型
     */
    private Long quintiqOrtems;

    private Long isync;

    private Long issend;

    /**
     * 辅助计量单位
     */
    private Long measureUnit2;

    private String measureUnitName2;

    private String linkmaterialid;

    /**
     * 辅助计量单位2
     */
    private Long measureUnit3;

    private String measureUnitName3;

    private BigDecimal zjltofjl1;

    /**
     * 供应商ID
     */
    private String supplyId;

    /**
     * 供应商名称
     */
    private String supplyName;

    /**
     * 供应商编码
     */
    private String supplyCode;

    private Long istrade;

    private String ser;

    /**
     * 是否共用?
     */
    private Long iscommon;

    /**
     * 是否创建汇总供应?
     */
    private Long iscreatepoolrouting;

    /**
     * 特殊产品，普通产品
     */
    private String variety;

    /**
     * 规格
     */
    private String spec;

    /**
     * MP类别
     */
    private Long categoryId2;

    private Long utilityMaterial;

    /**
     * 特殊产品
     */
    private Long specialProduct;

    /**
     * 瓶型
     */
    private Long bottleType;

    private String bottleTypeStr;

    /**
     * 最大库存目标
     */
    private BigDecimal maxInventoryDay;

    /**
     * 最大库存目标
     */
    private BigDecimal maxInventoryQuantity;

    /**
     * 最小库存目标
     */
    private BigDecimal minInventoryDay;

    /**
     * 最小库存目标
     */
    private BigDecimal minInventoryQuantity;

    /**
     * 最小供应量
     */
    private BigDecimal minimumSupply;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 产线设备
     */
    private Long equipId;

    /**
     * 大宗产品 1==是
     */
    private Long bigpro;

    /**
     * 小宗产品 1==是
     */
    private Long smallpro;

    /**
     * 周三后排?
     */
    private Long isthree;

    /**
     * 是否负库存
     */
    private Long isMinus;

    private String remark;

    /**
     * 搭配大宗产品
     */
    private String matchBigproId;

    /**
     * 搭配大宗产品
     */
    private String matchBigproCode;

    /**
     * 搭配小宗产品
     */
    private String matchSmallproId;

    /**
     * 搭配小宗产品
     */
    private String matchSmallproCode;

    /**
     * 全称
     */
    private String fullName;

    /**
     * 是否包含库存，默认是，0否
     */
    private Long isIncludeStore;

    /**
     * 是否平分到未来四周，默认0否，1是
     */
    private Long isAverageFourWeek;

    /**
     * 库存同步时间
     */
    private LocalDateTime stocksynctime;

    private Long inventoryHostCost;

    /**
     * 拆分前计划ID
     */
    private String beforeplanid;

    /**
     * 计划顺序号
     */
    private Long plannum;

    /**
     * 计划总数
     */
    private Long plancount;

    /**
     * 集成过来的主键；
     */
    private Long newLongId;

    /**
     * 集成过来的旧物料编码
     */
    private String newOldnumber;

    /**
     * 集成过来的最小起订量
     */
    private BigDecimal minQuantity;

    /**
     * 0 其他1 外贸 2 研发 3 试料 4西南 5追加
     */
    private Long materialPlanType;

    /**
     * 最小生产量
     */
    private BigDecimal minProduction;

    /**
     * 最大生产量
     */
    private BigDecimal maxProduction;

    /**
     * 不可见性（外贸删除的物料）
     */
    private Long invisable;
}