package com.aps.service.Algorithm;

import com.aps.common.util.GlobalCacheUtil;
import com.aps.common.util.SnowFlackIdWorker;
import com.aps.common.util.redis.RedisUtils;
import com.aps.entity.*;
import com.aps.entity.Algorithm.*;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.basic.*;
import com.aps.mapper.RoutingHeaderMapper;
import com.aps.mapper.RoutingSupportingReplaceMapper;
import com.aps.mapper.RoutingsupportingMapper;
import com.aps.service.*;
import com.aps.service.impl.LanuchServiceImpl;
import com.aps.service.plan.MachineSchedulerService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 作者：佟礼
 * 时间：2025-12-08
 */
@Service
public class MaterialRequirementService {

    private List<Material> _materials;


    @Autowired
    RoutingDetailConnectService routingDetailConnectService;

    @Autowired
    private RedisUtils redisUtils;


    @Autowired
    RoutingHeaderMapper routingHeaderMapper;

    @Autowired
    RoutingSupportingReplaceMapper routingSupportingReplaceMapper;

    @Autowired
    RoutingsupportingMapper routingsupportingMapper;

    @Autowired
    RoutingDataService _routingDataService;
    @Autowired
    private EquipinfoService equipinfoService;
    @Autowired
    private RoutingDiscreteParamService _routingDiscreteParamService;

    @Autowired
    private   LanuchService lanuchService;
    private  LocalDateTime baseTime ;



    private GlobalParam globalParam;



    private static final int cachetimeout  = 60;
    private String cacheKey="_MR_";
    private String routingHeaderCacheKey=cacheKey+ "RoutingHeader";
    private String routingsupportingCacheKey=cacheKey+ "Routingsupporting";
    private String routingSupportingReplaceCacheKey=cacheKey+ "RoutingSupportingReplace";

    private String routingDetailCacheKey=cacheKey+ "RoutingDetail";
    private String routingDetailEquipCacheKey=cacheKey+ "RoutingDetailEquip";

    private String routingDetailConnectCacheKey=cacheKey+ "RoutingDetailConnect";
    private String routingDiscreteParamCacheKey=cacheKey+ "RoutingDiscreteParam";

    private String materialsCacheKey=cacheKey+ "material";

    public Map<Integer,Object> preloadRoutingCache(String sceneId,LocalDateTime baseTime, List<Order> _orders,List<Material> materials,List<Entry> _allOperations,boolean isIsCheckSf) {

        this.baseTime=baseTime;
        Map<Integer,Object> reslte=new HashMap<>(2);
        reslte.put(1,null);
        reslte.put(2,null);
        this._materials=materials;
        List<Integer> routingIds=  _orders.stream()
                .filter(t->t.getRoutingId()!=null)
                .map(Order::getRoutingId)
                .distinct()
                .collect(Collectors.toList());
        List<RoutingHeader> routingHeaders=null;

            LambdaQueryWrapper<RoutingHeader> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(RoutingHeader::getId, routingIds);
//                    .eq(RoutingHeader::getIsDeleted, 0)
//                    .eq(RoutingHeader::getApprovalStatus, 1);
            routingHeaders = routingHeaderMapper.selectList(wrapper);


        List<Routingsupporting> routingsupportings=null;
        //  查询并缓存Routingsupporting

            LambdaQueryWrapper<Routingsupporting> routingsupportingwrapper = new LambdaQueryWrapper<>();
            routingsupportingwrapper.in(Routingsupporting::getRoutingHeaderId, routingIds)
                    .eq(Routingsupporting::getIsdeleted, 0);
             routingsupportings = routingsupportingMapper.selectList(routingsupportingwrapper);


        //  查询并缓存RoutingSupportingReplace
        List<RoutingSupportingReplace> replaces=null;
        if (routingsupportings != null && !routingsupportings.isEmpty()) {
            List<String> routingsupportingids = routingsupportings.stream()
                    .map(Routingsupporting::getStrId)
                    .distinct()
                    .collect(Collectors.toList());

                LambdaQueryWrapper<RoutingSupportingReplace> routingsupportingreplacewrapper = new LambdaQueryWrapper<>();
                routingsupportingreplacewrapper.in(RoutingSupportingReplace::getStrsupid, routingsupportingids)
                        .eq(RoutingSupportingReplace::getIsdeleted, 0);
                 replaces = routingSupportingReplaceMapper.selectList(routingsupportingreplacewrapper);

        }
        List<Material> useMaterials=new ArrayList<>();
        Set<String> useMaterialids=new HashSet<>();
        if(routingsupportings!=null&&routingsupportings.size()>0)
        {
            List<String> materialIds=new ArrayList<>();
            for (Order order : _orders) {
                Integer routingid=order.getRoutingId();
                List<Routingsupporting> MaterialRequirements = routingsupportings.stream()
                        .filter(t -> t.getRoutingHeaderId().equals(routingid))
                        .collect(Collectors.toList());


               String orderId= order.getOrderId();
                if(MaterialRequirements!=null)
                {

                    List<Entry> Operations= _allOperations.stream()
                            .filter(t->t.getOrderId().equals(orderId))
                            .collect(Collectors.toList());

                    for (Entry operation : Operations) {
                        List<Routingsupporting> MaterialRequirement_entrys = routingsupportings.stream()
                                .filter(t -> t.getRoutingDetailId().equals(operation.getRoutingDetailId()))
                                .collect(Collectors.toList());
                        List<OrderMaterialRequirement> materialRequirementList=new ArrayList<>();
                        if(MaterialRequirement_entrys!=null) {

                            for (Routingsupporting component : MaterialRequirement_entrys) {
                                // 查找物料（流式处理替代First）
                                String materialId = component.getMaterialId();
                                Material material = materials.stream()
                                        .filter(m -> m.getId().equals(materialId))
                                        .findFirst()
                                        .orElse(null);
                                if (material != null) {
                                    if (!useMaterialids.contains(materialId)) {
                                        useMaterials.add(material);
                                        useMaterialids.add(materialId);
                                    }
                                    double allneeded = component.getSpentQty().doubleValue()/ component.getMainQty().doubleValue() * operation.Quantity;

                                    OrderMaterialRequirement orderMaterialRequirement = CreateMaterialRequirement(material, orderId, "", operation,
                                            allneeded,component.getSpentQty().doubleValue(), component.getMainQty().doubleValue(),operation.Quantity);
                                    orderMaterialRequirement.setBomId(component.getStrId());
                                    if (!material.getMaterialTypeName().equals("MP") && isIsCheckSf) {
                                        materialIds.add(materialId);
                                    }
                                    materialRequirementList.add(orderMaterialRequirement);
                                }
                            }
                        }
                        operation.setMaterialRequirements(materialRequirementList);
                    }
                }
            }
            if(replaces!=null&&replaces.size()>0) {
                for (RoutingSupportingReplace routingSupportingReplace : replaces) {
                    String materialID1 = routingSupportingReplace.getMaterialid();
                    if (!useMaterialids.contains(materialID1)) {
                        Material material = _materials.stream()
                                .filter(m -> m.getId().equals(materialID1))
                                .findFirst()
                                .orElse(null);
                        if (material != null) {
                            useMaterials.add(material);
                            useMaterialids.add(materialID1);
                        }
                    }
                }
            }

            if(materialIds!=null&&materialIds.size()>0)
            {
                Map<Integer,Object> reslte1=preloadSfRoutingBomCache(materialIds, routingHeaders, routingsupportings, replaces);
                List<Long> routingIds1=(List<Long>) reslte1.get(1);
                if(routingIds1!=null)
                {
                    List<Long> equipids=  preloadSfRoutingCache(sceneId,routingIds1);
                    reslte.put(1,equipids);
                }
                List<Material> useMaterials1=(List<Material>) reslte1.get(2);
                if(useMaterials1!=null) {
                    for (Material m:useMaterials1) {
                        String materialID1= m.getId();
                        if(!useMaterialids.contains(materialID1)) {
                            useMaterials.add(m);
                            useMaterialids.add(materialID1);
                        }
                    }
                }
                reslte.put(2,useMaterials);

            }

        }

        SaveBomCache(sceneId, routingHeaders, routingsupportings, replaces,useMaterials);

        return reslte;
    }



    private  Map<Integer,Object> preloadSfRoutingBomCache(List<String> materialIDs,List<RoutingHeader> headers,List<Routingsupporting> routingsupportings,List<RoutingSupportingReplace> routingsupportingreplaces) {

        Map<Integer,Object> reslte=new HashMap<>(2);
        reslte.put(1,null);
        reslte.put(2,null);
        List<Material> useMaterials=new ArrayList<>();
        Set<String> useMaterialids=new HashSet<>();
        List<Long> routingIds=new ArrayList<>();
        List<Long> routingIds1=new ArrayList<>();
        Long routingId = 0l;
        List<Routingsupporting> routingsupportings1 = new ArrayList<>();
        List<RoutingSupportingReplace> routingsupportingreplaces1 = new ArrayList<>();

        for (String materialID:materialIDs) {
            RoutingHeader headers1 = headers.stream()
                    .filter(t -> t.getMaterialId().equals(materialID))
                    .findFirst().orElse(null);
            if (headers1 == null) {
                LambdaQueryWrapper<RoutingHeader> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(RoutingHeader::getMaterialId, materialID)
                        .eq(RoutingHeader::getIsDeleted, 0);
                // .eq(RoutingHeader::getApprovalStatus, 1); // 添加 is_deleted=0 过滤条件
                headers1 = routingHeaderMapper.selectList(wrapper).stream().findFirst().orElse(null);
                if (headers1 != null) {
                    headers.add(headers1);
                    routingId = headers1.getId().longValue();
                    routingIds.add(routingId);
                }
            }else {
                routingIds1.add(headers1.getId().longValue());
            }
        }


        if (routingIds != null&&routingIds.size()>0) {



                LambdaQueryWrapper<Routingsupporting> routingsupportingwrapper = new LambdaQueryWrapper<>();
                routingsupportingwrapper.in(Routingsupporting::getRoutingHeaderId, routingIds)
                        .eq(Routingsupporting::getIsdeleted, 0);

                routingsupportings1 = routingsupportingMapper.selectList(routingsupportingwrapper);
                routingsupportings.addAll(routingsupportings1);

            List<String> routingsupportingids = routingsupportings1.stream()
                    .map(Routingsupporting::getStrId)
                    .distinct()
                    .collect(Collectors.toList());

            LambdaQueryWrapper<RoutingSupportingReplace> routingsupportingreplacewrapper = new LambdaQueryWrapper<>();
            routingsupportingreplacewrapper.in(RoutingSupportingReplace::getStrsupid, routingsupportingids)
                    .eq(RoutingSupportingReplace::getIsdeleted, 0);

            routingsupportingreplaces1 = routingSupportingReplaceMapper.selectList(routingsupportingreplacewrapper);

            routingsupportingreplaces.addAll(routingsupportingreplaces1);

            List<String> materialIds=new ArrayList<>();
            for (Routingsupporting routingsupporting:routingsupportings1) {
                String materialID1= routingsupporting.getMaterialId();
                Material material = _materials.stream()
                        .filter(m -> m.getId().equals(materialID1))
                        .findFirst()
                        .orElse(null);
                if (material != null) {
                    if(!useMaterialids.contains(materialID1)) {
                        useMaterials.add(material);
                        useMaterialids.add(materialID1);
                    }
                   if(!material.getMaterialTypeName().equals("MP")) {
                       materialIds.add(materialID1);
                   }
                }
            }
            for (RoutingSupportingReplace routingSupportingReplace:routingsupportingreplaces1) {
                String materialID1= routingSupportingReplace.getMaterialid();
                if(!useMaterialids.contains(materialID1)) {
                    Material material = _materials.stream()
                            .filter(m -> m.getId().equals(materialID1))
                            .findFirst()
                            .orElse(null);
                    if (material != null) {
                        useMaterials.add(material);
                        useMaterialids.add(materialID1);
                    }
                }
            }

            Map<Integer,Object> r1=preloadSfRoutingBomCache(materialIds, headers, routingsupportings, routingsupportingreplaces);
            List<Long> routingIds2=(List<Long>) r1.get(1);
            List<Material> useMaterials2=( List<Material>) r1.get(2);
            if(routingIds2!=null)
            {
                routingIds.addAll(routingIds2);
            }
            if(useMaterials2!=null&&useMaterials2.size()>0) {
                for (Material m:useMaterials2) {
                    String materialID1= m.getId();
                    if(!useMaterialids.contains(materialID1)) {
                        useMaterials.add(m);
                        useMaterialids.add(materialID1);
                    }
                }
            }
        }
        if(routingIds1!=null)
        {
            routingIds.addAll(routingIds1);
        }
        reslte.put(1,routingIds);
        reslte.put(2,useMaterials);
        return reslte;
    }


    private  List<Long> preloadSfRoutingCache(String sceneId,List<Long> routingIds) {


        List<RoutingDetail> RoutingDetails = null;
        List<RoutingDetailEquip> routingDetailEquips = null;
        List<RoutingDetailConnect> connections = null;
        List<RoutingDiscreteParam> routingDiscreteParams=null;
        if (routingIds != null || routingIds.size() > 0) {

            RoutingDetails = lanuchService.getRoutingDetails(routingIds);

            if (RoutingDetails == null && RoutingDetails.size() == 0) {
                return null;
            }

            routingDetailEquips = lanuchService.getRoutingDetailEquip(routingIds);


            LambdaQueryWrapper<RoutingDetailConnect> routingDetailConnectwrapper = new LambdaQueryWrapper<>();
            routingDetailConnectwrapper.in(RoutingDetailConnect::getRoutingHeaderId, routingIds)
                    .eq(RoutingDetailConnect::getIsdeleted, 0); // 添加 isdeleted=0 过滤条件

            connections = routingDetailConnectService.list(routingDetailConnectwrapper);


            List<Long> routingDetailIds = RoutingDetails.stream()
                    .map(RoutingDetail::getId)
                    .distinct()
                    .collect(Collectors.toList());

             routingDiscreteParams = _routingDiscreteParamService.lambdaQuery()
                    .in(RoutingDiscreteParam::getRoutingDetailId, routingDetailIds)
                    .eq(RoutingDiscreteParam::getIsDeleted, 0)
                    .list();


            SaveDetailCache(sceneId,RoutingDetails,routingDetailEquips,connections,routingDiscreteParams);

            if (routingDetailEquips != null && routingDetailEquips.size() > 0) {

                List<Long> equipIds = routingDetailEquips.stream()
                        .map(RoutingDetailEquip::getEquipId)
                        .distinct() // 提取Exec_ID
                        .collect(Collectors.toList());
                return equipIds;
            }
        }
        return null;
    }


    /**
     * 构建多级BOM需求网络
     * @return 所有物料需求列表
     */
    public List<OrderMaterialRequirement> buildMultiLevelRequirementNetwork(Chromosome chromosome,String sceneId, LocalDateTime _baseTime,GlobalParam _globalParam) {
        baseTime=_baseTime;
        globalParam=_globalParam;
        List<OrderMaterialRequirement> allRequirements = new ArrayList<>();
        List<Order> childorders = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();


        List<Entry> allOperations=chromosome.getAllOperations();
        List<Order> orders=chromosome.getOrders();

        Map<Integer, Integer> orderProcessCounter = allOperations.stream()
                .collect(Collectors.groupingBy(Entry::getGroupId, Collectors.collectingAndThen(
                        Collectors.counting(), Long::intValue)))
                .entrySet().stream()
                .collect(Collectors.toMap(Map.Entry::getKey, e -> 0));

        List<Integer> operationSequencing=chromosome.getOperationSequencing();

        for (Integer groupId : operationSequencing)
        {
           Order demand=orders.stream().filter(t->t.getId()==groupId).findFirst().orElse(null);

            if (demand.getFinishOrderId() != null && !demand.getFinishOrderId().isEmpty()) {
                continue;
            }

            int scheduledCount = orderProcessCounter.get(groupId);
            List<Entry> orderOps = allOperations.stream()
                    .filter(t -> t.getGroupId() == groupId)
                    .sorted(Comparator.comparing(Entry::getSequence))
                    .collect(Collectors.toList());

            if (scheduledCount >= orderOps.size()) {
                throw new IllegalStateException(String.format(
                        "订单%d的工序已全部调度（共%d道），无需重复处理！",
                        groupId, orderOps.size()));
            }
            Entry operation = orderOps.get(scheduledCount);

            // 调用BuildOperationBOM方法（返回结果对象替代out参数）
            BOMBuildResult operationResult = buildOperationSFBOM(operation.getOrderId(), "",
                    operation.getQuantity(), operation, 1,demand,sceneId,chromosome);
//                // 合并物料需求和子订单
            if(operationResult!=null) {
                allRequirements.addAll(operationResult.getMaterialRequirements());
                childorders.addAll(operationResult.getChildOrders());
                _newEntrys.addAll(operationResult.getNewEntrys());
            }
            orderProcessCounter.put(groupId, orderProcessCounter.get(groupId) + 1);
        }



        // 将子订单添加到全局订单列表
        if (orders != null) {
            orders.addAll(childorders);
            // _allOperations.addAll(_newEntrys);
        }

        return allRequirements;
    }



    /**
     * 构建订单BOM
     * @param parent 父项ID
     * @param materialID 物料ID
     * @param mainorderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象
     */
    public BOMBuildResult buildOrderBOM(String sceneId,int parent, String materialID, String mainorderId,
                                        String childorderId, double parentQuantity, int level,Order forder,int finishOpertionID,Chromosome chromosome) {
        forder.setCreateBom(true);

      List<RoutingHeader>  headers=GetRoutingHeader(sceneId);
        RoutingHeader routingHeaders=  headers.stream()
                .filter(t->t.getId()==parent|| t.getMaterialId().equals(materialID))
                .findFirst()
                .orElse(null);
        List<RoutingHeader>  headers1;
        // 若未找到产品，返回空结果（根据业务可调整为抛出异常）
        if (routingHeaders==null) {
            return null;
        }

        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> childorders2 = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();
        List<Machine> _newMachines = new ArrayList<>();
       // 遍历产品的工序，递归构建工序BOM

        List<Entry> _allOperations= chromosome.getAllOperations();

        List<Entry> Operations= _allOperations.stream()
                .filter(t->t.getOrderId().equals(childorderId))
                .collect(Collectors.toList());




         if (Operations != null) {
            for (Entry operation : Operations) {
                if(finishOpertionID!=0)
                {
                    if(operation.getTargetFinishedOperationId()==null)
                    {
                        operation.setTargetFinishedOperationId(new ArrayList<>());
                    }
                    operation.getTargetFinishedOperationId().add(finishOpertionID);
                }
                // 调用BuildOperationBOM方法（返回结果对象替代out参数）
                BOMBuildResult operationResult = buildOperationBOM(mainorderId, childorderId,
                        parentQuantity, operation, level,forder,sceneId,chromosome);
//                // 合并物料需求和子订单
                if(operationResult!=null) {
                    materialRequirements.addAll(operationResult.getMaterialRequirements());
                    childorders2.addAll(operationResult.getChildOrders());
                    _newEntrys.addAll(operationResult.getNewEntrys());
                }
            }
        }

        return new BOMBuildResult(materialRequirements, childorders2,_newEntrys);

    }
    /**
     * 构建工序BOM需求
     * @param orderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量
     * @param operation 工序对象
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public BOMBuildResult buildOperationBOM(String orderId, String childorderId, double parentQuantity,
                                            Entry operation, int level,Order forder,String sceneId,Chromosome chromosome) {
        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> _childorders = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();
        List<Machine> _newMachines = new ArrayList<>();

        List<Routingsupporting> routingsupportings=GetRoutingsupportings(sceneId);

        List<Routingsupporting> MaterialRequirements=  routingsupportings.stream()
                .filter(t->t.getRoutingDetailId().equals(operation.getRoutingDetailId()))
                .collect(Collectors.toList());
        List<Order> orders=chromosome.getOrders();
        if (MaterialRequirements != null&&MaterialRequirements.size()>0) {
            List<Material> _materials= GetMaterials(sceneId);
            for (Routingsupporting component : MaterialRequirements) {

                double allneeded =  component.getSpentQty().doubleValue()/ component.getMainQty().doubleValue() * parentQuantity;
                double needed = allneeded;

                // 查找物料（流式处理替代First）
                Material material = _materials.stream()
                        .filter(m -> m.getId().equals(component.getMaterialId()))
                        .findFirst()
                        .orElse(null);
                if (material == null) {
                    return null;
                }

                OrderMaterialRequirement orderMaterial= CreateMaterialRequirement(material,orderId,childorderId,operation,allneeded,component.getSpentQty().doubleValue(), component.getMainQty().doubleValue() , parentQuantity);
               orderMaterial.setLevel(level);
                orderMaterial.setBomId(component.getStrId());
                materialRequirements.add(orderMaterial);

                if (!orderMaterial.getMaterialTypeName().equals("MP") ) {

                    // 处理半成品/成品的现有订单
                    List<Order> orders2 = orders.stream()
                            .filter(t -> t.getMaterialId().equals(orderMaterial.getMaterialId())  && t.getSYQuantity() > 0)
                            .sorted(Comparator.comparing(Order::getDueDate))
                            .collect(Collectors.toList());

                    if (!orders2.isEmpty()) {
                        for (Order order : orders2) {
                            if (order.getFinishOrderId() == null) {
                                order.setFinishOrderId(new ArrayList<>());
                                order.setTargetFinishedOperationId(new ArrayList<>());
                            }
                            order.getFinishOrderId().add(forder.getId());
                            order.getTargetFinishedOperationId().add(operation.getId());

                            orderMaterial.getProductOrderID().add(order.getId());

                            double useq = Math.min(needed, order.getSYQuantity());
                            needed -= useq;
                            order.setSYQuantity(order.getSYQuantity() - useq);

                            //防止已经生成过一次
                            if (!order.isCreateBom()) {
                                // 递归构建BOM
                                int l = level + 1;

                                BOMBuildResult childResult = buildOrderBOM(sceneId,0, orderMaterial.getMaterialId(),
                                        orderId, order.getOrderId(),
                                        order.getQuantity(), l,order,operation.getId(),chromosome);
                             //   materialRequirements.addAll(childResult.getMaterialRequirements());
                                _childorders.addAll(childResult.getChildOrders());
                                _newEntrys.addAll(childResult.getNewEntrys());
                                operation.getDependentOnOrderIds().add(order.getId());
                            }

                            if (needed <= 0) {
                                break;
                            }
                        }
                    }

                    // 更新已配和缺件数量
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);

                    if (needed > 0&&globalParam.isIsCheckSf()) {
                        // 创建新的子订单
                        Order childorder = new Order();
                        String OrderId = UUID.randomUUID().toString().replace("-", "");

                        childorder.setOrderId(OrderId);
                        childorder.setMaterialId(orderMaterial.getMaterialId());
                        childorder.setMaterialCode(orderMaterial.getMaterialCode());
                        childorder.setMaterialName(orderMaterial.getMaterialTypeName());
                        childorder.setOrderCode("M_"+orderMaterial.getMaterialCode());
                        childorder.setQuantity((int) orderMaterial.getQjQty());
                        childorder.setFinishOrderId(new ArrayList<>());
                        childorder.getFinishOrderId().add(forder.getId());
                        childorder.setNewCreate(true);
                        childorder.setTargetFinishedOperationId(new ArrayList<>());
                        childorder.getTargetFinishedOperationId().add(operation.getId());
                        childorder.setSerie(forder.getSerie());

                        childorder.setStartDate(forder.getStartDate());
                        childorder.setDueDate(forder.getDueDate());
                        childorder.setPriority(forder.getPriority());
                        childorder.setActualPriority(forder.getActualPriority());


                        Map<Integer, Object> list= CreateChild(sceneId,childorder,orderMaterial.getMaterialId(), operation.getId(),chromosome);
                        if(list==null)
                        {
                            continue;
                        }
                        _childorders.add(childorder);
                        List<Entry>  newentrys=(List<Entry>)list.get(1);
                        _newEntrys.addAll(newentrys);

                        orderMaterial.getProductOrderID().add(childorder.getId());
                        operation.getDependentOnOrderIds().add(childorder.getId());
                        // 递归构建BOM
                        int l = level + 1;
                        BOMBuildResult childResult = buildOrderBOM(sceneId,0, orderMaterial.getMaterialId(),
                                orderId, childorder.getOrderId(),
                                childorder.getQuantity(), l,childorder,0,chromosome);
                      //  materialRequirements.addAll(childResult.getMaterialRequirements());
                        _childorders.addAll(childResult.getChildOrders());
                        _newEntrys.addAll(childResult.getNewEntrys());
                    }
                }

            }
        }
        operation.setMaterialRequirements(materialRequirements);

        return new BOMBuildResult(materialRequirements, _childorders,_newEntrys);
    }


    private  Map<Integer, Object> CreateChild(String sceneId,  Order order,String materialID,int finishOpertionID,Chromosome chromosome)
    {

        Long  routingIds=0l;
        List<RoutingHeader> headers=GetRoutingHeader(sceneId);
        RoutingHeader headers1=  headers.stream()
                .filter(t->t.getMaterialId().equals(materialID))
                .findFirst().orElse(null);
if(headers1==null)
{
    return null;
}
        routingIds=headers1.getId().longValue();


        Long headersid=routingIds;
        List<RoutingDetail> allRoutingDetails=GetRoutingDetails(sceneId);
        List<RoutingDetail> RoutingDetails=  allRoutingDetails.stream()
                .filter(t->t.getRoutingHeaderId().equals(headersid))
                .collect(Collectors.toList());

        List<RoutingDetailConnect> connections=null;
        if(RoutingDetails==null||RoutingDetails.size()==0) {
            return null;
        }
        List<RoutingDetailEquip> allroutingDetailEquips=GetRoutingDetailEquips(sceneId);
        List<RoutingDetailEquip> routingDetailEquips=  allroutingDetailEquips.stream()
                    .filter(t->t.getRoutingHeaderId().equals(headersid))
                    .collect(Collectors.toList());



        order.setRoutingId(headers1.getId());
        order.setRoutingCode(headers1.getCode());
        ProdLaunchOrder prodOrderMain= convertToLaunchOrder(order,sceneId);

        List<RoutingDetailEquip> finalRoutingDetailEquips = routingDetailEquips;
        Integer departmentId = headers1.getDepartmentId() != null ? headers1.getDepartmentId() : null;
        List<ProdProcessExec> processExecList = RoutingDetails.stream()
                .map(detail -> lanuchService.createProcessExec(prodOrderMain, detail, sceneId, finalRoutingDetailEquips, departmentId))
                .collect(Collectors.toList());

        List<Equipinfo> equipinfoList=GetEquipinfos();

        List<ProdEquipment> ProdEquipmentList=  lanuchService.batchInsertEquipMent(routingDetailEquips, sceneId,processExecList,false,equipinfoList);



        Map<String, String> routingDetailIdToExecIdMap = processExecList.stream()
                .collect(Collectors.toMap(
                        exec -> exec.getRoutingDetailId() + "_" + exec.getOrderId(), // 复合键：工序ID_订单ID
                        ProdProcessExec::getExecId,
                        (existing, replacement) -> existing)); // 处理重复key的情况

        List<RoutingDetailConnect> allroutingDetailconnections=GetRoutingDetailConnect(sceneId);

            connections=  allroutingDetailconnections.stream()
                    .filter(t->t.getRoutingHeaderId().equals(headersid))
                    .collect(Collectors.toList());


        List<ProdOrderProcess>  ProdOrderProcesslist=  connections.stream()
                .map(connection -> lanuchService.createProcessRelation(prodOrderMain, connection, sceneId, routingDetailIdToExecIdMap))
                .collect(Collectors.toList());

        List<Long> routingDetailIds = RoutingDetails.stream()
                .map(RoutingDetail::getId)
                .distinct()
                .collect(Collectors.toList());
        List<RoutingDiscreteParam> allroutingDiscreteParams=GetRoutingDiscreteParam(sceneId);
        List<RoutingDiscreteParam> routingDiscreteParams=  allroutingDiscreteParams.stream()
                .filter(t->routingDetailIds.contains(t.getRoutingDetailId()))
                .collect(Collectors.toList());




        List<Order> ProdLaunchOrders=new ArrayList<>();
        ProdLaunchOrders.add(order);

        Map<Integer, Object> list=_routingDataService.CreateEntry( sceneId,  ProdEquipmentList,  ProdLaunchOrders, routingDiscreteParams, ProdOrderProcesslist, processExecList,chromosome.getOperatRel(),finishOpertionID );


        if(list.get(1)!=null)
        {
            chromosome.getAllOperations().addAll(new CopyOnWriteArrayList((List<Entry>)list.get(1)) );

            chromosome.setOperatRel(new CopyOnWriteArrayList((List<GroupResult>)list.get(2)));
        }
        Map<Integer, Object> rest=new HashMap<>();
        rest.put(1,list.get(1));

        return rest;
    }

    private ProdLaunchOrder convertToLaunchOrder(Order order, String sceneId) {
        try {
            ProdLaunchOrder launchOrder = new ProdLaunchOrder();
            launchOrder.setOrderId(order.getOrderId());
            launchOrder.setSceneId(sceneId);
            launchOrder.setSerie(order.getSerie());
            launchOrder.setCreateUser("GA");
            launchOrder.setMaterialCode(order.getMaterialCode());
            launchOrder.setMaterialName(order.getMaterialName());
//            launchOrder.setStartDate(order.get);
            launchOrder.setEndDate(order.getDueDate());
//            launchOrder.setOrderPriority(order.getPrioritry());
            launchOrder.setOrderPriority(order.getPriority());
            launchOrder.setQuantity(order.getQuantity());
            launchOrder.setMaterialId(order.getMaterialId());


            launchOrder.setRoutingId(order.getRoutingId());
            launchOrder.setRoutingCode("");


            return launchOrder;
        } catch (Exception e) {

            return null;
        }
    }



    /**
     * 构建工序BOM需求
     * @param orderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量
     * @param operation 工序对象
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public BOMBuildResult buildOperationSFBOM(String orderId, String childorderId, double parentQuantity,
                                            Entry operation, int level,Order forder,String sceneId,Chromosome chromosome) {
        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> _childorders = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();

        List<OrderMaterialRequirement> MaterialRequirements= operation.getMaterialRequirements();

        List<Order> orders=chromosome.getOrders();

        if (MaterialRequirements != null&&MaterialRequirements.size()>0) {
            for (OrderMaterialRequirement orderMaterial : MaterialRequirements) {

                double allneeded = parentQuantity * orderMaterial.getRequiredQuantity();

                double needed = allneeded;

                // 查找物料（流式处理替代First）

                    if (!orderMaterial.getMaterialTypeName().equals("MP") ) {

                        // 处理半成品/成品的现有订单
                        // 为什么要先找现有订单，绑定上，因为要把它排在成品工单前面，才能有时间
                        List<Order> orders2 = orders.stream()
                                .filter(t -> t.getMaterialId().equals(orderMaterial.getMaterialId())  && t.getSYQuantity() > 0)
                                .sorted(Comparator.comparing(Order::getDueDate))
                                .collect(Collectors.toList());

                        if (!orders2.isEmpty()) {
                            for (Order order : orders2) {
                                if (order.getFinishOrderId() == null) {
                                    order.setFinishOrderId(new ArrayList<>());
                                    order.setTargetFinishedOperationId(new ArrayList<>());
                                }
                                order.getFinishOrderId().add(forder.getId());
                                order.getTargetFinishedOperationId().add(operation.getId());

                                orderMaterial.getProductOrderID().add(order.getId());

                                double useq = Math.min(needed, order.getSYQuantity());
                                needed -= useq;
                                order.setSYQuantity(order.getSYQuantity() - useq);

                                //防止已经生成过一次
                                if (!order.isCreateBom()) {
                                    // 递归构建BOM
                                    int l = level + 1;

                                    BOMBuildResult childResult = buildOrderBOM(sceneId,0, orderMaterial.getMaterialId(),
                                            orderId, order.getOrderId(),
                                            order.getQuantity(), l,order,operation.getId(),chromosome);
                                    materialRequirements.addAll(childResult.getMaterialRequirements());
                                    _childorders.addAll(childResult.getChildOrders());
                                    _newEntrys.addAll(childResult.getNewEntrys());
                                    operation.getDependentOnOrderIds().add(order.getId());
                                }

                                if (needed <= 0) {
                                    break;
                                }
                            }
                        }

                        // 更新已配和缺件数量
                        orderMaterial.setYpQty(allneeded - needed);
                        orderMaterial.setQjQty(needed);

                        if (needed > 0&&globalParam.isIsCheckSf()) {
                            // 创建新的子订单
                            Order childorder = new Order();
                            String OrderId = UUID.randomUUID().toString().replace("-", "");

                            childorder.setOrderId(OrderId);
                            childorder.setMaterialId(orderMaterial.getMaterialId());
                            childorder.setMaterialCode(orderMaterial.getMaterialCode());
                            childorder.setMaterialName(orderMaterial.getMaterialTypeName());
                            childorder.setOrderCode("M_"+orderMaterial.getMaterialCode());
                            childorder.setQuantity((int) orderMaterial.getQjQty());
                            childorder.setFinishOrderId(new ArrayList<>());
                            childorder.getFinishOrderId().add(forder.getId());
                            childorder.setNewCreate(true);
                            childorder.setTargetFinishedOperationId(new ArrayList<>());
                            childorder.getTargetFinishedOperationId().add(operation.getId());
                            childorder.setSerie(forder.getSerie());

                            childorder.setStartDate(forder.getStartDate());
                            childorder.setDueDate(forder.getDueDate());
                            childorder.setPriority(forder.getPriority());
                            childorder.setActualPriority(forder.getActualPriority());


                            Map<Integer, Object> list= CreateChild(sceneId,childorder,orderMaterial.getMaterialId(), operation.getId(),chromosome);
                            if(list==null)
                            {
                                continue;
                            }
                            _childorders.add(childorder);
                            List<Entry>  newentrys=(List<Entry>)list.get(1);
                            _newEntrys.addAll(newentrys);

                            orderMaterial.getProductOrderID().add(childorder.getId());
                            operation.getDependentOnOrderIds().add(childorder.getId());
                            // 递归构建BOM
                            int l = level + 1;
                            BOMBuildResult childResult = buildOrderBOM(sceneId,0, orderMaterial.getMaterialId(),
                                    orderId, childorder.getOrderId(),
                                    childorder.getQuantity(), l,childorder,0,chromosome);
                            materialRequirements.addAll(childResult.getMaterialRequirements());
                            _childorders.addAll(childResult.getChildOrders());
                            _newEntrys.addAll(childResult.getNewEntrys());
                        }
                    }
            }
        }

        return new BOMBuildResult(materialRequirements, _childorders,_newEntrys);
    }

    private OrderMaterialRequirement MaterialStock(Material material,String materialId,String orderId, String childorderId, Entry operation,double allneeded, double needed,LocalDateTime earliestStartTime ) {

        OrderMaterialRequirement orderMaterial = new OrderMaterialRequirement();
        orderMaterial.setOrderId(orderId);
        orderMaterial.setOperationId(operation.getId());
        orderMaterial.setChildOrderId(StringUtils.isBlank(childorderId) ? orderId : childorderId);
        orderMaterial.setRequiredQuantity(allneeded);

        double availableNow = material.getCurrentStock();
        orderMaterial.setMaterialCode(material.getCode());
        orderMaterial.setMaterialName(material.getName());
        orderMaterial.setMaterialTypeName(material.getMaterialTypeName());
        orderMaterial.setMaterialId(material.getId());
      //  orderMaterial.setCheckLeadTime(material.getCkeckLeadTime());
        double useStock=0;
        // 扣减现有库存
        List<Stock> stocks= material.getMaterialStocks().stream()
                .filter(t->t.getExpiryDate().compareTo(earliestStartTime)>=0&&t.getAvailableInventory()>0)
                .collect(Collectors.toList());
        if(stocks!=null)
        {
            for (Stock s:stocks) {
                double useStock1 = Math.min(needed,s.getAvailableInventory());
                needed -=useStock1;
                useStock+=useStock1;
                s.setUsedInventory(s.getUsedInventory()+useStock1);
                if(needed==0)
                {
                    break;
                }
            }
        }



        orderMaterial.setUseStock(useStock);

        return orderMaterial;
    }


    private OrderMaterialRequirement CreateMaterialRequirement(Material material,String orderId, String childorderId, Entry operation,double need,double spentQty,double mainQty,double qty) {

        OrderMaterialRequirement orderMaterial = new OrderMaterialRequirement();
        orderMaterial.setOrderId(orderId);
        orderMaterial.setOperationId(operation.getId());
        orderMaterial.setChildOrderId(StringUtils.isBlank(childorderId) ? orderId : childorderId);
        orderMaterial.setMaterialCode(material.getCode());
        orderMaterial.setMaterialName(material.getName());
        orderMaterial.setMaterialTypeName(material.getMaterialTypeName());
        orderMaterial.setMaterialId(material.getId());
        orderMaterial.setCheckLeadTime(0);
        orderMaterial.setPurchaseTime(0);
        orderMaterial.setRequiredQuantity(need);
        orderMaterial.setSpentQty(spentQty);
        orderMaterial.setMainQty(mainQty);
        orderMaterial.setQuantity(qty);

        List<MaterialPurchase> materialPurchaseList=material.getMaterialPurchases();
        if(materialPurchaseList!=null&&materialPurchaseList.size()>0)
        {
            Optional<MaterialPurchase> maxItem = materialPurchaseList.stream()
                    // 按purchaseCycle+inspectionCycle降序排序
                    .max((o1, o2) -> {
                        // 计算第一个对象的和（空值处理，避免空指针）
                        int sum1 = (o1.getPurchaseCycle() == null ? 0 : o1.getPurchaseCycle())
                                + (o1.getInspectionCycle() == null ? 0 : o1.getInspectionCycle());
                        // 计算第二个对象的和
                        int sum2 = (o2.getPurchaseCycle() == null ? 0 : o2.getPurchaseCycle())
                                + (o2.getInspectionCycle() == null ? 0 : o2.getInspectionCycle());
                        return Integer.compare(sum1, sum2);
                    });
            if (maxItem.isPresent()) {
                MaterialPurchase result = maxItem.get();

                orderMaterial.setCheckLeadTime(result.getPurchaseCycle());
                orderMaterial.setPurchaseTime(result.getInspectionCycle());
            }
        }
        orderMaterial.setUseTime(baseTime.plusDays(orderMaterial.getPurchaseTime()+orderMaterial.getCheckLeadTime()));

        return orderMaterial;
    }

    /**
     * 构建工序BOM需求

     * @param operation 工序对象

     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public void EditOperationBOM(Entry operation,Chromosome chromosome,LocalDateTime earliestStartTime,GeneticDecoder coder) {
        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();

        String sceneId=chromosome.getScenarioID();
        Random rnd = new Random();
        List<OrderMaterialRequirement> MaterialRequirements=  operation.getMaterialRequirements();

         MaterialRequirements = MaterialRequirements.stream()
                .sorted((a, b) -> {
                    // 定义判断条件：是否满足 非MP + 生产订单ID非空非空串
                    boolean aMatch = !"MP".equals(a.getMaterialTypeName())
                            && a.getProductOrderID() != null && !a.getProductOrderID().isEmpty();
                    boolean bMatch = !"MP".equals(b.getMaterialTypeName())
                            && b.getProductOrderID() != null && !b.getProductOrderID().isEmpty();

                    // 排序规则：满足的排前面，不满足的排后面；都满足/都不满足则保持原序
                    if (aMatch && !bMatch) return -1;  // a满足b不满足，a在前
                    if (!aMatch && bMatch) return 1;   // a不满足b满足，b在前
                    return 0;                          // 同状态，保持原序
                })
                .collect(Collectors.toList());

        List<Material> materials=chromosome.getMaterials();
        List<OrderMaterialRequirement> remove=new ArrayList<>();
        if (MaterialRequirements != null&&MaterialRequirements.size()>0) {
            for (OrderMaterialRequirement orderMaterial : MaterialRequirements) {


                double allneeded = orderMaterial.getSpentQty()/ orderMaterial.getMainQty() * operation.getQuantity();

                double needed = allneeded;
                orderMaterial.setRequiredQuantity(needed);
                // 查找物料（流式处理替代First）
                Material material = materials.stream()
                        .filter(m -> m.getId().equals(orderMaterial.getMaterialId()))
                        .findFirst()
                        .orElse(null);
                if (material == null) {
                    return ;
                }

                double useStock=0;

                List<Stock> stocks= material.getMaterialStocks().stream()
                        .filter(t->t.getExpiryDate().compareTo(earliestStartTime)>=0&&t.getAvailableInventory()>0)
                        .collect(Collectors.toList());
                if(stocks!=null)
                {
                    for (Stock s:stocks) {
                        double useStock1 = Math.min(needed,s.getAvailableInventory());
                        needed -=useStock1;
                        useStock+=useStock1;
                        s.setUsedInventory(s.getUsedInventory()+useStock1);
                        if(needed==0)
                        {
                            break;
                        }
                    }
                }

                if (needed <= 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);
                    remove.add(orderMaterial);
                    continue;
                }
                List<RoutingSupportingReplace> routingsupportingreplaces= GetRoutingSupportingReplaces(sceneId);
                List<RoutingSupportingReplace> routingsupportingreplaces2=null;
                if (routingsupportingreplaces != null && routingsupportingreplaces.size() > 1) {
                    routingsupportingreplaces2 = routingsupportingreplaces.
                            stream()
                            .filter(t -> t.getStrsupid().equals(orderMaterial.getBomId())
                                    && t.getMaterialid() != orderMaterial.getMaterialId())
                            .collect(Collectors.toList());
                    if (routingsupportingreplaces2 != null && routingsupportingreplaces2.size() > 1) {
                        for (RoutingSupportingReplace rsr : routingsupportingreplaces2) {
                            Material material1 = materials.stream()
                                    .filter(m -> m.getId().equals(rsr.getMaterialid()))
                                    .findFirst()
                                    .orElse(null);
                            if (material1 == null) {
                                break;
                            }
                            OrderMaterialRequirement orderMaterial1 = MaterialStock(material1, rsr.getMaterialid(), orderMaterial.getOrderId(), orderMaterial.getChildOrderId(), operation, allneeded, needed, earliestStartTime);
                            if (orderMaterial1 != null) {
                                useStock = orderMaterial1.getUseStock();
                                needed -= useStock;
                                orderMaterial.setUseStock(orderMaterial.getUseStock() + useStock);
                                orderMaterial.getReplaceMaterial().add(orderMaterial1);
                                if (needed <= 0) {
                                    break;
                                }
                            }
                        }
                    }

                }
                if (needed <= 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);
                    remove.add(orderMaterial);
                    continue;
                }

                MaterialInTransit(material,"",orderMaterial,needed,earliestStartTime);

                needed -= orderMaterial.getUseTransit();

                if (routingsupportingreplaces2 != null && routingsupportingreplaces2.size() > 1)
                {
                    for (RoutingSupportingReplace rsr:routingsupportingreplaces2) {

                        OrderMaterialRequirement  orderMaterial1=    orderMaterial.getReplaceMaterial().stream()
                                .filter(t->t.getMaterialId().equals(rsr.getMaterialid()))
                                .findFirst()
                                .orElse(null);

                        Material material1 = materials.stream()
                                .filter(m -> m.getId().equals(orderMaterial1.getMaterialId()))
                                .findFirst()
                                .orElse(null);
                        if (material1 == null) {
                            break;
                        }

                        MaterialInTransit(material1,rsr.getMaterialid(),orderMaterial1,needed,earliestStartTime);


                        needed -= orderMaterial1.getUseTransit();
                        LocalDateTime earliestTime= orderMaterial.getArrivalTime().compareTo(orderMaterial1.getArrivalTime())>0?orderMaterial.getArrivalTime():orderMaterial1.getArrivalTime();
                        orderMaterial.setArrivalTime(earliestTime);
                        orderMaterial.setUseTransit(orderMaterial.getUseTransit()+orderMaterial1.getUseTransit());

                        if (needed <= 0) {
                            break;
                        }
                    }
                }

                if (needed <= 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);
                    remove.add(orderMaterial);
                    continue;
                }
                if (needed > 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);

                    if (material.getMaterialTypeName().equals("MP") ) {
                        // 处理原材料采购时间
                        orderMaterial.setPurchaseStartTime(baseTime);
                        // 采购结束时间 = 采购开始时间 + 采购提前期（天）


                        List<MaterialPurchase> materialPurchaseList=material.getMaterialPurchases();
                        if(materialPurchaseList!=null&&materialPurchaseList.size()>0) {

                            int randomSeq = rnd.nextInt(materialPurchaseList.size());

                            MaterialPurchase result = materialPurchaseList.get(randomSeq);

                            orderMaterial.setCheckLeadTime(result.getPurchaseCycle());
                            orderMaterial.setPurchaseTime(result.getInspectionCycle());
                            LocalDateTime purchaseEndTime = baseTime.plusDays(orderMaterial.getPurchaseTime() + orderMaterial.getCheckLeadTime());
                            orderMaterial.setPurchaseEndTime(purchaseEndTime);
                        }

                    } else {
                        // 处理半成品/成品的现有订单

                        List<Integer> orderids= orderMaterial.getProductOrderID();
                       if(orderids!=null&&orderids.size()>0) {
                           for (Integer orderid : orderids) {
                               coder.EditorderOperation(chromosome, orderid, needed);
                           }
                       }else {
                           List<MaterialPurchase> materialPurchaseList=material.getMaterialPurchases();
                           if(materialPurchaseList!=null&&materialPurchaseList.size()>0) {

                               int randomSeq = rnd.nextInt(materialPurchaseList.size());

                               MaterialPurchase result = materialPurchaseList.get(randomSeq);

                               orderMaterial.setCheckLeadTime(result.getPurchaseCycle());
                               orderMaterial.setPurchaseTime(result.getInspectionCycle());
                               LocalDateTime purchaseEndTime = baseTime.plusDays(orderMaterial.getPurchaseTime() + orderMaterial.getCheckLeadTime());
                               orderMaterial.setPurchaseEndTime(purchaseEndTime);
                           }
                       }
                    }
                }

                // 计算预计可用时间
                LocalDateTime arrivalTime = orderMaterial.getArrivalTime();
                LocalDateTime purchaseEndTime = orderMaterial.getPurchaseEndTime();
                LocalDateTime useTime = null;

                if (arrivalTime == null) {
                    useTime = purchaseEndTime;
                } else {
                    if (purchaseEndTime != null && purchaseEndTime.isAfter(arrivalTime)) {
                        useTime = purchaseEndTime;
                    } else {
                        useTime = arrivalTime;
                    }
                }
                orderMaterial.setUseTime(useTime);
            }
        }


        if (remove != null&&remove.size()>0) {
            //删除先删排产结果，然后记录orderID,到排产方案里，最后一起删除
            for (OrderMaterialRequirement mr:remove) {
                List<Integer> orderids= mr.getProductOrderID();
                if(orderids!=null&&orderids.size()>0) {
                    for (Integer orderid : orderids) {
                        coder.DelOrder(chromosome, orderid,mr);
                    }
                }
            }
            MaterialRequirements.removeAll(remove);
        }
    }




    private void MaterialInTransit(Material material,String materialId, OrderMaterialRequirement orderMaterial, double needed,LocalDateTime earliestStartTime ){

        // 处理在途物料
        double accumulated = 0;
        LocalDateTime earliestTime = LocalDateTime.of(2000,1,1,0,0,0);
        double useTransit = 0;
        if (material == null) {
            material = _materials.stream()
                    .filter(m -> m.getId().equals(materialId))
                    .findFirst()
                    .orElse(null);
            if (material == null) {
                return ;
            }
        }
        // 按到货时间排序在途物料
        Long CkeckLeadTime=  material.getCkeckLeadTime();
        List<MaterialSupply> sortedInTransit = material.getInTransit().stream()
                .filter(t -> t.getQuantity() > 0&&t.getArrivalTime().compareTo(earliestStartTime.plusDays(-CkeckLeadTime))<=0 )
                .sorted(Comparator.comparing(MaterialSupply::getArrivalTime))
                .collect(Collectors.toList());

        for (MaterialSupply supply : sortedInTransit) {
            double useq = Math.min(needed, supply.getQuantity());
            useTransit += useq;
            needed -= useq;
            supply.setQuantity(supply.getQuantity() - useq);
            earliestTime=earliestTime.compareTo(supply.getArrivalTime())>0?earliestTime:supply.getArrivalTime();
            if (needed <= 0) {
                break;
            }
        }

        orderMaterial.setUseTransit(useTransit);
        orderMaterial.setArrivalTime(earliestTime);

    }
    private void  SaveBomCache(String sceneId,List<RoutingHeader> routingHeaders,List<Routingsupporting> routingsupportings,List<RoutingSupportingReplace> replaces,List<Material> useMaterials)
    {
        redisUtils.set(sceneId+routingHeaderCacheKey,routingHeaders);
        GlobalCacheUtil.put(sceneId+routingHeaderCacheKey,routingHeaders, cachetimeout, TimeUnit.MINUTES);

        redisUtils.set(sceneId+routingsupportingCacheKey,routingsupportings);
        GlobalCacheUtil.put(sceneId+routingsupportingCacheKey,routingsupportings, cachetimeout, TimeUnit.MINUTES);

        redisUtils.set(sceneId+routingSupportingReplaceCacheKey,replaces);
        GlobalCacheUtil.put(sceneId+routingSupportingReplaceCacheKey,replaces, cachetimeout, TimeUnit.MINUTES);

        redisUtils.set(sceneId+materialsCacheKey,useMaterials);
        GlobalCacheUtil.put(sceneId+materialsCacheKey,useMaterials, cachetimeout, TimeUnit.MINUTES);


    }
    private void  SaveDetailCache(String sceneId,List<RoutingDetail> RoutingDetails,List<RoutingDetailEquip> routingDetailEquips,List<RoutingDetailConnect> connections,List<RoutingDiscreteParam> routingDiscreteParams)
    {

        redisUtils.set(sceneId+routingDetailCacheKey,RoutingDetails);
        GlobalCacheUtil.put(sceneId+routingDetailCacheKey,RoutingDetails, cachetimeout, TimeUnit.MINUTES);

        redisUtils.set(sceneId+routingDetailEquipCacheKey,routingDetailEquips);
        GlobalCacheUtil.put(sceneId+routingDetailEquipCacheKey,routingDetailEquips, cachetimeout, TimeUnit.MINUTES);

        redisUtils.set(sceneId+routingDetailConnectCacheKey,connections);
        GlobalCacheUtil.put(sceneId+routingDetailConnectCacheKey,connections, cachetimeout, TimeUnit.MINUTES);

        redisUtils.set(sceneId+routingDiscreteParamCacheKey,routingDiscreteParams);
        GlobalCacheUtil.put(sceneId+routingDiscreteParamCacheKey,routingDiscreteParams, cachetimeout, TimeUnit.MINUTES);


    }

    private List<RoutingHeader>  GetRoutingHeader(String sceneId) {
        List<RoutingHeader> RoutingHeaders=(List<RoutingHeader>)GlobalCacheUtil.get(sceneId+routingHeaderCacheKey);
        if(RoutingHeaders==null)
        {
            RoutingHeaders=(List<RoutingHeader>)redisUtils.get(sceneId+routingHeaderCacheKey);
            if(RoutingHeaders!=null)
            {
                GlobalCacheUtil.put(sceneId+routingHeaderCacheKey,RoutingHeaders, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return RoutingHeaders;
    }
    private List<Routingsupporting>  GetRoutingsupportings(String sceneId) {
        List<Routingsupporting> Routingsupportings=(List<Routingsupporting>)GlobalCacheUtil.get(sceneId+routingsupportingCacheKey);
        if(Routingsupportings==null)
        {
            Routingsupportings=(List<Routingsupporting>)redisUtils.get(sceneId+routingsupportingCacheKey);
            if(Routingsupportings!=null)
            {
                GlobalCacheUtil.put(sceneId+routingsupportingCacheKey,Routingsupportings, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return Routingsupportings;
    }
    private List<RoutingSupportingReplace>  GetRoutingSupportingReplaces(String sceneId) {
        List<RoutingSupportingReplace> RoutingSupportingReplaces=(List<RoutingSupportingReplace>)GlobalCacheUtil.get(sceneId+routingSupportingReplaceCacheKey);
        if(RoutingSupportingReplaces==null)
        {
            RoutingSupportingReplaces=(List<RoutingSupportingReplace>)redisUtils.get(sceneId+routingSupportingReplaceCacheKey);
            if(RoutingSupportingReplaces!=null)
            {
                GlobalCacheUtil.put(sceneId+routingSupportingReplaceCacheKey,RoutingSupportingReplaces, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return RoutingSupportingReplaces;
    }

    private List<RoutingDetail>  GetRoutingDetails(String sceneId) {
        List<RoutingDetail> RoutingDetails=(List<RoutingDetail>)GlobalCacheUtil.get(sceneId+routingDetailCacheKey);
        if(RoutingDetails==null)
        {
            RoutingDetails=(List<RoutingDetail>)redisUtils.get(sceneId+routingDetailCacheKey);
            if(RoutingDetails!=null)
            {
                GlobalCacheUtil.put(sceneId+routingDetailCacheKey,RoutingDetails, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return RoutingDetails;
    }

    private List<RoutingDetailEquip>  GetRoutingDetailEquips(String sceneId) {
        List<RoutingDetailEquip> RoutingDetailEquips=(List<RoutingDetailEquip>)GlobalCacheUtil.get(sceneId+routingDetailEquipCacheKey);
        if(RoutingDetailEquips==null)
        {
            RoutingDetailEquips=(List<RoutingDetailEquip>)redisUtils.get(sceneId+routingDetailEquipCacheKey);
            if(RoutingDetailEquips!=null)
            {
                GlobalCacheUtil.put(sceneId+routingDetailEquipCacheKey,RoutingDetailEquips, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return RoutingDetailEquips;
    }

    private List<RoutingDetailConnect>  GetRoutingDetailConnect(String sceneId) {
        List<RoutingDetailConnect> RoutingDetailConnects=(List<RoutingDetailConnect>)GlobalCacheUtil.get(sceneId+routingDetailConnectCacheKey);
        if(RoutingDetailConnects==null)
        {
            RoutingDetailConnects=(List<RoutingDetailConnect>)redisUtils.get(sceneId+routingDetailConnectCacheKey);
            if(RoutingDetailConnects!=null)
            {
                GlobalCacheUtil.put(sceneId+routingDetailConnectCacheKey,RoutingDetailConnects, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return RoutingDetailConnects;
    }

    private List<RoutingDiscreteParam>  GetRoutingDiscreteParam(String sceneId) {
        List<RoutingDiscreteParam> RoutingDiscreteParams=(List<RoutingDiscreteParam>)GlobalCacheUtil.get(sceneId+routingDiscreteParamCacheKey);
        if(RoutingDiscreteParams==null)
        {
            RoutingDiscreteParams=(List<RoutingDiscreteParam>)redisUtils.get(sceneId+routingDiscreteParamCacheKey);
            if(RoutingDiscreteParams!=null)
            {
                GlobalCacheUtil.put(sceneId+routingDiscreteParamCacheKey,RoutingDiscreteParams, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return RoutingDiscreteParams;
    }

    private List<Material>  GetMaterials(String sceneId) {
        List<Material> materials=(List<Material>)GlobalCacheUtil.get(sceneId+materialsCacheKey);
        if(materials==null)
        {
            materials=(List<Material>)redisUtils.get(sceneId+materialsCacheKey);
            if(materials!=null)
            {
                GlobalCacheUtil.put(sceneId+materialsCacheKey,materials, cachetimeout, TimeUnit.MINUTES);
            }
        }
        return materials;
    }

    private List<Equipinfo>  GetEquipinfos() {
        List<Equipinfo> equipinfoList=(List<Equipinfo>)GlobalCacheUtil.get("equipinfo");
        if(equipinfoList==null)
        {
            equipinfoList = equipinfoService.lambdaQuery().eq(Equipinfo::getIsdeleted, 0).list();

            GlobalCacheUtil.put("equipinfo",equipinfoList, cachetimeout, TimeUnit.MINUTES);

        }
        return equipinfoList;
    }




    public void clearCache(String sceneId) {


        redisUtils.del(sceneId+routingHeaderCacheKey);
        GlobalCacheUtil.remove(sceneId+routingHeaderCacheKey);

        redisUtils.del(sceneId+routingsupportingCacheKey);
        GlobalCacheUtil.remove(sceneId+routingsupportingCacheKey);

        redisUtils.del(sceneId+routingSupportingReplaceCacheKey);
        GlobalCacheUtil.remove(sceneId+routingSupportingReplaceCacheKey);

        redisUtils.del(sceneId+routingDetailCacheKey);
        GlobalCacheUtil.remove(sceneId+routingDetailCacheKey);

        redisUtils.del(sceneId+routingDetailEquipCacheKey);
        GlobalCacheUtil.remove(sceneId+routingDetailEquipCacheKey);

        redisUtils.del(sceneId+routingDetailConnectCacheKey);
        GlobalCacheUtil.remove(sceneId+routingDetailConnectCacheKey);

        redisUtils.del(sceneId+routingDiscreteParamCacheKey);
        GlobalCacheUtil.remove(sceneId+routingDiscreteParamCacheKey);


    }
}
