package com.aps.entity.Algorithm.IDAndChildID;

import lombok.Data;

import java.util.List;

/**
 * 作者：佟礼
 * 时间：2025-11-29
 */
// 存储节点信息：原ID、新序号、新父ID、新子ID列表
@Data
        // 存储节点信息：原ID（String）、全局新序号、分组内序号、新父ID列表、新子ID列表
public class NodeInfo {
    private String originalId;       // 原始ID
    private Integer globalSerial;    // 全局新序号
    private Integer groupSerial;     // 分组内序号
    private List<Integer> newParentIds; // 新父ID列表（基于全局序号）
    private List<Integer> newChildIds;  // 新子ID列表（基于全局序号）

    public NodeInfo(String originalId, Integer globalSerial, Integer groupSerial, List<Integer> newParentIds, List<Integer> newChildIds) {
        this.originalId = originalId;
        this.globalSerial = globalSerial;
        this.groupSerial = groupSerial;
        this.newParentIds = newParentIds;
        this.newChildIds = newChildIds;
    }


    @Override
    public String toString() {
        return originalId + ":" + globalSerial;
    }
}

