package com.aps.controller;

import com.aps.common.util.R;
import com.aps.service.LanuchService;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/lanuch")
@Tag(name = "启动工单", description = "启动工单接口")
public class LanuchController {

    @Autowired
    private LanuchService lanuchService;

    /**
     * 启动工单
     *
     * @param sceneName        场景名称
     * @param username         用户名
     * @return 处理结果
     */
    @PostMapping("/execute")
    public R<String> lanuch(
                            @RequestParam String sceneName,
                            @RequestHeader(required = false) String username) {
        if (username == null || username.isEmpty()) {
            username = "system";
        }
        
        return lanuchService.lanuch(sceneName, username);
    }
}