package com.aps.entity.Algorithm;

import com.aps.entity.basic.Entry;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 作者：佟礼 遗传参数
 * 时间：2025-11-21
 */
    @Data
    public class ScheduleParams {
    private LocalDateTime BaseTime ; // 当前基准时间



    /// <summary>
    /// 交叉概率
    /// </summary>
    private double CrossoverProb = 0.8;


    /// <summary>
    /// 变异概率
    /// </summary>
    private double MutationProb = 0.1; // 变异概率

    /// <summary>
    /// 种群规模
    /// </summary>
    private int PopulationSize = 50; // 种群规模

    /// <summary>
    /// 最大迭代次数
    /// </summary>
    private int MaxIterations = 100; // 最大迭代次数

    /// <summary>
    /// 精英保留计数
    /// </summary>
    private int ElitismCount = 5;




    /// <summary>
    /// 全局选择占比
    /// </summary>
    private double GsRatio = 0.4; // 全局选择占比

    /// <summary>
    /// 局部选择占比
    /// </summary>
    private double LsRatio = 0.4; // 局部选择占比

    /// <summary>
    /// 随机选择占比
    /// </summary>
    private double RsRatio = 0.2; // 随机选择占比


}
