package com.aps.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 班次表
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-10-10
 */
@Getter
@Setter
@TableName("mes_shift_work_sched")
public class MesShiftWorkSched implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 编号
     */
    private String shiftWorkSchedCode;

    /**
     * 班次名称
     */
    private String shiftName;

    /**
     * 班次开始时间
     */
    private LocalDateTime shiftStart;

    /**
     * 班次结束时间
     */
    private LocalDateTime shiftEnd;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 工作时长
     */
    private Integer workingLong;

    /**
     * 班次id
     */
    private Integer shiftWorkSchedPk1;

    private LocalDateTime creationtime;

    private Integer creatoruserid;

    private LocalDateTime lastmodificationtime;

    private Integer lastmodifieruserid;

    private Integer isdeleted;

    private LocalDateTime deletiontime;

    private Integer deleteruserid;

    /**
     * 开始周几值
     */
    private Integer startWeekDay;

    /**
     * 开始周几名称
     */
    private String startWeekDayName;

    /**
     * 班次模板id
     */
    private Integer weekWorkSchedId;

    /**
     * 结束周几值
     */
    private Integer endWeekDay;

    /**
     * 结束周几名称
     */
    private String endWeekDayName;

    /**
     * (字符duration)working_long
     */
    private String strWorkingLong;
}