package com.aps.entity;

import lombok.Data;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@TableName("prod_process_exec")
public class ProdProcessExec {

    private String execId;
    private String sceneId;
    private String orderId;
    private Long routingDetailId;
    private Long taskSeq;
    private String routingDetailName;
    private Long machineId;
    private String resourceGroup;
    private Double planQty;
    private Double actualQty;
    private Long planDuration;
    private Long usedDuration;
    private Long remainDuration;
    private String processStatus;
    private Long standardCapacity;
    private Long minCapacity;
    private Long maxCapacity;
    private Long prepDuration;
    private Long changeDuration;
    private Long logicalOrder;
    private LocalDateTime targetStartDate;
    private LocalDateTime targetEndDate;

    /**
     * 工序准备工时（小时）
     * 注释: 工序准备工时
     */

    private BigDecimal setupTime;

    /**
     * 换线时间（小时）
     * 注释: 换线时间
     */

    private int changeLineTime;

    /**
     * 常数时间
     * 注释: 常数时间
     */

    private int constTime;

    /**
     * 前处理时间（秒）
     * 注释: 前处理时间（秒）
     */

    private int preprocessingTime;

    /**
     * 后处理时间（秒）
     * 注释: 后处理时间（秒）
     */

    private int postprocessingTime;

    //速度
    private Double speed;
    private String id;

    /**
     * 离散参数组ID
     * 离散参数ID
     */
    private  String groupId;
    private String groupName;
    private String parameterId;
    private String parameterName;

    /**
     * 连接属性
     */
    private Integer connectProperty;
    /**
     * 连接属性名称
     */
    private String connectPropertyName;

}