package com.aps.service.codeGeneratorService;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import com.aps.entity.codeGeneratorEntity.DatabaseConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;



@Service
public class CodeGeneratorService {

    /**
     * 生成代码
     * @param dbConfig 数据库配置
     * @param tables 表名列表
     * @param packageName 包名
     * @param author 作者
     */


    @Autowired
    private DatabaseService databaseService;


    /**
     * 获取数据库表列表
     */

    public void generateCode(DatabaseConfig dbConfig, List<String> tables,
                             String packageName, String author) {
        
        FastAutoGenerator.create(dbConfig.getUrl(), dbConfig.getUsername(), dbConfig.getPassword())
                .globalConfig(builder -> {
                    builder.author(author)
                           .outputDir(System.getProperty("user.dir") + "/src/main/java")
                           .disableOpenDir();
                })
                .packageConfig(builder -> {
                    builder.parent(packageName)
                           .entity("entity")
                           .mapper("mapper")
                           .service("service")
                           .serviceImpl("service.impl")
                           .controller("controller")
                           .pathInfo(Collections.singletonMap(OutputFile.xml, 
                                   System.getProperty("user.dir") + "/src/main/resources/mapper"));
                })
                .strategyConfig(builder -> {
                    builder.addInclude(tables)
                           .entityBuilder()
                           .naming(NamingStrategy.underline_to_camel)
                           .columnNaming(NamingStrategy.underline_to_camel)
                           .enableLombok()
                           .controllerBuilder()
                           .enableRestStyle()
                           .serviceBuilder()
                           .formatServiceFileName("%sService")
                           .mapperBuilder()
                           .enableBaseResultMap()
                           .enableBaseColumnList();
                })
                .templateEngine(new VelocityTemplateEngine())
//                .templateConfig(builder -> {
//                    builder.entity("/templates/entity.java.vm"); // 指向自定义模板
//                })
                .execute();
    }

    /**
     * 获取数据库中的所有表
     */
    public List<String> getTableList(DatabaseConfig dbConfig) {
        // 这里需要实现获取数据库表列表的逻辑
        // 可以使用JDBC元数据获取
        return databaseService.getTableList(dbConfig);
    }

    /**
     * 测试数据库连接
     */
    public boolean testConnection(DatabaseConfig dbConfig) {
        return databaseService.testConnection(dbConfig);
    }
}