package com.aps.entity.basic;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class MachineTimeline {
    private Long machineId;
    private CopyOnWriteArrayList<TimeSegment> segments;
    private LocalDateTime validFrom;
    private LocalDateTime validTo;
    private LocalDateTime lastUpdated;
    private int version = 1;
    
    public MachineTimeline() {
        this.segments = new CopyOnWriteArrayList<>();
    }
    
    // Getters and Setters
    public Long getMachineId() {
        return machineId;
    }
    
    public void setMachineId(Long machineId) {
        this.machineId = machineId;
    }
    
    public CopyOnWriteArrayList<TimeSegment> getSegments() {
        return segments;
    }
    
    public void setSegments(CopyOnWriteArrayList<TimeSegment> segments) {
        this.segments = segments;
    }
    
    public LocalDateTime getValidFrom() {
        return validFrom;
    }
    
    public void setValidFrom(LocalDateTime validFrom) {
        this.validFrom = validFrom;
    }
    
    public LocalDateTime getValidTo() {
        return validTo;
    }
    
    public void setValidTo(LocalDateTime validTo) {
        this.validTo = validTo;
    }
    
    public LocalDateTime getLastUpdated() {
        return lastUpdated;
    }
    
    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }
    
    public int getVersion() {
        return version;
    }
    
    public void setVersion(int version) {
        this.version = version;
    }
    
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MachineTimeline that = (MachineTimeline) o;
        return machineId == that.machineId;
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(machineId);
    }


    // 处理维护窗口


}