package com.aps.entity.basic;

import java.time.LocalDateTime;
import java.util.Objects;

public class MaintenanceWindow {

    private String id;

    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String reason;



    private String equipCode;
    private String equipName;
    public MaintenanceWindow() {}

    public MaintenanceWindow(LocalDateTime startTime, LocalDateTime endTime, String reason) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.reason = reason;
    }

    /**
     * 从Holiday对象构造MaintenanceWindow
     * @param holiday 假期对象
     */
    public MaintenanceWindow(Holiday holiday) {
        this(holiday.getStart(), holiday.getEnd(), "Holiday Period");
    }

    /**
     * 从Holiday对象构造MaintenanceWindow（可指定原因）
     * @param holiday 假期对象
     * @param reason 维护原因
     */
    public MaintenanceWindow(Holiday holiday, String reason) {
        this(holiday.getStart(), holiday.getEnd(), reason);
    }

    // Getters and Setters
    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEquipCode() {
        return equipCode;
    }

    public void setEquipCode(String equipCode) {
        this.equipCode = equipCode;
    }

    public String getEquipName() {
        return equipName;
    }

    public void setEquipName(String equipName) {
        this.equipName = equipName;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MaintenanceWindow that = (MaintenanceWindow) o;
        return Objects.equals(startTime, that.startTime) &&
                Objects.equals(endTime, that.endTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(startTime, endTime);
    }
}