package com.aps.entity.basic;

import com.aps.entity.Algorithm.OrderMaterialRequirement;
import lombok.Data;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * 订单定义
 */
@Data
public class Order {
    /**
     * 自增主键
     */
    private int id;
    
    /**
     * 订单ID
     */
    private String orderId;
    
    /**
     * 订单编码
     */
    private String orderCode;
    
    /**
     * 产品ID
     */
    private int productId;
    
    /**
     * 物料ID
     */
    private String materialId;
    
    /**
     * 物料编码
     */
    private String materialCode;
    
    /**
     * 物料名称
     */
    private String materialName;
    
    /**
     * 系列
     */
    private String serie;
    
    /**
     * 工艺路线ID
     */
    private Integer routingId;
    
    /**
     * 工艺路线编码
     */
    private String routingCode;
    
    /**
     * 订单数量，默认值：100
     */
    private double quantity = 100;
    
    /**
     * 生产数量
     */
    private double sYQuantity;
    
    /**
     * 开始日期
     */
    private LocalDateTime startDate;
    
    /**
     * 到期日期
     */
    private LocalDateTime dueDate;
    
    /**
     * 组开始日期
     */
    private LocalDateTime groupStartDate;
    
    /**
     * 组到期日期
     */
    private LocalDateTime groupDueDate;
    
    /**
     * 订单完成时间
     */
    private LocalDateTime orderCompletion;
    
    /**
     * 订单开始时间
     */
    private LocalDateTime orderStart;
    
    /**
     * 机器加工时间
     */
    private double machineProcessingTime;
    
    /**
     * 订单流程
     */
    private double orderFlow;
    
    /**
     * 订单生产时间
     */
    private double orderProductTime;
    
    /**
     * 延误时间
     */
    private double tardiness;
    
    /**
     * 优先级
     */
    private int priority;
    
    /**
     * 是否可拆分，默认值：false
     */
    private boolean canSplit = false;
    
    /**
     * 是否可中断，默认值：false
     */
    private boolean canInterrupt = false;
    
    /**
     * 实际优先级
     */
    private double actualPriority;
    
    /**
     * 主ID
     */
    private String mainId;
    
    /**
     * 使用这个半成品的成品工单
     */
    private List<Integer> FinishOrderId ;
    
    /**
     * 是否新创建，默认值：false
     */
    private boolean newCreate = false;
    
    /**
     * 是否创建BOM，默认值：false
     */
    private boolean createBom = false;
    
    /**
     * 关联的成品工序ID（核心：明确该半成品服务于哪个成品工序）
     */
    private List<Integer> TargetFinishedOperationId;
    
    /**
     * 延迟时间
     */
    private double delayHours;
    
    /**
     * 物料需求
     */
    private List<OrderMaterialRequirement> materialRequirementList;
}