package com.aps.service.impl;

import com.aps.entity.StrategyRule;
import com.aps.mapper.StrategyRuleMapper;
import com.aps.service.StrategyRuleService;
import com.aps.entity.StrategyScheduling;
import com.aps.common.util.EnhancedJsonConversionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 策略规则 服务实现类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-10
 */
@Service
public class StrategyRuleServiceImpl extends ServiceImpl<StrategyRuleMapper, StrategyRule> implements StrategyRuleService {
    
    /**
     * 根据策略规则ID获取其前向调度配置并转换为StrategyScheduling实体列表
     * 
     * @param ruleId 策略规则ID
     * @return StrategyScheduling实体列表
     */
    public List<StrategyScheduling> getForwardSchedulingByRuleId(Long ruleId) {
        // 从数据库查询StrategyRule
        StrategyRule strategyRule = this.getById(ruleId);
        
        if (strategyRule != null && strategyRule.getForwardScheduling() != null) {

            
            // 使用EnhancedJsonConversionUtil将JSON字符串转换为StrategyScheduling实体列表
            return EnhancedJsonConversionUtil.convertJsonToEntities(strategyRule.getForwardScheduling(), null, StrategyScheduling.class);
        }
        
        return null;
    }

}