package com.aps.demo;

import com.aps.ApsApplication;
import com.aps.entity.Algorithm.Chromosome;
import com.aps.service.plan.PlanResultService;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes = ApsApplication.class)
public class PlanResultServiceTest {

    @Autowired
    private PlanResultService planResultService;

    @Test
    public void testExecute2() {
        // 这里需要一个有效的SceneId来测试
        // 在实际测试中，您需要提供一个数据库中存在的SceneId
        String sceneId = "7E99857F64A44780AF06C326CAEE9682";
        
        try {
            Chromosome result = planResultService.execute2(sceneId);
            System.out.println("执行成功，结果：" + (result != null ? "获得染色体对象" : "空结果"));
            
            if (result != null) {
                System.out.println("适应度: " + result.getFitness());
                System.out.println("工序字符串: " + result.getOperationStr());
            }
        } catch (Exception e) {
            System.err.println("执行过程中发生异常: " + e.getMessage());
            e.printStackTrace();
        }
    }
}