package com.aps.entity.Algorithm;

import com.aps.entity.basic.MaterialType;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单物料需求
 */
@Data
public class OrderMaterialRequirement {

        private String orderId;
        private int operationId;
        private String childOrderId;
        private Long routingDetailId;
        private String materialId;
        private String materialCode;
        private String materialName;
        private String materialTypeName;

        /**
         * 物料类型
         */
        private Long materialType;

        /**
         * 需求总数
         */
        private double requiredQuantity;

        /**
         * 已配数量
         */
        private double ypQty;

        /**
         * 缺件数量
         */
        private double qjQty;

        /**
         * 占用库存
         */
        private double useStock;

        /**
         * 占用在途数量
         */
        private double useTransit;

        /**
         * 层级
         */
        @TableField(exist = false)
        private int level;

        /**
         * 预计到货时间
         */
        private LocalDateTime arrivalTime;

        /**
         * 预计可用时间
         */
        private LocalDateTime useTime;

        /**
         * 采购开始时间
         */
        private LocalDateTime purchaseStartTime;

        /**
         * 采购结束时间
         */
        private LocalDateTime purchaseEndTime;

        /**
         * 创建或使用的半成品订单ID
         */
        @TableField(exist = false)
        private List<Integer> productOrderID=new ArrayList<>();
        /**
         * 采购结束时间
         */
        private LocalDateTime shortageTime;
        /**
         * 检验周期
         */
        private Long checkLeadTime;
        @TableField(exist = false)
        private  List<OrderMaterialRequirement> replaceMaterial=new ArrayList<>();
}
