// DataSourceType.java
package com.aps.entity.common;

public enum DataSourceType {
    FILE("file"),     // 文件数据源（现有）
    DATABASE("db");   // 数据库数据源（新增）

    private String type;

    DataSourceType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static DataSourceType fromString(String type) {
        for (DataSourceType dataSource : DataSourceType.values()) {
            if (dataSource.getType().equalsIgnoreCase(type)) {
                return dataSource;
            }
        }
        return FILE; // 默认返回FILE
    }
}