package com.aps.common.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class FileHelper {
    private static final String LOG_FILE = "schedule_log.txt";
    private static final String LOG_FILE_PATH = "log/";

    public static void writeLogFile(String message) {
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))+"-";

        // 确保目录存在
        java.io.File logDir = new java.io.File(LOG_FILE_PATH);
        if (!logDir.exists()) {
            logDir.mkdirs(); // 创建目录（包括父目录）
        }

        String filePath = LOG_FILE_PATH + date + LOG_FILE;

        try (PrintWriter writer = new PrintWriter(new FileWriter(filePath, true))) {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            writer.println("[" + timestamp + "] " + message);
            System.out.println("[" + timestamp + "] " + message);

        } catch (IOException e) {
            System.err.println("Failed to write log: " + e.getMessage());
        }
    }
}