package com.aps.demo;


import com.aps.common.util.JsonFileReader;
import com.aps.entity.basic.ScheduleChromosome;
import com.aps.entity.basic.*;
import com.aps.service.plan.AlgorithmScheduler7;
import com.aps.service.plan.MachineSchedulerService;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

public class MachineSchedulerTest {
    
    public static void main(String[] args) {
        try {
//            // 1. 读取JSON文件
//            String jsonContent = new String(Files.readAllBytes(Paths.get("src/main/resources/machines.json")));
//            // 2. 配置ObjectMapper支持Java 8时间API
//            ObjectMapper objectMapper = new ObjectMapper();
//            objectMapper.registerModule(new JavaTimeModule());
//            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);

            List<Machine> machines = JsonFileReader.readListFromResources("machines.json", Machine.class);


            // 读取产品数据
            List<Product> products = JsonFileReader.readListFromResources("products.json", Product.class);

            // 读取订单数据
            List<Order> orders = JsonFileReader.readListFromResources("orders.json", Order.class);





            // 3. 反序列化JSON到Machine列表
//            List<Machine> machines = objectMapper.readValue(jsonContent,
//                objectMapper.getTypeFactory().constructCollectionType(List.class, Machine.class));
            
            // 4. 创建节假日数据
            List<Holiday> holidays = Arrays.asList(
                new Holiday(LocalDateTime.of(2025, 10, 1, 0, 0), 
                           LocalDateTime.of(2025, 10, 7, 23, 59))
            );
            
            // 5. 创建调度服务
            MachineSchedulerService machineScheduler = new MachineSchedulerService(
                holidays, LocalDateTime.of(2025, 10, 1, 0, 0, 0));
            
            // 6. 为每个设备生成时间线
            for (Machine machine : machines) {
                System.out.println("处理设备: " + machine.getName());
                MachineTimeline machineTimeline = machineScheduler.getOrCreateTimeline(machine);

                machine.setAvailability(machineTimeline.getSegments());
                
                // 打印结果
                System.out.println("设备 " + machine.getName() + " 的时间段数量: " + 
                    (machine.getAvailability() != null ? machine.getAvailability().size() : 0));
                
                if (machine.getAvailability() != null && !machine.getAvailability().isEmpty()) {
                    System.out.println("时间段:");
                    machine.getAvailability().stream().forEach(segment -> {
                        System.out.printf("  %s - %s (%s)%n", 
                            segment.getStart(), segment.getEnd(), segment.getType());
                    });
                }
                System.out.println("---");
            }
            
            // 7. 测试缓存功能
            System.out.println("缓存中的设备数量: " + MachineSchedulerService.getCacheSize());
            
            // 8. 测试特定设备的时间段生成
            if (!machines.isEmpty()) {
                Machine firstMachine = machines.get(0);
                List<TimeSegment> segments = machineScheduler.generateTimeSegment(
                    firstMachine, LocalDateTime.of(2025, 10, 1, 0, 0, 0),0);
                
                System.out.println("直接生成的时间段数量: " + segments.size());
            }


            AlgorithmScheduler7 scheduler = new AlgorithmScheduler7(products,machines,orders, machineScheduler);
            List<ScheduleChromosome> scheduleChromosomes = scheduler.RunAll();

            for (ScheduleChromosome run:scheduleChromosomes
                 ) {
                System.out.println("------------------"+run.getFitness()+"------------------");
                scheduler.PrintScheduleSummary(run);

            }

            ScheduleChromosome run = scheduler.Run();
            scheduler.PrintScheduleSummary(run);
            System.out.println(run.getFitness());
            System.out.println("------------------"+scheduleChromosomes.size()+"------------------");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}