package com.aps.service.Algorithm;

import com.aps.common.util.SnowFlackIdWorker;
import com.aps.entity.*;
import com.aps.entity.Algorithm.BOMBuildResult;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.OrderMaterialRequirement;
import com.aps.entity.basic.*;
import com.aps.mapper.RoutingHeaderMapper;
import com.aps.mapper.RoutingSupportingReplaceMapper;
import com.aps.mapper.RoutingsupportingMapper;
import com.aps.service.*;
import com.aps.service.impl.LanuchServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-12-08
 */
@Service
public class MaterialRequirementService {

    private List<Material> _materials;

    private List<Entry> _allOperations;

    private  List<GroupResult> _entryRel;

    private  List<RoutingHeader> headers;

    private  List<Routingsupporting> routingsupportings;

    private  List<RoutingSupportingReplace> routingsupportingreplaces;

    List<RoutingDetail> allRoutingDetails=new ArrayList<>();
    List<RoutingDetailEquip> allroutingDetailEquips=new ArrayList<>();
    List<RoutingDetailConnect> allroutingDetailconnections=new ArrayList<>();
    List<RoutingDiscreteParam> allroutingDiscreteParams=new ArrayList<>();

    @Autowired
    RoutingDetailConnectService routingDetailConnectService;


    private final List<Order> orders;

    @Autowired
    RoutingHeaderMapper routingHeaderMapper;

    @Autowired
    RoutingSupportingReplaceMapper routingSupportingReplaceMapper;

    @Autowired
    RoutingsupportingMapper routingsupportingMapper;

    @Autowired
    RoutingDataService _routingDataService;

    @Autowired
    private RoutingDiscreteParamService _routingDiscreteParamService;

    private  LocalDateTime baseTime ;

    public MaterialRequirementService(List<Material> materials,List<Order> _orders,List<Entry> allOperations,List<GroupResult> entryRel)
    {

        this.orders = _orders;
        _allOperations=allOperations;
        _materials=materials;
        _entryRel=entryRel;
    }

    /**
     * 构建多级BOM需求网络
     * @return 所有物料需求列表
     */
    private List<OrderMaterialRequirement> buildMultiLevelRequirementNetwork(LocalDateTime _baseTime) {
        baseTime=_baseTime;
        List<OrderMaterialRequirement> allRequirements = new ArrayList<>();
        List<Order> childorders = new ArrayList<>();

        List<Integer> routingIds = _allOperations.stream()
                .map(Entry::getRoutingId)
                .distinct()
                .collect(Collectors.toList());

        LambdaQueryWrapper<RoutingHeader> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(RoutingHeader::getId, routingIds)
                .eq(RoutingHeader::getIsDeleted, 0)
                .eq(RoutingHeader::getApprovalStatus, 1); // 添加 is_deleted=0 过滤条件
        headers = routingHeaderMapper.selectList(wrapper);

        LambdaQueryWrapper<Routingsupporting> routingsupportingwrapper = new LambdaQueryWrapper<>();
        routingsupportingwrapper.in(Routingsupporting::getRoutingHeaderId, routingIds)
                .eq(Routingsupporting::getIsdeleted, 0);

        routingsupportings = routingsupportingMapper.selectList(routingsupportingwrapper);

        LambdaQueryWrapper<RoutingSupportingReplace> routingsupportingreplacewrapper = new LambdaQueryWrapper<>();
        routingsupportingreplacewrapper.in(RoutingSupportingReplace::getStrsupid, routingIds)
                .eq(RoutingSupportingReplace::getIsdeleted, 0);

        routingsupportingreplaces = routingSupportingReplaceMapper.selectList(routingsupportingreplacewrapper);



        for (Order demand : orders) {
            // 跳过已有父订单的需求
            if (demand.getFinishOrderId() != null && !demand.getFinishOrderId().isEmpty()) {
                continue;
            }

            // 递归展开BOM层级（通过结果对象接收out参数数据）
            BOMBuildResult result = buildOrderBOM(demand.getRoutingId(),"", demand.getOrderId(), demand.getOrderId(),
                    demand.getQuantity(), 0);
            allRequirements.addAll(result.getMaterialRequirements());
            childorders.addAll(result.getChildOrders());
        }

        // 将子订单添加到全局订单列表
//        if (_orders != null) {
//            _orders.addAll(childorders);
//        }

        return allRequirements;
    }

    /**
     * 构建订单BOM
     * @param parent 父项ID
     * @param materialID 物料ID
     * @param mainorderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量（Java中用double替代decimal，若需高精度可用BigDecimal）
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public BOMBuildResult buildOrderBOM(int parent, String materialID, String mainorderId,
                                        String childorderId, double parentQuantity, int level) {

        RoutingHeader routingHeaders=  headers.stream()
                .filter(t->t.getId()==parent|| t.getMaterialId().equals(materialID))
                .findFirst()
                .orElse(null);
        List<RoutingHeader>  headers1;
        // 若未找到产品，返回空结果（根据业务可调整为抛出异常）
        if (routingHeaders==null) {


        }

        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> childorders2 = new ArrayList<>();

       // 遍历产品的工序，递归构建工序BOM

        List<Entry> Operations= _allOperations.stream()
                .filter(t->t.getOrderId()==childorderId)
                .collect(Collectors.toList());




         if (Operations != null) {
            for (Entry operation : Operations) {
                // 调用BuildOperationBOM方法（返回结果对象替代out参数）
                BOMBuildResult operationResult = buildOperationBOM(mainorderId, childorderId,
                        parentQuantity, operation, level);
//                // 合并物料需求和子订单
                materialRequirements.addAll(operationResult.getMaterialRequirements());
                childorders2.addAll(operationResult.getChildOrders());
            }
        }

       // return new BOMBuildResult(materialRequirements, childorders2);
        return  null;
    }

    private  void CreateChild(Order order,String materialID)
    {
        String sceneId="";
        LambdaQueryWrapper<RoutingHeader> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(RoutingHeader::getMaterialId, materialID)
                .eq(RoutingHeader::getIsDeleted, 0)
                .eq(RoutingHeader::getApprovalStatus, 1); // 添加 is_deleted=0 过滤条件
       RoutingHeader headers1 = routingHeaderMapper.selectOne(wrapper);
        if(headers==null)
        {
            return;
        }
        headers.add(headers1);

        Integer  routingIds =headers1.getId();

        LambdaQueryWrapper<Routingsupporting> routingsupportingwrapper = new LambdaQueryWrapper<>();
        routingsupportingwrapper.in(Routingsupporting::getRoutingHeaderId, routingIds)
                .eq(Routingsupporting::getIsdeleted, 0);

        List<Routingsupporting> routingsupportings1 = routingsupportingMapper.selectList(routingsupportingwrapper);
        routingsupportings.addAll(routingsupportings1);

        LambdaQueryWrapper<RoutingSupportingReplace> routingsupportingreplacewrapper = new LambdaQueryWrapper<>();
        routingsupportingreplacewrapper.in(RoutingSupportingReplace::getStrsupid, routingIds)
                .eq(RoutingSupportingReplace::getIsdeleted, 0);

        List<RoutingSupportingReplace> routingsupportingreplaces1 = routingSupportingReplaceMapper.selectList(routingsupportingreplacewrapper);

        routingsupportingreplaces.addAll(routingsupportingreplaces1);

        LanuchServiceImpl lanuchService=new LanuchServiceImpl();
        List<RoutingDetail> RoutingDetails= lanuchService.getRoutingDetails(routingIds);
        List<RoutingDetailEquip> routingDetailEquips = lanuchService.getRoutingDetailEquip(routingIds);

        ProdLaunchOrder prodOrderMain= convertToLaunchOrder(order,"");

        List<ProdProcessExec> processExecList = RoutingDetails.stream()
                .map(detail -> lanuchService.createProcessExec(prodOrderMain, detail, sceneId))
                .collect(Collectors.toList());

        List<ProdEquipment> ProdEquipmentList=  lanuchService.batchInsertEquipMent(routingDetailEquips, sceneId,processExecList,false);



        Map<Long, String> routingDetailIdToExecIdMap = processExecList.stream()
                .collect(Collectors.toMap(
                        ProdProcessExec::getRoutingDetailId,
                        ProdProcessExec::getExecId,
                        (existing, replacement) -> existing));

        LambdaQueryWrapper<RoutingDetailConnect> routingDetailConnectwrapper = new LambdaQueryWrapper<>();
        routingDetailConnectwrapper.eq(RoutingDetailConnect::getRoutingHeaderId, routingIds)
                .eq(RoutingDetailConnect::getIsdeleted, 0); // 添加 isdeleted=0 过滤条件

        List<RoutingDetailConnect> connections = routingDetailConnectService.list(routingDetailConnectwrapper);


        List<ProdOrderProcess>  ProdOrderProcesslist=  connections.stream()
                .map(connection -> lanuchService.createProcessRelation(prodOrderMain, connection, sceneId, routingDetailIdToExecIdMap))
                .collect(Collectors.toList());

        List<Long> routingDetailIds = RoutingDetails.stream()
                .map(RoutingDetail::getId)
                .distinct()
                .collect(Collectors.toList());

        List<RoutingDiscreteParam> routingDiscreteParams = _routingDiscreteParamService.lambdaQuery()
                .in(RoutingDiscreteParam::getRoutingDetailId, routingDetailIds)
                .eq(RoutingDiscreteParam::getIsDeleted, 0)
                .list();



        List<ProdLaunchOrder> ProdLaunchOrders=new ArrayList<>();
        ProdLaunchOrders.add(prodOrderMain);
        Map<Integer, Object> list=_routingDataService.CreateEntry( sceneId,  ProdEquipmentList,  ProdLaunchOrders, routingDiscreteParams, ProdOrderProcesslist, processExecList,_entryRel );



    }

    private ProdLaunchOrder convertToLaunchOrder(Order order, String sceneId) {
        try {
            ProdLaunchOrder launchOrder = new ProdLaunchOrder();
            launchOrder.setOrderId(order.getOrderId());
            launchOrder.setSceneId(sceneId);
            launchOrder.setSerie("");
            launchOrder.setCreateUser("GA");
            launchOrder.setMaterialCode("");
//            launchOrder.setStartDate(order.get);
            launchOrder.setEndDate(order.getDueDate());
//            launchOrder.setOrderPriority(order.getPrioritry());
            launchOrder.setOrderPriority(order.getPriority());
            launchOrder.setQuantity(order.getQuantity());
            launchOrder.setMaterialId(order.getMaterialId());


            launchOrder.setRoutingId(order.getRoutingId());
            launchOrder.setRoutingCode("");


            return launchOrder;
        } catch (Exception e) {

            return null;
        }
    }



    /**
     * 构建工序BOM需求
     * @param orderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量
     * @param operation 工序对象
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public BOMBuildResult buildOperationBOM(String orderId, String childorderId, double parentQuantity,
                                            Entry operation, int level) {
        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> _childorders = new ArrayList<>();

        List<Routingsupporting> MaterialRequirements=  routingsupportings.stream()
                .filter(t->t.getRoutingDetailId()==operation.getRoutingDetailId())
                .collect(Collectors.toList());

        if (MaterialRequirements != null) {
            for (Routingsupporting component : MaterialRequirements) {
                OrderMaterialRequirement orderMaterial = new OrderMaterialRequirement();
                materialRequirements.add(orderMaterial);

                orderMaterial.setOrderId(orderId);
                orderMaterial.setOperationId(operation.getId());
                orderMaterial.setChildorderId(StringUtils.isBlank(childorderId) ? orderId : childorderId);

                double allneeded = parentQuantity * component.getMainQty().doubleValue();
                orderMaterial.setRequiredQuantity(allneeded);
                double needed = allneeded;

                // 查找物料（流式处理替代First）
                Material material = _materials.stream()
                        .filter(m -> m.getId().equals(component.getMaterialId()))
                        .findFirst()
                        .orElse(null);
                if (material == null) {
                    continue;
                }

                orderMaterial.setMaterialType(material.getMaterialType());
                orderMaterial.setMaterialId(material.getId());

                // 扣减现有库存
                double availableNow = material.getCurrentStock();
                double useStock = Math.min(needed, availableNow);
                material.setCurrentStock(material.getCurrentStock() - useStock);
                orderMaterial.setUseStock(useStock);
                needed -= useStock;

                if (needed <= 0) {
                    continue;
                }

                // 处理在途物料
                double accumulated = 0;
                LocalDateTime earliestTime = null;
                double useTransit = 0;

                // 按到货时间排序在途物料
                List<MaterialSupply> sortedInTransit = material.getInTransit().stream()
                        .filter(t -> t.getQuantity() > 0)
                        .sorted(Comparator.comparing(MaterialSupply::getArrivalTime))
                        .collect(Collectors.toList());

                for (MaterialSupply supply : sortedInTransit) {
                    double useq = Math.min(needed, supply.getQuantity());
                    useTransit += useq;
                    needed -= useq;
                    supply.setQuantity(supply.getQuantity() - useq);

                    if (needed <= 0) {
                        earliestTime = supply.getArrivalTime();
                        break;
                    }
                }

                orderMaterial.setUseTransit(useTransit);
                orderMaterial.setArrivalTime(earliestTime);
                orderMaterial.setLevel(level);

                if (needed > 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);

                    if (material.getMaterialType() == MaterialType.RawMaterial) {
                        // 处理原材料采购时间
                        orderMaterial.setPurchaseStartTime(baseTime);
                        // 采购结束时间 = 采购开始时间 + 采购提前期（天）
                        LocalDateTime purchaseEndTime = baseTime.plusDays(material.getPurchaseLeadTime());
                        orderMaterial.setPurchaseEndTime(purchaseEndTime);
                    } else {
                        // 处理半成品/成品的现有订单


                        List<Order> orders2 = orders.stream()
                                .filter(t -> t.getMaterialId().equals(material.getId())  && t.getSYQuantity() > 0)
                                .sorted(Comparator.comparing(Order::getDueDate))
                                .collect(Collectors.toList());

                        if (!orders2.isEmpty()) {
                            for (Order order : orders2) {
                                if (order.getFinishOrderId() == null) {
                                    order.setFinishOrderId(new ArrayList<>());
                                }
                                order.getFinishOrderId().add(orderId);
                                orderMaterial.getProductOrderID().add(order.getOrderId());

                                double useq = Math.min(needed, order.getSYQuantity());
                                needed -= useq;
                                order.setSYQuantity(order.getSYQuantity() - useq);

                                if (order.getFinishOrderId().size() == 1) {
                                    // 递归构建BOM
                                    int l = level + 1;
                                    BOMBuildResult childResult = buildOrderBOM(0, material.getId(),
                                            orderId, order.getOrderId(),
                                            order.getQuantity(), l);
                                    materialRequirements.addAll(childResult.getMaterialRequirements());
                                    _childorders.addAll(childResult.getChildOrders());
                                    operation.getDependentOnOrderIds().add(order.getOrderId());
                                }

                                if (needed <= 0) {
                                    break;
                                }
                            }
                        }

                        // 更新已配和缺件数量
                        orderMaterial.setYpQty(allneeded - needed);
                        orderMaterial.setQjQty(needed);

                        if (needed > 0) {
                            // 创建新的子订单
                            Order childorder = new Order();
                            String OrderId = UUID.randomUUID().toString().replace("-", "");

                            childorder.setOrderId(OrderId);
                            childorder.setMaterialId(material.getId());
                            childorder.setQuantity((int) orderMaterial.getQjQty());
                            childorder.setFinishOrderId(new ArrayList<>());
                            childorder.getFinishOrderId().add(orderId);
                            _childorders.add(childorder);
                            CreateChild(childorder,material.getId());
                            orderMaterial.getProductOrderID().add(OrderId);
                            operation.getDependentOnOrderIds().add(OrderId);
                            // 递归构建BOM
                            int l = level + 1;
                            BOMBuildResult childResult = buildOrderBOM(0, material.getId(),
                                    orderId, childorder.getOrderId(),
                                    childorder.getQuantity(), l);
                            materialRequirements.addAll(childResult.getMaterialRequirements());
                            _childorders.addAll(childResult.getChildOrders());
                        }
                    }
                }

                // 计算预计可用时间
                LocalDateTime arrivalTime = orderMaterial.getArrivalTime();
                LocalDateTime purchaseEndTime = orderMaterial.getPurchaseEndTime();
                LocalDateTime useTime = null;

                if (arrivalTime == null) {
                    useTime = purchaseEndTime;
                } else {
                    if (purchaseEndTime != null && purchaseEndTime.isAfter(arrivalTime)) {
                        useTime = purchaseEndTime;
                    } else {
                        useTime = arrivalTime;
                    }
                }
                orderMaterial.setUseTime(useTime);
            }
        }

        return new BOMBuildResult(materialRequirements, _childorders);
    }
}
