package com.aps.common.util;

import com.aps.entity.Algorithm.DateRange;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：佟礼
 * 时间：2025-12-26
 */
public class RangeSubtractUtil {

    // 主方法：返回数组1与数组2无交集的区间列表
    public static List<DateRange> getNonOverlappingRanges(List<DateRange> list1, List<DateRange> list2) {
        List<DateRange> result = new ArrayList<>(list1); // 先复制数组1的所有区间

        // 遍历数组2的每个区间，依次切割结果中的区间
        for (DateRange target : list2) {
            List<DateRange> temp = new ArrayList<>();
            for (DateRange current : result) {
                // 切割当前区间，排除与target重叠的部分
                temp.addAll(current.subtract(target));
            }
            result = temp; // 更新结果为切割后的区间
        }

        // 过滤无效区间（start > end的情况）
        result.removeIf(range -> !range.isValid());
        return result;
    }

    // 测试示例
    public static void test() {
        // 构造数组1
        List<DateRange> list1 = new ArrayList<>();
        list1.add(new DateRange("2025/10/01 00:00:00", "2025/10/08 23:59:59"));
        list1.add(new DateRange("2025/11/01 00:00:00", "2025/11/03 23:59:59"));

        // 构造数组2
        List<DateRange> list2 = new ArrayList<>();
        list2.add(new DateRange("2025/10/03 00:00:00", "2025/10/03 23:59:59"));
        list2.add(new DateRange("2025/10/06 00:00:00", "2025/10/07 23:59:59"));

        // 计算无交集区间
        List<DateRange> nonOverlapping = getNonOverlappingRanges(list1, list2);

        // 输出结果（与题目示例一致）
        System.out.println("无交集区间：");
        nonOverlapping.forEach(range ->
                System.out.println(DateTimeUtil.format(range.getStartDate(),"yyyy/MM/dd")
                        + " ~ " + DateTimeUtil.format(range.getEndDate(),"yyyy/MM/dd"))
        );
    }
}
