package com.aps.service.impl;

import com.aps.entity.DiscreteParameterDuration;
import com.aps.entity.DiscreteParameterMatrix;
import com.aps.entity.RoutingDiscreteParam;
import com.aps.mapper.DiscreteParameterDurationMapper;
import com.aps.service.DiscreteParameterDurationService;
import com.aps.service.RoutingDiscreteParamService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-05
 */
@Service
public class DiscreteParameterDurationServiceImpl extends ServiceImpl<DiscreteParameterDurationMapper, DiscreteParameterDuration> implements DiscreteParameterDurationService {
    @Autowired
    private RoutingDiscreteParamService _routingDiscreteParamService;
    @Override
    public double getDiscreteParameterMatrixValue(Long fistDetail, Long secondDetail) {


        List<RoutingDiscreteParam> firstParams = getRoutingParams(fistDetail);
        List<RoutingDiscreteParam> secondParams = getRoutingParams(secondDetail);

        findMatchingParams(firstParams, secondParams);






        return 0;
    }

    private List<RoutingDiscreteParam> findMatchingParams(
            List<RoutingDiscreteParam> firstParams,
            List<RoutingDiscreteParam> secondParams) {

        Set<String> secondGroupIds = secondParams.stream()
                .map(RoutingDiscreteParam::getGroupId)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());

        return firstParams.stream()
                .filter(param -> param.getGroupId() != null && secondGroupIds.contains(param.getGroupId()))
                .collect(Collectors.toList());
    }

    private List<RoutingDiscreteParam> getRoutingParams(Long detailId) {
        return _routingDiscreteParamService.lambdaQuery()
                .eq(RoutingDiscreteParam::getRoutingDetailId, detailId)
                .eq(RoutingDiscreteParam::getIsDeleted, 0)
                .list();
    }



    private double findMaxChangeOverTime(List<RoutingDiscreteParam> matchingParams,
                                         List<RoutingDiscreteParam> secondParams) {

        Set<String> groupIds = matchingParams.stream()
                .map(RoutingDiscreteParam::getGroupId)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());

        if (groupIds.isEmpty()) {
            return 0.0;
        }

        // 获取矩阵数据
        List<DiscreteParameterDuration> matrixData = getMatrixData(groupIds);

//        // 按优先级查找匹配的矩阵记录
//        List<DiscreteParameterMatrix> matchedMatrix = findMatchedMatrixByPriority(
//                matchingParams, secondParams, matrixData);

        return 0.0;
    }

    private List<DiscreteParameterDuration> getMatrixData(Set<String> groupIds) {
        // 直接使用this调用，避免循环依赖
        return this.lambdaQuery()
                .in(DiscreteParameterDuration::getGroupid, groupIds)
                .eq(DiscreteParameterDuration::getIsdeleted, 0)
                .list();
    }




}
