package com.aps.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 物料主数据表
 * </p>
 *
 * @author yourName
 * @since 2025-09-25
 */
@Getter
@Setter
@TableName("material_info")
public class MaterialInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId("id")
    private String id;

    @TableField("creationtime")
    private LocalDateTime creationtime;

    @TableField("creatoruserid")
    private Long creatoruserid;

    @TableField("lastmodificationtime")
    private LocalDateTime lastmodificationtime;

    @TableField("lastmodifieruserid")
    private Long lastmodifieruserid;

    @TableField("isdeleted")
    private Long isdeleted;

    @TableField("deletiontime")
    private LocalDateTime deletiontime;

    @TableField("deleteruserid")
    private Long deleteruserid;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    @TableField("brand")
    private String brand;

    /**
     * 规格
     */
    @TableField("specifications")
    private String specifications;

    @TableField("batch")
    private String batch;

    @TableField("unit_price")
    private BigDecimal unitPrice;

    @TableField("min_num")
    private BigDecimal minNum;

    @TableField("tempcode")
    private String tempcode;

    /**
     * 编码
     */
    @TableField("code")
    private String code;

    @TableField("material_type_name")
    private String materialTypeName;

    @TableField("inspect_duration")
    private Long inspectDuration;

    @TableField("purchase_duration")
    private int purchaseDuration;

    @TableField("first_lot")
    private String firstLot;

    @TableField("tail_lot")
    private BigDecimal tailLot;

    @TableField("standard_log")
    private BigDecimal standardLog;

    @TableField("safe_stock_day")
    private Long safeStockDay;

    @TableField("safe_stock_quantity")
    private BigDecimal safeStockQuantity;

    /**
     * 类别名称
     */
    @TableField("category_name")
    private String categoryName;

    /**
     * 类别编码
     */
    @TableField("category_code")
    private String categoryCode;

    /**
     * 类别ID
     */
    @TableField("category_id")
    private Long categoryId;

    @TableField("material_property")
    private Long materialProperty;

    @TableField("root_category_id")
    private Long rootCategoryId;

    @TableField("code_rule_id")
    private Long codeRuleId;

    @TableField("code_rule_type")
    private Long codeRuleType;

    /**
     * 编码
     */
    @TableField("drawing")
    private String drawing;

    @TableField("material_type")
    private Long materialType;

    /**
     * 单位
     */
    @TableField("measure_unit")
    private Long measureUnit;

    /**
     * 单位名称
     */
    @TableField("measure_unit_name")
    private String measureUnitName;

    /**
     * 版本
     */
    @TableField("version")
    private String version;

    /**
     * 产品类型
     */
    @TableField("product_type")
    private String productType;

    @TableField("status")
    private Long status;

    @TableField("latest")
    private Long latest;

    /**
     * 是否创建原材料供应供应?
     */
    @TableField("iscreatesupplyrouting")
    private Long iscreatesupplyrouting;

    /**
     * 是否创建原材料检验供应?
     */
    @TableField("iscreatecheckrouting")
    private Long iscreatecheckrouting;

    @TableField("description")
    private String description;

    /**
     * 物料类型
     */
    @TableField("quintiq_ortems")
    private Long quintiqOrtems;

    @TableField("isync")
    private Long isync;

    @TableField("issend")
    private Long issend;

    /**
     * 辅助计量单位
     */
    @TableField("measure_unit2")
    private Long measureUnit2;

    @TableField("measure_unit_name2")
    private String measureUnitName2;

    @TableField("linkmaterialid")
    private String linkmaterialid;

    /**
     * 辅助计量单位2
     */
    @TableField("measure_unit3")
    private Long measureUnit3;

    @TableField("measure_unit_name3")
    private String measureUnitName3;

    @TableField("zjltofjl1")
    private BigDecimal zjltofjl1;

    /**
     * 供应商ID
     */
    @TableField("supply_id")
    private String supplyId;

    /**
     * 供应商名称
     */
    @TableField("supply_name")
    private String supplyName;

    /**
     * 供应商编码
     */
    @TableField("supply_code")
    private String supplyCode;

    @TableField("istrade")
    private Long istrade;

    @TableField("ser")
    private String ser;

    /**
     * 是否共用?
     */
    @TableField("iscommon")
    private Long iscommon;

    /**
     * 是否创建汇总供应?
     */
    @TableField("iscreatepoolrouting")
    private Long iscreatepoolrouting;

    /**
     * 特殊产品，普通产品
     */
    @TableField("variety")
    private String variety;

    /**
     * 规格
     */
    @TableField("spec")
    private String spec;

    /**
     * MP类别
     */
    @TableField("category_id2")
    private Long categoryId2;

    @TableField("utility_material")
    private Long utilityMaterial;

    /**
     * 特殊产品
     */
    @TableField("special_product")
    private Long specialProduct;

    /**
     * 瓶型
     */
    @TableField("bottle_type")
    private Long bottleType;

    @TableField("bottle_type_str")
    private String bottleTypeStr;

    /**
     * 最大库存目标
     */
    @TableField("max_inventory_day")
    private BigDecimal maxInventoryDay;

    /**
     * 最大库存目标
     */
    @TableField("max_inventory_quantity")
    private BigDecimal maxInventoryQuantity;

    /**
     * 最小库存目标
     */
    @TableField("min_inventory_day")
    private BigDecimal minInventoryDay;

    /**
     * 最小库存目标
     */
    @TableField("min_inventory_quantity")
    private BigDecimal minInventoryQuantity;

    /**
     * 最小供应量
     */
    @TableField("minimum_supply")
    private BigDecimal minimumSupply;

    /**
     * 开始时间
     */
    @TableField("start_time")
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @TableField("end_time")
    private LocalDateTime endTime;

    /**
     * 产线设备
     */
    @TableField("equip_id")
    private Long equipId;

    /**
     * 大宗产品 1==是
     */
    @TableField("bigpro")
    private Long bigpro;

    /**
     * 小宗产品 1==是
     */
    @TableField("smallpro")
    private Long smallpro;

    /**
     * 周三后排?
     */
    @TableField("isthree")
    private Long isthree;

    /**
     * 是否负库存
     */
    @TableField("is_minus")
    private Long isMinus;

    @TableField("remark")
    private String remark;

    /**
     * 搭配大宗产品
     */
    @TableField("match_bigpro_id")
    private String matchBigproId;

    /**
     * 搭配大宗产品
     */
    @TableField("match_bigpro_code")
    private String matchBigproCode;

    /**
     * 搭配小宗产品
     */
    @TableField("match_smallpro_id")
    private String matchSmallproId;

    /**
     * 搭配小宗产品
     */
    @TableField("match_smallpro_code")
    private String matchSmallproCode;

    /**
     * 全称
     */
    @TableField("full_name")
    private String fullName;

    /**
     * 是否包含库存，默认是，0否
     */
    @TableField("is_include_store")
    private Long isIncludeStore;

    /**
     * 是否平分到未来四周，默认0否，1是
     */
    @TableField("is_average_four_week")
    private Long isAverageFourWeek;

    /**
     * 库存同步时间
     */
    @TableField("stocksynctime")
    private LocalDateTime stocksynctime;

    @TableField("inventory_host_cost")
    private Long inventoryHostCost;

    /**
     * 拆分前计划ID
     */
    @TableField("beforeplanid")
    private String beforeplanid;

    /**
     * 计划顺序号
     */
    @TableField("plannum")
    private Long plannum;

    /**
     * 计划总数
     */
    @TableField("plancount")
    private Long plancount;

    /**
     * 集成过来的主键；
     */
    @TableField("new_long_id")
    private Long newLongId;

    /**
     * 集成过来的旧物料编码
     */
    @TableField("new_oldnumber")
    private String newOldnumber;

    /**
     * 集成过来的最小起订量
     */
    @TableField("min_quantity")
    private BigDecimal minQuantity;

    /**
     * 0 其他1 外贸 2 研发 3 试料 4西南 5追加
     */
    @TableField("material_plan_type")
    private Long materialPlanType;

    /**
     * 最小生产量
     */
    @TableField("min_production")
    private BigDecimal minProduction;

    /**
     * 最大生产量
     */
    @TableField("max_production")
    private BigDecimal maxProduction;

    /**
     * 不可见性（外贸删除的物料）
     */
    @TableField("invisable")
    private Long invisable;
}