package com.aps.entity;

/**
 * 离散参数配置类型枚举
 * 对应关系：
 * 工作数量 -> 2
 * 绝对持续时间 -> 0
 * 工作持续时间 -> 1
 * 工作数 -> 3
 * 工作间隔最大间隔时间 -> 4
 */
public enum DiscreteParameterConfigType {
    
    /**
     * 绝对持续时间
     */
    ABSOLUTE_DURATION(0, "AbsoluteDuration", "绝对持续时间"),
    
    /**
     * 工作持续时间
     */
    WORKING_DURATION(1, "WorkingDuration", "工作持续时间"),
    
    /**
     * 工作数量（累计数量）
     */
    WORKING_QUANTITY(2, "AccumulatedQuantity", "工作数量"),
    
    /**
     * 工作数
     */
    ORDER_COUNT(3, "OrderCount", "工作数"),
    
    /**
     * 工作间隔最大间隔时间
     */
    MAX_INTERVAL(4, "MaxInterval", "工作间隔最大间隔时间");
    

    

    
    private final int value;
    private final String configType;
    private final String description;
    
    DiscreteParameterConfigType(int value, String configType, String description) {
        this.value = value;
        this.configType = configType;
        this.description = description;
    }
    
    /**
     * 根据数值获取枚举值
     */
    public static DiscreteParameterConfigType getByValue(int value) {
        for (DiscreteParameterConfigType type : values()) {
            if (type.getValue() == value) {
                return type;
            }
        }
        return null;
    }
    
    /**
     * 根据配置类型字符串获取枚举值
     */
    public static DiscreteParameterConfigType getByConfigType(String configType) {
        for (DiscreteParameterConfigType type : values()) {
            if (type.getConfigType().equals(configType)) {
                return type;
            }
        }
        return null;
    }
    
    public int getValue() {
        return value;
    }
    
    public String getConfigType() {
        return configType;
    }
    
    public String getDescription() {
        return description;
    }
}