package com.aps.service;

import com.aps.common.util.R;
import com.aps.entity.*;

import java.util.List;
import java.util.Map;

/**
 * 设备日历服务接口
 */
public interface LanuchService {
    
    /**
     * 生成设备日历数据
     *
     * @author: jdt
     * @return 结果
     */
    R<String> lanuch( String sceneId, String username);

    /**
     * 生成设备日历数据
     *
     * @author: jdt
     * @return 结果
     */
    R<String> copyScene( String oldSceneId, String username,String newSceneId);


    /**
     * 下发场景数据到mes_order
     */

    R<String> exportPlan( String sceneId);

     List<RoutingDetail> getRoutingDetails(Integer routingHeaderId);

    List<RoutingDetailEquip> getRoutingDetailEquip(Integer routingHeaderId, String routingCode);

    ProdProcessExec createProcessExec(ProdLaunchOrder prodOrderMain,
                                      RoutingDetail detail,
                                      String sceneId);

    List<ProdEquipment> batchInsertEquipMent(
            List<RoutingDetailEquip> routingDetailEquips,
            String sceneId,List<ProdProcessExec> processExecList,Boolean isSave);

    List<ProdOrderProcess> createProcessRelations(ProdLaunchOrder prodOrderMain, String sceneId, Map<Long, String> routingDetailIdToExecIdMap);

    ProdOrderProcess createProcessRelation(ProdLaunchOrder prodOrderMain,
                                           RoutingDetailConnect connection,
                                           String sceneId,
                                           Map<Long, String> routingDetailIdToExecIdMap);

}