package com.aps.service.impl;

import com.aps.entity.DiscreteParameterMatrix;
import com.aps.entity.RoutingDiscreteParam;
import com.aps.entity.basic.Entry;
import com.aps.mapper.DiscreteParameterMatrixMapper;
import com.aps.service.DiscreteParameterMatrixService;
import com.aps.service.RoutingDiscreteParamService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-03
 */
@Service
public class DiscreteParameterMatrixServiceImpl extends ServiceImpl<DiscreteParameterMatrixMapper, DiscreteParameterMatrix> implements DiscreteParameterMatrixService {
    @Autowired
    private RoutingDiscreteParamService _routingDiscreteParamService;
    
    @Override
    public double getDiscreteParameterMatrixValue(Entry entry, Entry lastEntry) {
        // 1. 参数验证
        if (entry == null || lastEntry == null) {
            return 0.0;
        }

        // 2. 获取基础数据
        List<RoutingDiscreteParam> firstParams = lastEntry.getDiscreteParameter();
        List<RoutingDiscreteParam> secondParams = entry.getDiscreteParameter();
        
        // 检查参数列表是否为null
        if (firstParams == null || secondParams == null) {
            return 0.0;
        }

        if (firstParams.isEmpty() || secondParams.isEmpty()) {
            return 0.0;
        }

        // 3. 查找匹配的参数
        List<RoutingDiscreteParam> matchingParams = findMatchingParams(firstParams, secondParams);
        if (matchingParams.isEmpty()) {
            return 0.0;
        }
        long firstEquipId = lastEntry.getSelectMachineID() != null ? lastEntry.getSelectMachineID() : 0L;
        long secondEquipId = entry.getSelectMachineID() != null ? entry.getSelectMachineID() : 0L;
        long firstEquipTypeId = lastEntry.getEquipTypeID() != null ? lastEntry.getEquipTypeID() : 0L;
        long secondEquipTypeId = entry.getSelectMachineID() != null ? entry.getSelectMachineID() : 0L;

        if (firstEquipId == 0 || secondEquipId == 0 || firstEquipTypeId == 0 || secondEquipTypeId == 0) {

            return  0.0;

        }



        // 4. 获取矩阵数据并计算最大时长
        return findMaxChangeOverTime(matchingParams, secondParams,firstEquipId,secondEquipId,firstEquipTypeId,secondEquipTypeId);
    }



    /**
     * 获取路由参数列表
     */
    private List<RoutingDiscreteParam> getRoutingParams(Long detailId) {
        return _routingDiscreteParamService.lambdaQuery()
                .eq(RoutingDiscreteParam::getRoutingDetailId, detailId)
                .eq(RoutingDiscreteParam::getIsDeleted, 0)
                .list();
    }

    /**
     * 查找匹配的参数（first中groupId在second中也存在的参数）
     */
    private List<RoutingDiscreteParam> findMatchingParams(
            List<RoutingDiscreteParam> firstParams,
            List<RoutingDiscreteParam> secondParams) {

        Set<String> secondGroupIds = secondParams.stream()
                .map(RoutingDiscreteParam::getGroupId)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());

        return firstParams.stream()
                .filter(param -> param.getGroupId() != null && secondGroupIds.contains(param.getGroupId()))
                .collect(Collectors.toList());
    }

    /**
     * 查找最大换型时间
     */
    private double findMaxChangeOverTime(List<RoutingDiscreteParam> matchingParams,
                                         List<RoutingDiscreteParam> secondParams,long firstEquipId, long secondEquipId, long firstEquipTypeId, long secondEquipTypeId) {

        Set<String> groupIds = matchingParams.stream()
                .map(RoutingDiscreteParam::getGroupId)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());

        if (groupIds.isEmpty()) {
            return 0.0;
        }

        // 获取矩阵数据
        List<DiscreteParameterMatrix> matrixData = getMatrixData(groupIds);

        // 按优先级查找匹配的矩阵记录
        List<DiscreteParameterMatrix> matchedMatrix = findMatchedMatrixByPriority(
                matchingParams, secondParams, matrixData,firstEquipId,secondEquipId,firstEquipTypeId,secondEquipTypeId);

        return getMaxDuration(matchedMatrix);
    }

    /**
     * 获取矩阵数据
     */
    private List<DiscreteParameterMatrix> getMatrixData(Set<String> groupIds) {
        // 直接使用this调用，避免循环依赖
        return this.lambdaQuery()
                .in(DiscreteParameterMatrix::getGroupid, groupIds)
                .eq(DiscreteParameterMatrix::getIsdeleted, 0)
                .list();
    }

    /**
     * 按优先级查找匹配的矩阵记录
     */
    private List<DiscreteParameterMatrix> findMatchedMatrixByPriority(
            List<RoutingDiscreteParam> matchingParams,
            List<RoutingDiscreteParam> secondParams,
            List<DiscreteParameterMatrix> matrixData,long firstEquipId, long secondEquipId, long firstEquipTypeId, long secondEquipTypeId) {

        // 优先级1: 设备级别匹配 (isEquip=1, isEquipType=0, isGlobal=0)
        List<DiscreteParameterMatrix> result = findMatrixMatches(
                matchingParams, secondParams, matrixData, 1, 0, 0,firstEquipId,secondEquipId,firstEquipTypeId,secondEquipTypeId);

        if (!result.isEmpty()) {
            return result;
        }

        // 优先级2: 设备类型级别匹配 (isEquip=0, isEquipType=1, isGlobal=0)
        result = findMatrixMatches(matchingParams, secondParams, matrixData, 0, 1, 0,firstEquipId,secondEquipId,firstEquipTypeId,secondEquipTypeId);

        if (!result.isEmpty()) {
            return result;
        }

        // 优先级3: 全局级别匹配 (isEquip=0, isEquipType=0, isGlobal=1)
        return findMatrixMatches(matchingParams, secondParams, matrixData, 0, 0, 1,firstEquipId,secondEquipId,firstEquipTypeId,secondEquipTypeId);
    }

    /**
     * 查找矩阵匹配记录
     */
    private List<DiscreteParameterMatrix> findMatrixMatches(
            List<RoutingDiscreteParam> matchingParams,
            List<RoutingDiscreteParam> secondParams,
            List<DiscreteParameterMatrix> matrixData,
            int isEquip, int isEquipType, int isGlobal,long firstEquipId, long secondEquipId, long firstEquipTypeId, long secondEquipTypeId) {

        return matchingParams.stream()
                .flatMap(firstParam -> secondParams.stream()
                        .flatMap(secondParam -> matrixData.stream()
                                .filter(matrix -> isMatrixMatch(matrix, firstParam, secondParam, isEquip, isEquipType, isGlobal,firstEquipId,secondEquipId,firstEquipTypeId,secondEquipTypeId))
                        )
                )
                .collect(Collectors.toList());
    }

    /**
     * 检查矩阵是否匹配
     */
    /**
     * 检查矩阵是否匹配（最简修正）
     */
    private boolean isMatrixMatch(DiscreteParameterMatrix matrix,
                                  RoutingDiscreteParam firstParam,
                                  RoutingDiscreteParam secondParam,
                                  int requiredEquip, int requiredEquipType, int requiredGlobal,long firstEquipId, long secondEquipId, long firstEquipTypeId, long secondEquipTypeId)    {

        // 1. 先检查参数ID匹配
        if (!Objects.equals(matrix.getFirstparameterid(), firstParam.getParameterId()) ||
                !Objects.equals(matrix.getSecondparameterid(), secondParam.getParameterId())) {
            return false;
        }

        // 2. 按优先级检查：处理null值，null视为0
        if (requiredEquip == 1) {
            return ((matrix.getIsequip() != null ? matrix.getIsequip() : 0) == 1) &&
                    Objects.equals(matrix.getEquipid(), firstEquipId) &&
                    Objects.equals(matrix.getEquipid(), secondEquipId) &&
                    firstEquipId == secondEquipId; // 确保前后工序使用同一设备
        }

        if (requiredEquipType == 1) {
            return ((matrix.getIsequiptype() != null ? matrix.getIsequiptype() : 0) == 1) &&
                    Objects.equals(matrix.getEquiptypeid(), firstEquipTypeId) &&
                    Objects.equals(matrix.getEquiptypeid(), secondEquipTypeId) &&
                    firstEquipTypeId == secondEquipTypeId; // 确保前后工序使用同类型设备

        }

        if (requiredGlobal == 1) {
            return (matrix.getIsglobal() != null ? matrix.getIsglobal() : 0) == 1;
        }


        return false;
    }
    /**
     * 获取最大时长
     */
    private double getMaxDuration(List<DiscreteParameterMatrix> matrixList) {
        return matrixList.stream()
                .filter(matrix ->  matrix.getDuration() > 0)
                .map(DiscreteParameterMatrix::getDuration)  // 保持Double类型
                .max(Double::compareTo)  // 使用Double的比较器
                .orElse(0.0);
    }

















}