package com.aps.entity.basic;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * 时间段（设备的时间片段，标记可用/不可用状态）
 */
@Data
public class TimeSegment {
    private String key = UUID.randomUUID().toString();           // 时间段唯一标识（如"Machine-1_20251008_1000"）
    private LocalDateTime start;  // 时间段开始时间
    private LocalDateTime end;    // 时间段结束时间
    private int earliestTime;     // 该时段内最早可用时间（分钟）
    private int totalTaskTime;    // 该时段内已分配任务时间（分钟）
    private SegmentType type;     // 时间段类型（关联SegmentType枚举）
    private boolean isHoliday;    // 是否节假日（true=节假日）
    private boolean isUsed;       // 是否已被占用（true=已分配任务）

    // 无参构造（Lombok默认生成）
    public TimeSegment() {}




    // 全参构造（按需添加）
    public TimeSegment(LocalDateTime start, LocalDateTime end, SegmentType type, boolean isHoliday) {
        this.start = start;
        this.end = end;
        this.type = type;
        this.isHoliday = isHoliday;
    }
    public TimeSegment(String key, LocalDateTime start, LocalDateTime end, int earliestTime,
                       int totalTaskTime, SegmentType type, boolean isHoliday, boolean isUsed) {
        this.key = key;
        this.start = start;
        this.end = end;
        this.earliestTime = earliestTime;
        this.totalTaskTime = totalTaskTime;
        this.type = type;
        this.isHoliday = isHoliday;
        this.isUsed = isUsed;
    }
}