package com.aps.entity.Algorithm;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Data;

/**
 * 作者：佟礼
 * 时间：2025-12-04
 */
@Data
public class OperationDependency {
    private int Id ;
    private int prevOperationId ; // 前置工序ID
    private int nextOperationId ; // 后继工序ID
    private DependencyType dependencyType=DependencyType.FinishToStart ; // 依赖类型

    /**
     * 添加构造函数以便Jackson能正确反序列化
     * 当JSON中只有单一数值时，将其作为Id字段的值
     */
    @JsonCreator
    public static OperationDependency fromInt(int id) {
        OperationDependency od = new OperationDependency();
        od.Id = id;
        return od;
    }
}
