package com.aps.service.Algorithm;

import com.aps.common.util.SnowFlackIdWorker;
import com.aps.entity.*;
import com.aps.entity.Algorithm.BOMBuildResult;
import com.aps.entity.Algorithm.IDAndChildID.GroupResult;
import com.aps.entity.Algorithm.OrderMaterial;
import com.aps.entity.Algorithm.OrderMaterialRequirement;
import com.aps.entity.basic.*;
import com.aps.mapper.RoutingHeaderMapper;
import com.aps.mapper.RoutingSupportingReplaceMapper;
import com.aps.mapper.RoutingsupportingMapper;
import com.aps.service.*;
import com.aps.service.impl.LanuchServiceImpl;
import com.aps.service.plan.MachineSchedulerService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者：佟礼
 * 时间：2025-12-08
 */
@Service
public class MaterialRequirementService {

    private List<Material> _materials;

    private List<Entry> _allOperations;

    private List<Machine> _Machines;

    private  List<GroupResult> _entryRel;

    private  List<RoutingHeader> headers;

    private  List<Routingsupporting> routingsupportings=new ArrayList<>();

    private  List<RoutingSupportingReplace> routingsupportingreplaces=new ArrayList<>();

    List<RoutingDetail> allRoutingDetails=new ArrayList<>();
    List<RoutingDetailEquip> allroutingDetailEquips=new ArrayList<>();
    List<RoutingDetailConnect> allroutingDetailconnections=new ArrayList<>();
    List<RoutingDiscreteParam> allroutingDiscreteParams=new ArrayList<>();

    @Autowired
    RoutingDetailConnectService routingDetailConnectService;


    private  List<Order> orders;

    @Autowired
    RoutingHeaderMapper routingHeaderMapper;

    @Autowired
    RoutingSupportingReplaceMapper routingSupportingReplaceMapper;

    @Autowired
    RoutingsupportingMapper routingsupportingMapper;

    @Autowired
    RoutingDataService _routingDataService;

    @Autowired
    private RoutingDiscreteParamService _routingDiscreteParamService;

    @Autowired
    private   LanuchService lanuchService;
    private  LocalDateTime baseTime ;

    private MachineSchedulerService machineScheduler;



    private GlobalParam globalParam;

    public void init(List<Material> materials,List<Order> _orders,List<Entry> allOperations,List<GroupResult> entryRel,MachineSchedulerService _machineScheduler,List<Machine> machines,GlobalParam _GlobalParam)
    {

        orders = _orders;
        _allOperations=allOperations;
        _materials=materials;
        _entryRel=entryRel;
        machineScheduler=_machineScheduler;
        _Machines=machines;
        globalParam=_GlobalParam;
    }

    /**
     * 构建多级BOM需求网络
     * @return 所有物料需求列表
     */
    public List<OrderMaterialRequirement> buildMultiLevelRequirementNetwork(LocalDateTime _baseTime) {
        baseTime=_baseTime;
        List<OrderMaterialRequirement> allRequirements = new ArrayList<>();
        List<Order> childorders = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();
        List<Machine> _newMachines = new ArrayList<>();
        List<Integer> routingIds = _allOperations.stream()
                .filter(t->t.getRoutingId()!=null)
                .map(Entry::getRoutingId)
                .distinct()
                .collect(Collectors.toList());
if(routingIds.size()==0)
{
    return  null;
}
        LambdaQueryWrapper<RoutingHeader> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(RoutingHeader::getId, routingIds)
                .eq(RoutingHeader::getIsDeleted, 0)
                .eq(RoutingHeader::getApprovalStatus, 1); // 添加 is_deleted=0 过滤条件
        headers = routingHeaderMapper.selectList(wrapper);

        LambdaQueryWrapper<Routingsupporting> routingsupportingwrapper = new LambdaQueryWrapper<>();
        routingsupportingwrapper.in(Routingsupporting::getRoutingHeaderId, routingIds)
                .eq(Routingsupporting::getIsdeleted, 0);

        routingsupportings = routingsupportingMapper.selectList(routingsupportingwrapper);
        if(routingsupportings==null||routingsupportings.size()==0)
        {
            return null;
        }
        List<String> routingsupportingids = routingsupportings.stream()
                .map(Routingsupporting::getStrId)
                .distinct()
                .collect(Collectors.toList());

        LambdaQueryWrapper<RoutingSupportingReplace> routingsupportingreplacewrapper = new LambdaQueryWrapper<>();
        routingsupportingreplacewrapper.in(RoutingSupportingReplace::getStrsupid, routingsupportingids)
                .eq(RoutingSupportingReplace::getIsdeleted, 0);

        routingsupportingreplaces = routingSupportingReplaceMapper.selectList(routingsupportingreplacewrapper);



        for (Order demand : orders) {
            // 跳过已有父订单的需求
            if (demand.getFinishOrderId() != null && !demand.getFinishOrderId().isEmpty()) {
                continue;
            }

            // 递归展开BOM层级（通过结果对象接收out参数数据）
            BOMBuildResult result = buildOrderBOM(demand.getRoutingId(),"", demand.getOrderId(), demand.getOrderId(),
                    demand.getQuantity(), 0,demand);
            allRequirements.addAll(result.getMaterialRequirements());
            childorders.addAll(result.getChildOrders());
            _newEntrys.addAll(result.getNewEntrys());
           // _newMachines.addAll(result.getNewMachines());


        }

        // 将子订单添加到全局订单列表
        if (orders != null) {
            orders.addAll(childorders);
           // _allOperations.addAll(_newEntrys);
            Set<Long> existIds = new HashSet<>();
//            _Machines.addAll(_newMachines.stream()
//                    .filter(t->existIds.add(t.getId()))//HashSet.add() 方法：添加成功返回 true，重复返回 false；
//                    .collect(Collectors.toList()));

        }

        return allRequirements;
    }

    /**
     * 构建订单BOM
     * @param parent 父项ID
     * @param materialID 物料ID
     * @param mainorderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量（Java中用double替代decimal，若需高精度可用BigDecimal）
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public BOMBuildResult buildOrderBOM(int parent, String materialID, String mainorderId,
                                        String childorderId, double parentQuantity, int level,Order forder) {

        RoutingHeader routingHeaders=  headers.stream()
                .filter(t->t.getId()==parent|| t.getMaterialId().equals(materialID))
                .findFirst()
                .orElse(null);
        List<RoutingHeader>  headers1;
        // 若未找到产品，返回空结果（根据业务可调整为抛出异常）
        if (routingHeaders==null) {


        }

        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> childorders2 = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();
        List<Machine> _newMachines = new ArrayList<>();
       // 遍历产品的工序，递归构建工序BOM

        List<Entry> Operations= _allOperations.stream()
                .filter(t->t.getOrderId().equals(childorderId))
                .collect(Collectors.toList());




         if (Operations != null) {
            for (Entry operation : Operations) {
                // 调用BuildOperationBOM方法（返回结果对象替代out参数）
                BOMBuildResult operationResult = buildOperationBOM(mainorderId, childorderId,
                        parentQuantity, operation, level,forder);
//                // 合并物料需求和子订单
                if(operationResult!=null) {
                    materialRequirements.addAll(operationResult.getMaterialRequirements());
                    childorders2.addAll(operationResult.getChildOrders());
                    _newEntrys.addAll(operationResult.getNewEntrys());
                  //  _newMachines.addAll(operationResult.getNewMachines());
                }
            }
        }

        return new BOMBuildResult(materialRequirements, childorders2,_newEntrys,_newMachines);

    }

    private  Map<Integer, Object> CreateChild(Order order,String materialID)
    {
        String sceneId="";
        Long  routingIds=0l;
        List<Routingsupporting> routingsupportings1=new ArrayList<>();
        List<RoutingSupportingReplace> routingsupportingreplaces1 =new ArrayList<>();
        RoutingHeader headers1=  headers.stream()
                .filter(t->t.getMaterialId().equals(materialID))
                .findFirst().orElse(null);
        if(headers1==null) {
            LambdaQueryWrapper<RoutingHeader> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(RoutingHeader::getMaterialId, materialID)
                    .eq(RoutingHeader::getIsDeleted, 0);
                   // .eq(RoutingHeader::getApprovalStatus, 1); // 添加 is_deleted=0 过滤条件
            headers1 = routingHeaderMapper.selectOne(wrapper);
            if(headers1!=null) {
                headers.add(headers1);
                routingIds=headers1.getId().longValue();

                LambdaQueryWrapper<Routingsupporting> routingsupportingwrapper = new LambdaQueryWrapper<>();
                routingsupportingwrapper.in(Routingsupporting::getRoutingHeaderId, routingIds)
                        .eq(Routingsupporting::getIsdeleted, 0);

                 routingsupportings1 = routingsupportingMapper.selectList(routingsupportingwrapper);
                routingsupportings.addAll(routingsupportings1);

                List<String> routingsupportingids = routingsupportings1.stream()
                        .filter(t->t.getStrId()!=null)
                        .map(Routingsupporting::getStrId)
                        .distinct()
                        .collect(Collectors.toList());

                if(routingsupportingids.size()>0)
                {
                    LambdaQueryWrapper<RoutingSupportingReplace> routingsupportingreplacewrapper = new LambdaQueryWrapper<>();
                    routingsupportingreplacewrapper.in(RoutingSupportingReplace::getStrsupid, routingsupportingids)
                            .eq(RoutingSupportingReplace::getIsdeleted, 0);

                    routingsupportingreplaces1 = routingSupportingReplaceMapper.selectList(routingsupportingreplacewrapper);

                    routingsupportingreplaces.addAll(routingsupportingreplaces1);
                }

            }
        }
        else {
             routingIds=headers1.getId().longValue();



        }
        if(headers1==null)
        {
            return null;
        }
        Long headersid=routingIds;
        List<RoutingDetail> RoutingDetails=  allRoutingDetails.stream()
                .filter(t->t.getRoutingHeaderId()==headersid)
                .collect(Collectors.toList());
        List<RoutingDetailEquip> routingDetailEquips=null;
        List<RoutingDetailConnect> connections=null;
        if(RoutingDetails==null||RoutingDetails.size()==0) {
            RoutingDetails = lanuchService.getRoutingDetails(headers1.getId());
            allRoutingDetails.addAll(RoutingDetails);
             routingDetailEquips = lanuchService.getRoutingDetailEquip(headers1.getId(), headers1.getCode());
            allroutingDetailEquips.addAll(routingDetailEquips);

            LambdaQueryWrapper<RoutingDetailConnect> routingDetailConnectwrapper = new LambdaQueryWrapper<>();
            routingDetailConnectwrapper.eq(RoutingDetailConnect::getRoutingHeaderId, routingIds)
                    .eq(RoutingDetailConnect::getIsdeleted, 0); // 添加 isdeleted=0 过滤条件

            connections = routingDetailConnectService.list(routingDetailConnectwrapper);
            allroutingDetailconnections.addAll(connections);
        }
        if(routingDetailEquips==null)
        {
            routingDetailEquips=  allroutingDetailEquips.stream()
                    .filter(t->t.getRoutingHeaderId()==headersid)
                    .collect(Collectors.toList());
        }


        order.setRoutingId(headers1.getId());
        ProdLaunchOrder prodOrderMain= convertToLaunchOrder(order,"");

        List<ProdProcessExec> processExecList = RoutingDetails.stream()
                .map(detail -> lanuchService.createProcessExec(prodOrderMain, detail, sceneId))
                .collect(Collectors.toList());

        List<ProdEquipment> ProdEquipmentList=  lanuchService.batchInsertEquipMent(routingDetailEquips, sceneId,processExecList,false);



        Map<String, String> routingDetailIdToExecIdMap = processExecList.stream()
                .collect(Collectors.toMap(
                        exec -> exec.getRoutingDetailId() + "_" + exec.getOrderId(), // 复合键：工序ID_订单ID
                        ProdProcessExec::getExecId,
                        (existing, replacement) -> existing)); // 处理重复key的情况

        if(connections==null)
        {
            connections=  allroutingDetailconnections.stream()
                    .filter(t->t.getRoutingHeaderId()==headersid)
                    .collect(Collectors.toList());
        }

        List<ProdOrderProcess>  ProdOrderProcesslist=  connections.stream()
                .map(connection -> lanuchService.createProcessRelation(prodOrderMain, connection, sceneId, routingDetailIdToExecIdMap))
                .collect(Collectors.toList());

        List<Long> routingDetailIds = RoutingDetails.stream()
                .map(RoutingDetail::getId)
                .distinct()
                .collect(Collectors.toList());

        List<RoutingDiscreteParam> routingDiscreteParams=  allroutingDiscreteParams.stream()
                .filter(t->routingDetailIds.contains(t.getRoutingDetailId()))
                .collect(Collectors.toList());
        if(routingDiscreteParams==null||routingDiscreteParams.size()==0) {
             routingDiscreteParams = _routingDiscreteParamService.lambdaQuery()
                    .in(RoutingDiscreteParam::getRoutingDetailId, routingDetailIds)
                    .eq(RoutingDiscreteParam::getIsDeleted, 0)
                    .list();
             allroutingDiscreteParams.addAll(routingDiscreteParams);
        }



        List<Order> ProdLaunchOrders=new ArrayList<>();
        ProdLaunchOrders.add(order);

        Map<Integer, Object> list=_routingDataService.CreateEntry( sceneId,  ProdEquipmentList,  ProdLaunchOrders, routingDiscreteParams, ProdOrderProcesslist, processExecList,_entryRel );

       // List<Machine> machines=  _routingDataService.InitCalendarToAllMachines(sceneId,ProdEquipmentList,machineScheduler, globalParam.isIsUseCalendar());


        if(list.get(1)!=null)
        {
            _allOperations.addAll((List<Entry>)list.get(1));
            _entryRel=(List<GroupResult>)list.get(2);
        }
        Map<Integer, Object> rest=new HashMap<>();
        rest.put(1,list.get(1));
      //  rest.put(2,machines);
        return rest;
    }

    private ProdLaunchOrder convertToLaunchOrder(Order order, String sceneId) {
        try {
            ProdLaunchOrder launchOrder = new ProdLaunchOrder();
            launchOrder.setOrderId(order.getOrderId());
            launchOrder.setSceneId(sceneId);
            launchOrder.setSerie(order.getSerie());
            launchOrder.setCreateUser("GA");
            launchOrder.setMaterialCode(order.getMaterialCode());
//            launchOrder.setStartDate(order.get);
            launchOrder.setEndDate(order.getDueDate());
//            launchOrder.setOrderPriority(order.getPrioritry());
            launchOrder.setOrderPriority(order.getPriority());
            launchOrder.setQuantity(order.getQuantity());
            launchOrder.setMaterialId(order.getMaterialId());


            launchOrder.setRoutingId(order.getRoutingId());
            launchOrder.setRoutingCode("");


            return launchOrder;
        } catch (Exception e) {

            return null;
        }
    }



    /**
     * 构建工序BOM需求
     * @param orderId 主订单ID
     * @param childorderId 子订单ID
     * @param parentQuantity 父项数量
     * @param operation 工序对象
     * @param level 层级
     * @return 包含物料需求列表和子订单列表的结果对象（替代C#的out参数）
     */
    public BOMBuildResult buildOperationBOM(String orderId, String childorderId, double parentQuantity,
                                            Entry operation, int level,Order forder) {
        List<OrderMaterialRequirement> materialRequirements = new ArrayList<>();
        List<Order> _childorders = new ArrayList<>();
        List<Entry> _newEntrys = new ArrayList<>();
        List<Machine> _newMachines = new ArrayList<>();
        List<Routingsupporting> MaterialRequirements=  routingsupportings.stream()
                .filter(t->t.getRoutingDetailId().equals(operation.getRoutingDetailId()))
                .collect(Collectors.toList());

        if (MaterialRequirements != null&&MaterialRequirements.size()>0) {
            for (Routingsupporting component : MaterialRequirements) {


                double allneeded = parentQuantity * component.getMainQty().doubleValue();

                double needed = allneeded;

                // 查找物料（流式处理替代First）
                Material material = _materials.stream()
                        .filter(m -> m.getId().equals(component.getMaterialId()))
                        .findFirst()
                        .orElse(null);
                if (material == null) {
                    return null;
                }

                OrderMaterialRequirement orderMaterial= MaterialStock(material,"",orderId,childorderId,operation,allneeded,needed);
                double useStock=0;
                if(orderMaterial!=null) {
                    useStock = orderMaterial.getUseStock();
                    materialRequirements.add(orderMaterial);
                    orderMaterial.setLevel(level);
                }
                orderMaterial.setMaterialCode(component.getMaterialNumber());
                orderMaterial.setMaterialName(component.getMaterialName());
                needed -= useStock;
                if (needed <= 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);
                    continue;
                }

                List<RoutingSupportingReplace> routingsupportingreplaces2 = routingsupportingreplaces.stream().filter(t->t.getStrsupid().equals(component.getStrId())&&t.getMaterialid()!=component.getMaterialId()).collect(Collectors.toList());
                if (routingsupportingreplaces2 != null && routingsupportingreplaces2.size() > 1)
                {
                    for (RoutingSupportingReplace rsr:routingsupportingreplaces2) {
                        OrderMaterialRequirement orderMaterial1= MaterialStock(null,rsr.getMaterialid(),orderId,childorderId,operation,allneeded,needed);
                        if(orderMaterial1!=null) {
                            useStock = orderMaterial1.getUseStock();
                            needed -= useStock;
                            orderMaterial.setUseStock(orderMaterial.getUseStock()+useStock);
                            orderMaterial.getReplaceMaterial().add(orderMaterial1);
                            if (needed <= 0) {
                                break;
                            }
                        }
                    }
                }
                if (needed <= 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);
                    continue;
                }
                MaterialInTransit(material,"",orderMaterial,needed);

                needed -= orderMaterial.getUseTransit();

                if (routingsupportingreplaces2 != null && routingsupportingreplaces2.size() > 1)
                {
                    for (RoutingSupportingReplace rsr:routingsupportingreplaces2) {

                        OrderMaterialRequirement  orderMaterial1=    orderMaterial.getReplaceMaterial().stream()
                                .filter(t->t.getMaterialId().equals(rsr.getMaterialid()))
                                .findFirst()
                                .orElse(null);

                         MaterialInTransit(null,rsr.getMaterialid(),orderMaterial1,needed);


                            needed -= orderMaterial1.getUseTransit();
                       LocalDateTime earliestTime= orderMaterial.getArrivalTime().compareTo(orderMaterial1.getArrivalTime())>0?orderMaterial.getArrivalTime():orderMaterial1.getArrivalTime();
                        orderMaterial.setArrivalTime(earliestTime);
                            orderMaterial.setUseTransit(orderMaterial.getUseTransit()+orderMaterial1.getUseTransit());
                            if (needed <= 0) {
                                break;
                            }
                        }
                    }

            if (needed <= 0) {
                orderMaterial.setYpQty(allneeded - needed);
                orderMaterial.setQjQty(needed);
                continue;
            }
                if (needed > 0) {
                    orderMaterial.setYpQty(allneeded - needed);
                    orderMaterial.setQjQty(needed);

                    if (material.getMaterialTypeName().equals("MP") ) {
                        // 处理原材料采购时间
                        orderMaterial.setPurchaseStartTime(baseTime);
                        // 采购结束时间 = 采购开始时间 + 采购提前期（天）
                        LocalDateTime purchaseEndTime = baseTime.plusDays(material.getPurchaseLeadTime());
                        orderMaterial.setPurchaseEndTime(purchaseEndTime);
                    } else {
                        // 处理半成品/成品的现有订单


                        List<Order> orders2 = orders.stream()
                                .filter(t -> t.getMaterialId().equals(material.getId())  && t.getSYQuantity() > 0)
                                .sorted(Comparator.comparing(Order::getDueDate))
                                .collect(Collectors.toList());

                        if (!orders2.isEmpty()) {
                            for (Order order : orders2) {
                                if (order.getFinishOrderId() == null) {
                                    order.setFinishOrderId(new ArrayList<>());
                                }
                                order.getFinishOrderId().add(forder.getId());
                                orderMaterial.getProductOrderID().add(forder.getId());

                                double useq = Math.min(needed, order.getSYQuantity());
                                needed -= useq;
                                order.setSYQuantity(order.getSYQuantity() - useq);

                                if (order.getFinishOrderId().size() == 1) {
                                    // 递归构建BOM
                                    int l = level + 1;

                                    BOMBuildResult childResult = buildOrderBOM(0, material.getId(),
                                            orderId, order.getOrderId(),
                                            order.getQuantity(), l,order);
                                    materialRequirements.addAll(childResult.getMaterialRequirements());
                                    _childorders.addAll(childResult.getChildOrders());
                                    _newEntrys.addAll(childResult.getNewEntrys());
                                    _newMachines.addAll(childResult.getNewMachines());
                                    operation.getDependentOnOrderIds().add(order.getId());
                                }

                                if (needed <= 0) {
                                    break;
                                }
                            }
                        }

                        // 更新已配和缺件数量
                        orderMaterial.setYpQty(allneeded - needed);
                        orderMaterial.setQjQty(needed);

                        if (needed > 0&&globalParam.isIsCheckSf()) {
                            // 创建新的子订单
                            Order childorder = new Order();
                            String OrderId = UUID.randomUUID().toString().replace("-", "");

                            childorder.setOrderId(OrderId);
                            childorder.setMaterialId(material.getId());
                            childorder.setMaterialCode(material.getCode());
                            childorder.setOrderCode(material.getCode());
                            childorder.setQuantity((int) orderMaterial.getQjQty());
                            childorder.setFinishOrderId(new ArrayList<>());
                            childorder.getFinishOrderId().add(forder.getId());
                            childorder.setSerie(forder.getSerie());

                            childorder.setStartDate(forder.getStartDate());
                            childorder.setDueDate(forder.getDueDate());
                            childorder.setPriority(forder.getPriority());
                            childorder.setActualPriority(forder.getActualPriority());


                            Map<Integer, Object> list= CreateChild(childorder,material.getId());
                            if(list==null)
                            {
                                continue;
                            }
                            _childorders.add(childorder);
                            List<Entry>  newentrys=(List<Entry>)list.get(1);
                            _newEntrys.addAll(newentrys);
                           // _newMachines.addAll((List<Machine>)list.get(2));
                            orderMaterial.getProductOrderID().add(childorder.getId());
                            operation.getDependentOnOrderIds().add(childorder.getId());
                            // 递归构建BOM
                            int l = level + 1;
                            BOMBuildResult childResult = buildOrderBOM(0, material.getId(),
                                    orderId, childorder.getOrderId(),
                                    childorder.getQuantity(), l,childorder);
                            materialRequirements.addAll(childResult.getMaterialRequirements());
                            _childorders.addAll(childResult.getChildOrders());
                            _newEntrys.addAll(childResult.getNewEntrys());
                          //  _newMachines.addAll(childResult.getNewMachines());
                        }
                    }
                }

                // 计算预计可用时间
                LocalDateTime arrivalTime = orderMaterial.getArrivalTime();
                LocalDateTime purchaseEndTime = orderMaterial.getPurchaseEndTime();
                LocalDateTime useTime = null;

                if (arrivalTime == null) {
                    useTime = purchaseEndTime;
                } else {
                    if (purchaseEndTime != null && purchaseEndTime.isAfter(arrivalTime)) {
                        useTime = purchaseEndTime;
                    } else {
                        useTime = arrivalTime;
                    }
                }
                orderMaterial.setUseTime(useTime);
            }
        }

        return new BOMBuildResult(materialRequirements, _childorders,_newEntrys,_newMachines);
    }

    private OrderMaterialRequirement MaterialStock(Material material,String materialId,String orderId, String childorderId, Entry operation,double allneeded, double needed ) {

        OrderMaterialRequirement orderMaterial = new OrderMaterialRequirement();
        orderMaterial.setOrderId(orderId);
        orderMaterial.setOperationId(operation.getId());
        orderMaterial.setChildorderId(StringUtils.isBlank(childorderId) ? orderId : childorderId);
        orderMaterial.setRequiredQuantity(allneeded);
        if (material == null) {
            material = _materials.stream()
                    .filter(m -> m.getId().equals(materialId))
                    .findFirst()
                    .orElse(null);
            if (material == null) {
                return null;
            }

        }
        double availableNow = material.getCurrentStock();
        orderMaterial.setMaterialCode(material.getCode());
        orderMaterial.setMaterialName(material.getName());
        orderMaterial.setMaterialTypeName(material.getMaterialTypeName());
        orderMaterial.setMaterialId(material.getId());
        orderMaterial.setCkeckLeadTime(material.getCkeckLeadTime());

        // 扣减现有库存


        double useStock = Math.min(needed, availableNow);

        material.setCurrentStock(material.getCurrentStock() - useStock);
        orderMaterial.setUseStock(useStock);

        return orderMaterial;
    }
    private void MaterialInTransit(Material material,String materialId, OrderMaterialRequirement orderMaterial, double needed ){

        // 处理在途物料
        double accumulated = 0;
        LocalDateTime earliestTime = LocalDateTime.of(2000,1,1,0,0,0);
        double useTransit = 0;
        if (material == null) {
            material = _materials.stream()
                    .filter(m -> m.getId().equals(materialId))
                    .findFirst()
                    .orElse(null);
            if (material == null) {
                return ;
            }

        }
        // 按到货时间排序在途物料
        List<MaterialSupply> sortedInTransit = material.getInTransit().stream()
                .filter(t -> t.getQuantity() > 0)
                .sorted(Comparator.comparing(MaterialSupply::getArrivalTime))
                .collect(Collectors.toList());

        for (MaterialSupply supply : sortedInTransit) {
            double useq = Math.min(needed, supply.getQuantity());
            useTransit += useq;
            needed -= useq;
            supply.setQuantity(supply.getQuantity() - useq);
            earliestTime=earliestTime.compareTo(supply.getArrivalTime())>0?earliestTime:supply.getArrivalTime();
            if (needed <= 0) {
                break;
            }
        }

        orderMaterial.setUseTransit(useTransit);
        orderMaterial.setArrivalTime(earliestTime);

    }
}
