package com.example.controller;

import com.example.entity.MaterialInfo;
import com.example.service.MaterialInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 物料主数据表 前端控制器
 * </p>
 *
 * @author yourName
 * @since 2025-09-25
 */
@RestController
@RequestMapping("/materialInfo")
@Api(tags = "测试接口")
public class MaterialInfoController {

    @Autowired
    MaterialInfoService  materialInfoService;
    @ApiOperation(value = "获取物料列表", notes = "返回所有用物料据", httpMethod = "GET")
    @RequestMapping("/test")
    public MaterialInfo test(){
        List<MaterialInfo> list = materialInfoService.list();



        return list.get(0);
    }

}
