package com.example.generator;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import java.util.Collections;

public class CodeGenerator1 {
    public static void main(String[] args) {
        // 1. 配置数据库连接
        FastAutoGenerator.create(
                "jdbc:mysql://192.168.0.181:3310/mes?useSSL=false&serverTimezone=UTC",
                "root",
                "root_mes@123456~"
            )
            // 2. 全局配置
            .globalConfig(builder -> {
                builder.author("yourName") // 作者名
                        .outputDir(System.getProperty("user.dir") + "/src/main/java") // 代码输出目录
                        .disableOpenDir(); // 生成后不打开文件夹
            })
            // 3. 包配置
            .packageConfig(builder -> {
                builder.parent("com.example") // 父包名
                        .entity("entity") // 实体类包
                        .mapper("mapper") // Mapper接口包
                        .service("service") // Service接口包
                        .serviceImpl("service.impl") // Service实现包
                        .controller("controller") // Controller包
                        // Mapper XML文件输出路径
                        .pathInfo(Collections.singletonMap(
                                OutputFile.xml, 
                                System.getProperty("user.dir") + "/src/main/resources/mapper"
                        ));
            })
            // 4. 策略配置
            .strategyConfig(builder -> {
                builder.addInclude("material_info") // 需要生成的表名
                        // 实体类策略
                        .entityBuilder()
                        .enableLombok() // 启用Lombok
                        .enableTableFieldAnnotation() // 字段添加注解
                        // Controller策略
                        .controllerBuilder()
                        .enableRestStyle() // 生成REST风格接口
                        // Service策略
                        .serviceBuilder()
                        .formatServiceFileName("%sService") // Service命名格式
                        // Mapper策略
                        .mapperBuilder()
                        .enableBaseResultMap() // 生成BaseResultMap
                        .enableBaseColumnList(); // 生成BaseColumnList
            })
            // 5. 模板引擎（改用Velocity）
            .templateEngine(new VelocityTemplateEngine())
            // 执行生成
            .execute();
            
        System.out.println("代码生成完成！");
    }
}