package com.aps.service.impl;

import com.aps.entity.Config;
import com.aps.entity.ConfigSetting;
import com.aps.mapper.ConfigMapper;
import com.aps.service.ConfigService;
import com.aps.common.util.EnhancedJsonConversionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * <p>
 * 用户配置 服务实现类
 * </p>
 *
 * @author MyBatis-Plus
 * @since 2025-12-10
 */
@Service
public class ConfigServiceImpl extends ServiceImpl<ConfigMapper, Config> implements ConfigService {
    
    private static final Logger logger = LoggerFactory.getLogger(ConfigServiceImpl.class);

    
    /**
     * 简单校验是否为有效的JSON数组格式
     * @param jsonString 待校验的字符串
     * @return 是否为有效的JSON数组
     */
    private boolean isValidJsonArray(String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return false;
        }
        
        String trimmed = jsonString.trim();
        return trimmed.startsWith("[") && trimmed.endsWith("]");
    }

    @Override
    public List<ConfigSetting> getComponentSettingsByPageAndNote(Long id, String component) {


             Config config = this.lambdaQuery()
                .eq(Config::getId, id)
                .eq(Config::getComponent, component)
                .one();


        if (config != null && config.getContent() != null && !config.getContent().isEmpty()) {
            try {
                // 使用EnhancedJsonConversionUtil将JSON字符串转换为ConfigSetting实体列表
                return EnhancedJsonConversionUtil.convertJsonToEntities(config.getContent(), null, ConfigSetting.class);
            } catch (Exception e) {
                logger.error("解析配置组件数据时发生错误");
            }

    }

        return null;
        }

}