﻿namespace HYH.Registry
{
    public class RegistryConsts
    {
        public const string LocalizationSourceName = "Registry";

        public const string ConnectionStringName = "Default";

        /// <summary>
        /// 审核状态
        /// </summary>
        public enum AuditStatus
        {
            /// <summary>
            /// 初始创建
            /// </summary>
            Initial = 0,
            /// <summary>
            /// 审核中
            /// </summary>
            Auditing = 1,
            /// <summary>
            /// 审核通过
            /// </summary>
            Passed = 2,
            /// <summary>
            /// 驳回
            /// </summary>
            Rejected = 3
        }

        /// <summary>
        /// 驳回类型
        /// </summary>
        public enum RejectType
        {
            /// <summary>
            /// 返回第一个节点
            /// </summary>
            ReturnToFirstNode = 0,
            /// <summary>
            /// 返回上一节点
            /// </summary>
            ReturnToPreviousNode = 1,
            /// <summary>
            /// 手动指定返回的节点
            /// </summary>
            ReturnByManual =2,
            /// <summary>
            /// 流程终止
            /// </summary>
            Terminated  =3
        }

        /// <summary>
        /// 节点分类
        /// </summary>
        public enum NodeCategory
        {
            /// <summary>
            /// 启动节点
            /// </summary>
            Start = 0,
            /// <summary>
            /// 条件节点
            /// </summary>
            Condition = 1,
            /// <summary>
            /// 处理节点
            /// </summary>
            Process = 2,
            /// <summary>
            /// 结束节点
            /// </summary>
            End = 3
        }
    }
}