﻿using Abp.Timing;
using HYH.AspNetCore;
using Microsoft.AspNetCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using System.IO;

namespace HYH.Registry.Web.Host.Startup
{
    public class Program
    {
        private const string serviceAddressKey = "App:ServerAddress";

        public static void Main(string[] args)
        {
            Clock.Provider = ClockProviders.Local;
            BuildWebHost(args).Run();
        }

        public static IWebHost BuildWebHost(string[] args)
        {
            var configurationBuilder = new ConfigurationBuilder()
              .SetBasePath(Directory.GetCurrentDirectory())
              .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true).Build();
            string url = configurationBuilder[serviceAddressKey];

            var hostBuilder = WebHost.CreateDefaultBuilder(args)
                .ConfigureApollo();

            hostBuilder = hostBuilder.ConfigureAppConfiguration((hostContext, builder) =>
            {
                if (args != null)
                {
                    builder.AddCommandLine(args);
                }
            });

            return hostBuilder.UseKestrel()
                .UseContentRoot(Directory.GetCurrentDirectory())
                .UseUrls(url)
                .UseStartup<Startup>()
                .Build();
        }
    }
}
