﻿using Abp.Application.Services;
using Abp.Domain.Repositories;
using HYH.AspNetCore;
using HYH.Core.DbModels;
using HYH.Registry.DbModels;
using HYH.Registry.EntityFrameworkCore;
using HYH.SqlSugarCore;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HYH.Registry.Services.Encryption
{
    /// <summary>
    /// 
    /// </summary>
    public class EncryptionService : ApplicationService
    {
        private readonly ICurrentUser _currentUser;
        private readonly IRepository<Tenant, int> _repTenant;

        /// <summary>
        /// 构造函数
        ///</summary>
        public EncryptionService(
            ICurrentUser currentUser,
            IRepository<Tenant, int> repTenant
            )
        {
            _currentUser = currentUser;
            _repTenant = repTenant;


        }
        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetMACAddress()
        {
            string MACAddress = ComputerInfoHelper.GetMACAddress();
            return MACAddress;
        }
        /// <summary>
        /// 获取合成码
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetGeneratedCode()
        {
            string data = ComputerInfoHelper.GetMACAddress();
            //string hostName = ComputerInfoHelper.GetHostName();
            //string data = netCardMACAddress;
            var result = AESHelper.AESEncrypt(data, "jianzhukeji", "jzkj");
            return result;
        }
        /// <summary>
        /// 生成授权码
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpPost]
        public string GetGeneratingCiphertext(EncryptionDto input)
        {
            // 解密
            string data = AESHelper.AESDecrypt(input.CipherText, "jianzhukeji", "jzkj");
            // 到期时间
            string timeStr = Convert.ToDateTime(input.ExpirationDate).ToString("yyyy-MM-dd HH:mm:ss");
            // 公司名称
            string companyName = input.CompanyName;

            data = timeStr + data + companyName;
            data = data.PadRight(72);
            // 加密
            var result = AESHelper.AESEncrypt(data, "jianzhukeji", "jzkj");
            return result;
        }
        /// <summary>
        /// 保存加密后的密文到数据库租户表
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpPost]
        public async Task<IActionResult> SaveCiphertext(SaveCiphertextDto input)
        {
            var tenant = _repTenant.FirstOrDefault(q => q.Code == input.TenantCode);
            tenant.RegistryCipher = input.AuthorizationCode;
            await _repTenant.UpdateAsync(tenant);
            return new JsonResult(true);
        }
        /// <summary>
        /// 登录的密文验证
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpPost]
        public async Task<IActionResult> LoginCipherCertification(LoginVerifyCiphertextDto input)
        {
            bool flag = false;
            try
            {
                string netCardMACAddress = ComputerInfoHelper.GetMACAddress();
                var tenant = await _repTenant.FirstOrDefaultAsync(q => q.Code == input.TenantCode);
                if (!string.IsNullOrEmpty(tenant.RegistryCipher))
                {
                    // 解密
                    var dataString = AESHelper.AESDecrypt(tenant.RegistryCipher, "jianzhukeji", "jzkj");
                    string timeStr = dataString.Substring(0, 19);
                    DateTime dateTime = Convert.ToDateTime(timeStr);
                    if (dateTime > DateTime.Now && !string.IsNullOrEmpty(netCardMACAddress) && dataString.Contains(netCardMACAddress))
                    {
                        flag = true;
                    }
                }
            }
            catch (Exception ex)
            {
                string str = ex.Message;
            }

            return new JsonResult(flag);
        }


        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetNetCardMACAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.GetNetCardMACAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取所有Mac地址
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string PrintAllMacAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.PrintAllMacAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取第一个mac地址
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetFirstMacAddress()
        {
            string netCardMACAddress = ComputerInfoHelper.GetFirstMacAddress();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取Mac地址
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetMACIp()
        {
            string netCardMACAddress = ComputerInfoHelper.GetMACIp();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取电脑名称
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetName()
        {
            string netCardMACAddress = ComputerInfoHelper.GetHostName();
            return netCardMACAddress;
        }
        /// <summary>
        /// 获取硬盘序列号
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        [HttpGet]
        public string GetHardDiskSerialNumber()
        {
            string hardDiskSerialNumber = ComputerInfoHelper.GetHardDiskSerialNumber();
            return hardDiskSerialNumber;
        }

        ///// <summary>
        ///// 获取内网ip
        ///// </summary>
        ///// <returns></returns>
        //public async Task<object> GetInternalIP()
        //{
        //    var InternalIP = ComputerInfoHelper.GetInternalIP();
        //    return InternalIP.ToString();
        //}

    }
}
