using System;
using Abp.Domain.Entities.Auditing;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
namespace HYH.Registry.DbModels
{
    /// <summary>
    /// author: henq
    /// time: 2019/12/4 18:27:14
    ///
    ///</summary>
    [Table("MaterialPlacode")]
    public class MaterialPlacode: FullAuditedEntity
    {
/// <summary>
/// 基板编码
/// </summary>
[StringLength(200)]
[Column("substrate_coding")]
public string SubstrateCoding { get; set; }
/// <summary>
/// 基板材质
/// </summary>
[StringLength(200)]
[Column("base_material")]
public string BaseMaterial { get; set; }
/// <summary>
/// 材料编号
/// </summary>
[StringLength(200)]
[Column("material_number")]
public string MaterialNumber { get; set; }
/// <summary>
/// 适用设备
/// </summary>
[StringLength(200)]
[Column("apply_to_equipment")]
public string ApplyToEquipment { get; set; }
/// <summary>
/// 厚度
/// </summary>
public double Thickness { get; set; }
/// <summary>
/// 状态
/// </summary>
public Int16 State { get; set; }
/// <summary>
/// 所处位置
/// </summary>
[StringLength(200)]
public string Location { get; set; }
/// <summary>
/// 库存
/// </summary>
public double Inventory { get; set; }
/// <summary>
/// 最低库存
/// </summary>
[Column("minimum_inventory")]
public double MinimumInventory { get; set; }
/// <summary>
/// 可用库存
/// </summary>
[Column("available_in_stock")]
public double AvailableInStock { get; set; }
    }
    }