import Vue from 'vue'
import ViewUI from 'view-design'
import VueI18n from 'vue-i18n';
import Languages from '@/i18n/locale';
import VueDND from 'awe-dnd'
// import iViewPro from '@/libs/iViewPro/iview-pro.min.js';
// import  '@/libs/iViewPro/iview-pro.css';
import iViewPro from '../iview-pro/src/index.js';
// import '@/libs/iview-pro/iview-pro.css';

import '@/styles/index.less';
import '@/libs/iview-pro/iview-pro.css';
// 内置组件
import iLink from '@/components/link';
Vue.component("iLink", iLink)
export default ({
    app,
    store
  }) => {
    Vue.use(VueI18n)
    Vue.use(VueDND)
    app.i18n = new VueI18n({
      locale: 'zh-CN',
      messages: Languages
    });
    app.i18n.locale = "zh-CN"
    Vue.use(ViewUI, {
      // locale:'zh-CN',
      i18n: (key, value) => app.i18n.t(key, value)
    })
    Vue.use(iViewPro);
  
    // Vue.directive('paste', {
    //   bind(el, binding, vnode) {
    //     el.addEventListener('paste', function (event) { //这里直接监听元素的粘贴事件
    //       binding.value(event)
    //     })
    //   }
    // })
    // console.warn("this:",app.i18n.locale,app)
  }